/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.fop.viewer.Translator;

public class MessagesDialog
extends JOptionPane {
    static Translator res;
    static String DETAIL_OPTION;
    static String YES_OPTION;
    static String NO_OPTION;
    static String CANCEL_OPTION;
    static String OK_OPTION;
    static String[] defaultDetailOption;
    static String[] yesNoDetailOption;
    static String[] yesNoCancelDetailOption;
    static String[] okCancelDetailOption;
    static String[] defaultOption;
    static String[] yesNoOption;
    static String[] yesNoCancelOption;
    static String[] okCancelOption;
    protected String detailInformation = null;
    protected JDialog dialog = null;
    protected boolean showsDetails = false;

    public MessagesDialog(Object message, int messageType, int optionType, Icon icon, Object[] options, Object initialValue) {
        super(message, messageType, optionType, icon, options, initialValue);
        this.setMinimumSize(new Dimension(240, 96));
    }

    protected void displayDetails(JDialog dialog) {
        if (this.getDetailInformation() != null && dialog != null && !this.showsDetails) {
            this.showsDetails = true;
            JScrollPane aScrollPane = new JScrollPane();
            JTextArea aTextArea = new JTextArea();
            StringWriter aStringWriter = new StringWriter();
            aTextArea.setText(this.getDetailInformation());
            aTextArea.setEditable(false);
            aScrollPane.getViewport().add((Component)aTextArea, null);
            dialog.getContentPane().add((Component)aScrollPane, "South");
            aScrollPane.setPreferredSize(new Dimension(320, 240));
            dialog.pack();
        }
    }

    public String getDetailInformation() {
        return this.detailInformation;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    private static void iniConstants() {
        DETAIL_OPTION = res.getString("Details");
        YES_OPTION = res.getString("Yes");
        NO_OPTION = res.getString("No");
        CANCEL_OPTION = res.getString("Cancel");
        OK_OPTION = res.getString("Ok");
        defaultDetailOption = new String[]{OK_OPTION, DETAIL_OPTION};
        yesNoDetailOption = new String[]{YES_OPTION, NO_OPTION, DETAIL_OPTION};
        yesNoCancelDetailOption = new String[]{YES_OPTION, NO_OPTION, CANCEL_OPTION, DETAIL_OPTION};
        okCancelDetailOption = new String[]{OK_OPTION, CANCEL_OPTION, DETAIL_OPTION};
        defaultOption = new String[]{OK_OPTION};
        yesNoOption = new String[]{YES_OPTION, NO_OPTION};
        yesNoCancelOption = new String[]{YES_OPTION, NO_OPTION, CANCEL_OPTION};
        okCancelOption = new String[]{OK_OPTION, CANCEL_OPTION};
    }

    public void setDetailInformation(String aValue) {
        this.detailInformation = aValue;
    }

    public void setDialog(JDialog aValue) {
        this.dialog = aValue;
    }

    public static void setTranslator(Translator aRes) {
        res = aRes;
        MessagesDialog.iniConstants();
    }

    public void setValue(Object aValue) {
        if (aValue != null && DETAIL_OPTION.equals(aValue)) {
            this.displayDetails(this.getDialog());
        } else {
            super.setValue(aValue);
        }
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        Object[] options;
        switch (optionType) {
            case 0: {
                options = yesNoOption;
                break;
            }
            case 1: {
                options = yesNoCancelOption;
                break;
            }
            case 2: {
                options = okCancelOption;
                break;
            }
            default: {
                options = defaultOption;
            }
        }
        MessagesDialog pane = new MessagesDialog(message, messageType, -1, null, options, options[0]);
        pane.setInitialValue(options[0]);
        JDialog dialog = pane.createDialog(parentComponent, title);
        pane.setDialog(dialog);
        pane.selectInitialValue();
        dialog.show();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (selectedValue.equals(OK_OPTION)) {
            return 0;
        }
        if (selectedValue.equals(CANCEL_OPTION)) {
            return 2;
        }
        if (selectedValue.equals(YES_OPTION)) {
            return 0;
        }
        if (selectedValue.equals(NO_OPTION)) {
            return 1;
        }
        return -1;
    }

    public static int showDetailDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, String newDetailInformation) {
        Object[] options;
        switch (optionType) {
            case 0: {
                options = yesNoDetailOption;
                break;
            }
            case 1: {
                options = yesNoCancelDetailOption;
                break;
            }
            case 2: {
                options = okCancelDetailOption;
                break;
            }
            default: {
                options = defaultDetailOption;
            }
        }
        MessagesDialog pane = new MessagesDialog(message, messageType, -1, icon, options, options[0]);
        pane.setDetailInformation(newDetailInformation);
        pane.setInitialValue(options[0]);
        JDialog dialog = pane.createDialog(parentComponent, title);
        pane.setDialog(dialog);
        pane.selectInitialValue();
        dialog.show();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (((String)selectedValue).equals(DETAIL_OPTION)) {
            return -1;
        }
        if (selectedValue.equals(OK_OPTION)) {
            return 0;
        }
        if (selectedValue.equals(CANCEL_OPTION)) {
            return 2;
        }
        if (selectedValue.equals(YES_OPTION)) {
            return 0;
        }
        if (selectedValue.equals(NO_OPTION)) {
            return 1;
        }
        return -1;
    }
}

