/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.lindfors.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class Trace {
    private static final boolean trace = true;
    private static final String lineSeparator = System.getProperty("line.separator");
    private static Writer out = null;
    private static int tabcount;

    private Trace() {
    }

    public static void enter(Object object, String string) {
        Trace.push(object.getClass().getName() + "." + string);
    }

    public static void exit() {
        Trace.pop();
    }

    public static void msg(String string) {
        Trace.write(string);
    }

    private static void write(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Trace.addDateTime(stringBuffer);
            Trace.addTabCount(stringBuffer);
            stringBuffer.append(string);
            stringBuffer.append(lineSeparator);
            out.write(stringBuffer.toString());
            out.flush();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private static synchronized void push(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Trace.addDateTime(stringBuffer);
            Trace.addTabCount(stringBuffer);
            stringBuffer.append("--> ENTER ");
            stringBuffer.append(string);
            stringBuffer.append(lineSeparator);
            out.write(stringBuffer.toString());
            out.flush();
            ++tabcount;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private static synchronized void pop() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (tabcount > 0) {
                --tabcount;
            }
            Trace.addDateTime(stringBuffer);
            Trace.addTabCount(stringBuffer);
            stringBuffer.append("<-- EXIT");
            stringBuffer.append(lineSeparator);
            out.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private static synchronized void addTabCount(StringBuffer stringBuffer) {
        int n = 0;
        while (n < tabcount) {
            stringBuffer.append("    ");
            ++n;
        }
    }

    private static void addDateTime(StringBuffer stringBuffer) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2, Locale.getDefault());
        stringBuffer.append("[");
        stringBuffer.append(dateFormat.format(new Date(System.currentTimeMillis())));
        stringBuffer.append("] ");
    }

    static {
        try {
            File file = new File("trace.txt");
            out = new FileWriter(file);
        }
        catch (IOException iOException) {
            System.err.println("Unable to open trace file: " + iOException.getMessage());
        }
        tabcount = 0;
    }
}

