/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.dynprop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Random;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.MissingMandatoryProperty;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.PropertyTypeMismatch;
import org.omg.CosTrading.ReadonlyDynamicProperty;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterPackage.InterfaceTypeMismatch;
import org.omg.CosTrading.RegisterPackage.InvalidObjectRef;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingDynamic.DynamicProp;
import org.omg.CosTradingDynamic.DynamicPropEval;
import org.omg.CosTradingDynamic.DynamicPropEvalHelper;
import org.omg.CosTradingDynamic.DynamicPropHelper;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;

public class export {
    public static void main(String[] stringArray) {
        Property[] propertyArray;
        PropStruct[] propStructArray;
        java.lang.Object object;
        File file;
        if (stringArray.length < 1) {
            export.usage();
        }
        if (!(file = new File(stringArray[0])).exists()) {
            System.err.println("File " + stringArray[0] + " does not exist");
            export.usage();
        }
        if (!file.isFile()) {
            System.err.println(stringArray[0] + " is not a file");
            export.usage();
        }
        ORB oRB = ORB.init(stringArray, null);
        Register register = null;
        DynamicPropEval dynamicPropEval = null;
        ServiceTypeRepository serviceTypeRepository = null;
        try {
            object = new FileReader(file);
            propStructArray = new BufferedReader((Reader)object);
            propertyArray = propStructArray.readLine();
            ((InputStreamReader)object).close();
            Object object2 = oRB.resolve_initial_references("TradingService");
            if (object2 == null) {
                System.out.println("Invalid lookup object");
                System.exit(1);
            }
            Lookup lookup = LookupHelper.narrow(object2);
            register = lookup.register_if();
            object2 = oRB.string_to_object((String)propertyArray);
            if (object2 == null) {
                System.out.println("Invalid dynamic prop eval object");
                System.exit(1);
            }
            dynamicPropEval = DynamicPropEvalHelper.narrow(object2);
            serviceTypeRepository = ServiceTypeRepositoryHelper.narrow(lookup.type_repos());
        }
        catch (InvalidName invalidName) {
            System.out.println("Invalid initial reference name");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        try {
            object = new Random();
            propStructArray = new PropStruct[3];
            propStructArray[0] = new PropStruct();
            propStructArray[0].name = "name";
            propStructArray[0].value_type = oRB.get_primitive_tc(TCKind.tk_string);
            propStructArray[0].mode = PropertyMode.PROP_MANDATORY;
            propStructArray[1] = new PropStruct();
            propStructArray[1].name = "cost";
            propStructArray[1].value_type = oRB.get_primitive_tc(TCKind.tk_double);
            propStructArray[1].mode = PropertyMode.PROP_MANDATORY;
            propStructArray[2] = new PropStruct();
            propStructArray[2].name = "version";
            propStructArray[2].value_type = oRB.get_primitive_tc(TCKind.tk_string);
            propStructArray[2].mode = PropertyMode.PROP_MANDATORY;
            serviceTypeRepository.add_type("SubSvc", "IDL:SubSvc:1.0", propStructArray, new String[0]);
            for (int i = 0; i < 10; ++i) {
                propertyArray = new Property[3];
                int n = 0;
                propertyArray[n] = new Property();
                propertyArray[n].name = "name";
                propertyArray[n].value = oRB.create_any();
                propertyArray[n].value.insert_string("dyn offer #" + i);
                propertyArray[++n] = new Property();
                propertyArray[n].name = "cost";
                propertyArray[n].value = oRB.create_any();
                DynamicProp dynamicProp = new DynamicProp();
                dynamicProp.eval_if = dynamicPropEval;
                dynamicProp.returned_type = oRB.get_primitive_tc(TCKind.tk_double);
                dynamicProp.extra_info = oRB.create_any();
                dynamicProp.extra_info.insert_string("Dummy");
                DynamicPropHelper.insert(propertyArray[n].value, dynamicProp);
                propertyArray[++n] = new Property();
                propertyArray[n].name = "version";
                propertyArray[n].value = oRB.create_any();
                propertyArray[n].value.insert_string("1.0" + i);
                ++n;
                String string = register.export(register, "SubSvc", propertyArray);
                System.out.println("Offer id = " + string);
            }
        }
        catch (InvalidObjectRef invalidObjectRef) {
            System.out.println("Invalid object reference");
        }
        catch (IllegalServiceType illegalServiceType) {
            System.out.println("Illegal service type: " + illegalServiceType.type);
        }
        catch (UnknownServiceType unknownServiceType) {
            System.out.println("Unknown service type: " + unknownServiceType.type);
        }
        catch (InterfaceTypeMismatch interfaceTypeMismatch) {
            System.out.println("Interface type mismatch: " + interfaceTypeMismatch.type);
        }
        catch (IllegalPropertyName illegalPropertyName) {
            System.out.println("Illegal property name: " + illegalPropertyName.name);
        }
        catch (PropertyTypeMismatch propertyTypeMismatch) {
            System.out.println("Property type mismatch: " + propertyTypeMismatch.prop.name);
        }
        catch (ReadonlyDynamicProperty readonlyDynamicProperty) {
            System.out.println("Readonly dynamic property: " + readonlyDynamicProperty.name);
        }
        catch (MissingMandatoryProperty missingMandatoryProperty) {
            System.out.println("Missing mandatory property: " + missingMandatoryProperty.name);
        }
        catch (DuplicatePropertyName duplicatePropertyName) {
            System.out.println("Duplicate property: " + duplicatePropertyName.name);
        }
        catch (Exception exception) {
            System.out.println("Other: " + exception);
        }
        System.exit(0);
    }

    protected static void usage() {
        System.out.println("Usage: org.jacorb.trading.client.dynprop.export <dynprop-iorfile>");
        System.exit(1);
    }
}

