/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.etf.ListenerBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.factory.SSLServerSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPLoopback;
import org.jacorb.orb.iiop.IIOPLoopbackConnection;
import org.jacorb.orb.iiop.IIOPLoopbackInputStream;
import org.jacorb.orb.iiop.IIOPLoopbackOutputStream;
import org.jacorb.orb.iiop.IIOPLoopbackRegistry;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Connection;
import org.omg.SSLIOP.SSL;

public class IIOPListener
extends ListenerBase {
    private static final int MAX_SSL_OPTIONS = 126;
    private static final int MIN_SSL_OPTIONS = 26;
    private SocketFactoryManager socketFactoryManager = null;
    private ServerSocketFactory serverSocketFactory = null;
    private SSLServerSocketFactory sslServerSocketFactory = null;
    private SSLAcceptor sslAcceptor = null;
    private LoopbackAcceptor loopbackAcceptor;
    private boolean supportSSL = false;
    private int serverTimeout = 0;
    private IIOPAddress address = null;
    private IIOPAddress sslAddress = null;
    private int target_supports = 0;
    private int target_requires = 0;
    private boolean generateSSLComponents = true;
    static /* synthetic */ Class class$org$omg$SSLIOP$SSLHelper;

    public IIOPListener() {
    }

    public IIOPListener(ORB oRB) {
        super(oRB);
        this.socketFactoryManager = new SocketFactoryManager(oRB);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        String string;
        ProtocolAddressBase protocolAddressBase;
        this.configuration = (org.jacorb.config.Configuration)configuration;
        if (this.orb == null) {
            this.orb = this.configuration.getORB();
            this.socketFactoryManager = new SocketFactoryManager(this.orb);
        }
        this.logger = this.configuration.getNamedLogger("jacorb.iiop.listener");
        this.socketFactoryManager.configure(configuration);
        String string2 = configuration.getAttribute("OAAddress", null);
        if (string2 != null) {
            protocolAddressBase = this.orb.createAddress(string2);
            if (protocolAddressBase instanceof IIOPAddress) {
                this.address = (IIOPAddress)protocolAddressBase;
            }
        } else {
            int n = configuration.getAttributeAsInteger("OAPort", 0);
            string = configuration.getAttribute("OAIAddr", "");
            this.address = new IIOPAddress(string, n);
        }
        if (this.address != null) {
            this.address.configure(configuration);
        }
        if ((string2 = configuration.getAttribute("OASSLAddress", null)) != null) {
            protocolAddressBase = this.orb.createAddress(string2);
            if (protocolAddressBase instanceof IIOPAddress) {
                this.sslAddress = (IIOPAddress)protocolAddressBase;
            }
        } else {
            int n = configuration.getAttributeAsInteger("OASSLPort", 0);
            string = configuration.getAttribute("OAIAddr", "");
            this.sslAddress = new IIOPAddress(string, n);
        }
        if (this.sslAddress != null) {
            this.sslAddress.configure(configuration);
        }
        this.serverTimeout = configuration.getAttributeAsInteger("jacorb.connection.server.timeout", 0);
        this.supportSSL = configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on");
        this.target_supports = Integer.parseInt(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        this.target_supports |= 0x1A;
        this.target_requires = Integer.parseInt(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
        this.generateSSLComponents = configuration.getAttribute("jacorb.security.ssl_components_added_by_ior_interceptor", "off").equals("off");
        if (!this.isSSLRequired() || configuration.getAttributeAsBoolean("jacorb.security.ssl.always_open_unsecured_address", false)) {
            this.acceptor = new Acceptor();
            ((Acceptor)this.acceptor).init();
        }
        if (this.supportSSL) {
            this.sslAcceptor = new SSLAcceptor();
            this.sslAcceptor.init();
        }
        this.loopbackAcceptor = new LoopbackAcceptor();
        this.profile = this.createAddressProfile();
    }

    public void listen() {
        super.listen();
        if (this.sslAcceptor != null) {
            this.sslAcceptor.start();
        }
        this.loopbackAcceptor.start();
    }

    public void destroy() {
        this.loopbackAcceptor.terminate();
        if (this.sslAcceptor != null) {
            this.sslAcceptor.terminate();
        }
        super.destroy();
    }

    private boolean isSSLSupported() {
        return this.supportSSL;
    }

    private boolean isSSLRequired() throws ConfigurationException {
        if (this.isSSLSupported()) {
            return (this.target_requires & 0x7E) != 0;
        }
        return false;
    }

    private int getServerTimeout() {
        return this.serverTimeout;
    }

    private ServerSocketFactory getServerSocketFactory() {
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = this.socketFactoryManager.getServerSocketFactory();
        }
        return this.serverSocketFactory;
    }

    private SSLServerSocketFactory getSSLServerSocketFactory() {
        if (this.sslServerSocketFactory == null) {
            this.sslServerSocketFactory = this.orb.getBasicAdapter().getSSLSocketFactory();
            if (this.sslServerSocketFactory == null) {
                throw new INITIALIZE("No SSL server socket factory found");
            }
        }
        return this.sslServerSocketFactory;
    }

    private IIOPProfile createAddressProfile() throws ConfigurationException {
        if (this.acceptor != null) {
            if (this.address.getPort() == 0) {
                this.address.setPort(((Acceptor)this.acceptor).getLocalAddress().getPort());
            }
        } else if (this.sslAcceptor == null) {
            throw new INITIALIZE("no acceptors found, cannot create address profile");
        }
        IIOPProfile iIOPProfile = new IIOPProfile(this.address, null);
        if (this.sslAcceptor != null && this.generateSSLComponents) {
            iIOPProfile.addComponent(20, this.createSSL(), class$org$omg$SSLIOP$SSLHelper == null ? (class$org$omg$SSLIOP$SSLHelper = IIOPListener.class$("org.omg.SSLIOP.SSLHelper")) : class$org$omg$SSLIOP$SSLHelper);
        }
        iIOPProfile.configure(this.configuration);
        return iIOPProfile;
    }

    private SSL createSSL() {
        return new SSL((short)this.target_supports, (short)this.target_requires, (short)this.sslAcceptor.getLocalAddress().getPort());
    }

    private void deliverConnection(Socket socket, boolean bl) {
        Connection connection = null;
        try {
            connection = this.createServerConnection(socket, bl);
        }
        catch (IOException iOException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Could not create connection from socket: " + iOException);
            }
            return;
        }
        this.deliverConnection(connection);
    }

    protected Connection createServerConnection(Socket socket, boolean bl) throws IOException {
        ServerIIOPConnection serverIIOPConnection = new ServerIIOPConnection(socket, bl);
        try {
            serverIIOPConnection.configure(this.configuration);
        }
        catch (ConfigurationException configurationException) {
            throw new INTERNAL("ConfigurationException: " + configurationException.getMessage());
        }
        return serverIIOPConnection;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LoopbackAcceptor
    implements IIOPLoopback {
        private LoopbackAcceptor() {
        }

        public void start() {
            IIOPLoopbackRegistry.getRegistry().register(this.getAddress(), this);
        }

        public void terminate() {
            IIOPLoopbackRegistry.getRegistry().unregister(this.getAddress());
        }

        public void initLoopback(IIOPLoopbackInputStream iIOPLoopbackInputStream, IIOPLoopbackOutputStream iIOPLoopbackOutputStream) {
            IIOPLoopbackConnection iIOPLoopbackConnection = new IIOPLoopbackConnection(iIOPLoopbackInputStream, iIOPLoopbackOutputStream);
            IIOPListener.this.deliverConnection(iIOPLoopbackConnection);
        }

        private IIOPAddress getAddress() {
            IIOPProfile iIOPProfile = (IIOPProfile)IIOPListener.this.profile;
            return (IIOPAddress)iIOPProfile.getAddress();
        }
    }

    private class SSLAcceptor
    extends Acceptor {
        private SSLAcceptor() {
        }

        protected ServerSocket createServerSocket() {
            try {
                return IIOPListener.this.getSSLServerSocketFactory().createServerSocket(IIOPListener.this.sslAddress.getPort(), 20, IIOPListener.this.sslAddress.getConfiguredHost());
            }
            catch (IOException iOException) {
                IIOPListener.this.logger.warn(iOException.getMessage());
                throw new INITIALIZE("Could not create SSL server socket");
            }
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, true);
        }
    }

    protected class Acceptor
    extends ListenerBase.Acceptor {
        protected ServerSocket serverSocket;
        protected boolean terminated = false;

        public Acceptor() {
            this.setDaemon(true);
        }

        public void init() {
            this.serverSocket = this.createServerSocket();
            if (IIOPListener.this.logger.isDebugEnabled()) {
                IIOPListener.this.logger.debug("Created socket listener on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort());
            }
        }

        public void run() {
            while (!this.terminated) {
                try {
                    Socket socket = this.serverSocket.accept();
                    this.setup(socket);
                    this.deliverConnection(socket);
                }
                catch (Exception exception) {
                    if (this.terminated || !IIOPListener.this.logger.isWarnEnabled()) continue;
                    IIOPListener.this.logger.warn(exception.getMessage());
                }
            }
            if (IIOPListener.this.logger.isInfoEnabled()) {
                IIOPListener.this.logger.info("Listener exited");
            }
        }

        public void terminate() {
            block2: {
                this.terminated = true;
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    if (!IIOPListener.this.logger.isWarnEnabled()) break block2;
                    IIOPListener.this.logger.warn(iOException.getMessage());
                }
            }
        }

        public IIOPAddress getLocalAddress() {
            IIOPAddress iIOPAddress;
            block3: {
                iIOPAddress = new IIOPAddress(this.serverSocket.getInetAddress().toString(), this.serverSocket.getLocalPort());
                if (IIOPListener.this.configuration != null) {
                    try {
                        iIOPAddress.configure(IIOPListener.this.configuration);
                    }
                    catch (ConfigurationException configurationException) {
                        if (!IIOPListener.this.logger.isWarnEnabled()) break block3;
                        IIOPListener.this.logger.warn("ConfigurationException", (Throwable)configurationException);
                    }
                }
            }
            return iIOPAddress;
        }

        protected ServerSocket createServerSocket() {
            try {
                return IIOPListener.this.getServerSocketFactory().createServerSocket(IIOPListener.this.address.getPort(), 20, IIOPListener.this.address.getConfiguredHost());
            }
            catch (IOException iOException) {
                IIOPListener.this.logger.warn(iOException.getMessage());
                throw new INITIALIZE("Could not create server socket");
            }
        }

        protected void setup(Socket socket) throws IOException {
            socket.setSoTimeout(IIOPListener.this.serverTimeout);
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, false);
        }
    }
}

