/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import edu.emory.mathcs.backport.java.util.PriorityQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.HeapEntry;
import org.jacorb.notification.queue.QueueUtil;

public class BoundedPriorityEventQueue
extends AbstractBoundedEventQueue {
    private final PriorityQueue heap_;
    private long counter_ = 0L;
    private final int maxCapacity_;

    public BoundedPriorityEventQueue(int n, EventQueueOverflowStrategy eventQueueOverflowStrategy) {
        super(n, eventQueueOverflowStrategy, new Object());
        this.maxCapacity_ = n;
        this.heap_ = new PriorityQueue(this.maxCapacity_, QueueUtil.DESCENDING_PRIORITY_COMPARATOR);
    }

    public String getOrderPolicyName() {
        return "PriorityOrder";
    }

    protected Message getNextElement() {
        return ((HeapEntry)this.heap_.remove()).event_;
    }

    protected Message getEarliestTimeout() {
        return this.removeFirstElement(QueueUtil.ASCENDING_TIMEOUT_COMPARATOR);
    }

    protected Message getOldestElement() {
        return this.removeFirstElement(QueueUtil.ASCENDING_AGE_COMPARATOR);
    }

    protected Message getYoungestElement() {
        return this.removeFirstElement(QueueUtil.DESCENDING_AGE_COMPARATOR);
    }

    protected Message getLeastPriority() {
        return this.removeFirstElement(QueueUtil.ASCENDING_PRIORITY_COMPARATOR);
    }

    protected Message[] getElements(int n) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        while (this.heap_.peek() != null && arrayList.size() <= n) {
            arrayList.add(((HeapEntry)this.heap_.remove()).event_);
        }
        return arrayList.toArray(QueueUtil.MESSAGE_ARRAY_TEMPLATE);
    }

    protected void addElement(Message message) {
        this.heap_.add((Object)new HeapEntry(message, this.counter_++));
    }

    private List removeAllEntries() {
        List list = this.copyAllEntries();
        this.heap_.clear();
        return list;
    }

    protected Message[] getAllElements() {
        List list = this.removeAllEntries();
        Message[] messageArray = new Message[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            HeapEntry heapEntry = (HeapEntry)iterator.next();
            messageArray[n++] = heapEntry.event_;
        }
        return messageArray;
    }

    private Message removeFirstElement(Comparator comparator) {
        List list = this.copyAllEntries();
        Collections.sort(list, comparator);
        HeapEntry heapEntry = (HeapEntry)list.get(0);
        this.heap_.remove((Object)heapEntry);
        return heapEntry.event_;
    }

    private List copyAllEntries() {
        ArrayList arrayList = new ArrayList(this.heap_.size());
        arrayList.addAll(this.heap_);
        return arrayList;
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public int getSize() {
        return this.heap_.size();
    }

    public String toString() {
        return this.heap_.toString();
    }
}

