/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.jboss.lang.Autoboxing;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.ParameterWrapping;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.tools.metadata.ToolsEndpointMetaData;
import org.jboss.ws.utils.HolderUtils;
import org.jboss.ws.utils.JavaUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveMetaDataBuilder {
    private Class seiClass = null;
    private ToolsEndpointMetaData tmd = null;
    private String targetNamespace = null;
    private Map<String, List<Configuration.OperationConfig>> operationMap = null;
    private Map<String, Integer> operationNameCount = new HashMap<String, Integer>();

    public ReflectiveMetaDataBuilder(ToolsEndpointMetaData tmd) {
        this.seiClass = tmd.getServiceEndpointInterface();
        this.checkServiceEndpointInterface();
        this.targetNamespace = tmd.getName().getNamespaceURI();
        this.tmd = tmd;
    }

    public void setOperationMap(Map<String, List<Configuration.OperationConfig>> operationMap) {
        this.operationMap = operationMap;
    }

    public ToolsEndpointMetaData generate() {
        this.generateOperationMetaData(this.seiClass.getDeclaredMethods());
        return this.tmd;
    }

    private void checkServiceEndpointInterface() {
        if (this.seiClass == null) {
            throw new IllegalArgumentException("Illegal Null Argument: seiClass");
        }
        if (!this.seiClass.isInterface()) {
            throw new IllegalArgumentException("Illegal seiClass : not an interface");
        }
        if (!Class.forName("java.rmi.Remote").isAssignableFrom(this.seiClass)) {
            throw new WSException(new StringBuffer().append("A service endpoint interface MUST extend java.rmi.Remote: ").append(this.seiClass.getName()).toString());
        }
    }

    private FaultMetaData getFaultMetaData(Class exType, OperationMetaData om) {
        String exname = WSDLUtils.getInstance().getJustClassName(exType);
        QName xmlName = new QName(this.tmd.typeNamespace, exname);
        FaultMetaData fm = new FaultMetaData(om, xmlName, xmlName, exType.getName());
        return fm;
    }

    private Configuration.OperationConfig getOperationConfig(String name, Class<?>[] types) {
        if (this.operationMap == null) {
            return null;
        }
        List<Configuration.OperationConfig> configs = this.operationMap.get(name);
        if (configs == null) {
            return null;
        }
        for (Configuration.OperationConfig config : configs) {
            int i;
            if (config.params.size() != types.length) continue;
            for (i = 0; i < types.length; ++i) {
                String typeName = config.params.get((int)i).javaType;
                if (!JavaUtils.getSourceName(types[i]).equals(typeName)) break;
            }
            if (i != types.length) continue;
            return config;
        }
        return null;
    }

    private void generateOperationMetaData(Method[] marr) {
        if (marr == null) {
            throw new WSException("Number of methods in the seiClass is zero");
        }
        for (Method m : marr) {
            ParameterMetaData retMetaData;
            String methodname = m.getName();
            Class<?>[] paramTypes = m.getParameterTypes();
            int len = paramTypes.length;
            OperationMetaData om = this.getOperationMetaData(m);
            Configuration.OperationConfig opc = this.getOperationConfig(methodname, m.getParameterTypes());
            if (opc != null) {
                om.setOneWayOperation(opc.isOneWay);
            }
            ParameterMetaData wrappedParameter = null;
            ArrayList<String> wrappedVariables = null;
            ArrayList<String> wrappedTypes = null;
            ArrayList<QName> wrappedNames = null;
            if (om.isDocumentWrapped()) {
                QName xmlName;
                QName xmlType = xmlName = new QName(this.tmd.typeNamespace, m.getName());
                wrappedParameter = new ParameterMetaData(om, xmlName, xmlType, null);
                wrappedVariables = new ArrayList<String>(len);
                wrappedTypes = new ArrayList<String>(len);
                wrappedNames = new ArrayList<QName>(len);
                wrappedParameter.setWrappedVariables(wrappedVariables);
                wrappedParameter.setWrappedTypes(wrappedTypes);
                wrappedParameter.setWrappedElementNames(wrappedNames);
                om.addParameter(wrappedParameter);
                if (!om.isOneWayOperation()) {
                    xmlType = xmlName = new QName(this.tmd.typeNamespace, new StringBuffer().append(m.getName()).append("Response").toString());
                    retMetaData = new ParameterMetaData(om, xmlName, xmlType, null);
                    retMetaData.setWrappedVariables(new ArrayList<String>(0));
                    retMetaData.setWrappedTypes(new ArrayList<String>(0));
                    retMetaData.setWrappedElementNames(new ArrayList<QName>(0));
                    om.setReturnParameter(retMetaData);
                }
            }
            for (int i = 0; i < len; ++i) {
                Class<?> paramType = paramTypes[i];
                if (Class.forName("java.rmi.Remote").isAssignableFrom(paramType)) {
                    throw new WSException(new StringBuffer().append("Param Type ").append(paramType.getName()).append(" should not extend java.rmi.Remote").toString());
                }
                if (om.isDocumentWrapped() && !this.isHeaderParameter(opc, i)) {
                    wrappedTypes.add(paramType.getName());
                    QName xmlName = this.getXmlName(paramType, opc, i);
                    wrappedNames.add(xmlName);
                    wrappedVariables.add(this.convertToProperty(xmlName.getLocalPart()));
                    continue;
                }
                om.addParameter(this.getParameterMetaData(paramType, om, opc, i));
            }
            Class<?> returnType = m.getReturnType();
            if (Void.TYPE != returnType) {
                if (Class.forName("java.rmi.Remote").isAssignableFrom(returnType)) {
                    throw new WSException(new StringBuffer().append("Return Type ").append(returnType.getName()).append(" should not extend java.rmi.Remote").toString());
                }
                if (om.isDocumentWrapped()) {
                    QName name = this.getReturnXmlName(opc);
                    retMetaData = om.getReturnParameter();
                    retMetaData.getWrappedVariables().add(name.getLocalPart());
                    retMetaData.getWrappedTypes().add(returnType.getName());
                    retMetaData.getWrappedElementNames().add(name);
                } else {
                    om.setReturnParameter(this.getParameterMetaDataForReturnType(returnType, om, opc));
                }
            }
            if (om.isDocumentWrapped()) {
                ParameterWrapping.generateWrapper(wrappedParameter, false);
                if (!om.isOneWayOperation()) {
                    ParameterWrapping.generateWrapper(om.getReturnParameter(), false);
                }
            }
            Class<?>[] exceptionTypes = m.getExceptionTypes();
            boolean remoteExceptionFound = false;
            if (exceptionTypes != null) {
                for (int i = 0; i < exceptionTypes.length; ++i) {
                    if (Class.forName("java.rmi.RemoteException").isAssignableFrom(exceptionTypes[i])) {
                        remoteExceptionFound = true;
                        continue;
                    }
                    om.addFault(this.getFaultMetaData(exceptionTypes[i], om));
                }
            }
            if (!remoteExceptionFound) {
                throw new WSException(new StringBuffer().append(m.getName()).append(" does not throw RemoteException.").toString());
            }
            om.validate();
            this.tmd.addOperation(om);
        }
    }

    private OperationMetaData getOperationMetaData(Method m) {
        String methodName = m.getName();
        int count = 0;
        if (this.operationNameCount.containsKey(methodName)) {
            count = this.operationNameCount.get(methodName);
        }
        this.operationNameCount.put(methodName, Autoboxing.valueOf((int)(++count)));
        String localName = count > 1 ? new StringBuffer().append(methodName).append(count).toString() : methodName;
        OperationMetaData om = new OperationMetaData(this.tmd, new QName(this.targetNamespace, localName), methodName);
        om.setSOAPAction("");
        return om;
    }

    private boolean isHeaderParameter(Configuration.OperationConfig config, int index) {
        if (config == null) {
            return false;
        }
        return config.params.get((int)index).header;
    }

    private ParameterMetaData getParameterMetaData(Class type, OperationMetaData om, Configuration.OperationConfig config, int index) {
        boolean holder;
        QName xmlType = ToolsUtils.getXMLType(type, this.tmd.typeNamespace);
        QName xmlName = this.getXmlName(type, config, index);
        ParameterMetaData pm = new ParameterMetaData(om, xmlName, xmlType, type.getName());
        pm.setInHeader(this.isHeaderParameter(config, index));
        String mode = null;
        if (config != null) {
            mode = config.params.get((int)index).mode;
        }
        if (holder = Class.forName("javax.xml.rpc.holders.Holder").isAssignableFrom(type)) {
            pm.setJavaTypeName(HolderUtils.getValueType(type).getName());
            if (mode != null) {
                if (mode.equals("OUT")) {
                    pm.setMode(ParameterMode.OUT);
                } else if (mode.equals("INOUT")) {
                    pm.setMode(ParameterMode.INOUT);
                }
            } else {
                pm.setMode(ParameterMode.INOUT);
            }
        }
        return pm;
    }

    private QName getXmlName(Class type, Configuration.OperationConfig config, int index) {
        QName name;
        if (config != null && (name = config.params.get((int)index).xmlName) != null) {
            if ("".equals(name.getNamespaceURI())) {
                name = new QName(this.tmd.typeNamespace, name.getLocalPart());
            }
            return name;
        }
        String defaultName = this.getDefaultName(type);
        String xmlNameStr = new StringBuffer().append(defaultName).append("_").append(index + 1).toString();
        QName xmlName = new QName(this.tmd.typeNamespace, xmlNameStr);
        return xmlName;
    }

    private QName getReturnXmlName(Configuration.OperationConfig config) {
        QName name;
        if (config != null && (name = config.returnXmlName) != null) {
            if ("".equals(name.getNamespaceURI())) {
                name = new QName(this.tmd.typeNamespace, name.getLocalPart());
            }
            return name;
        }
        return new QName(this.tmd.typeNamespace, "result");
    }

    private ParameterMetaData getParameterMetaDataForReturnType(Class type, OperationMetaData om, Configuration.OperationConfig config) {
        QName xmlType = ToolsUtils.getXMLType(type, this.tmd.typeNamespace);
        QName xmlName = this.getReturnXmlName(config);
        ParameterMetaData pm = new ParameterMetaData(om, xmlName, xmlType, type.getName());
        return pm;
    }

    private String getDefaultName(Class javaClass) {
        String name = "";
        WSDLUtils utils = WSDLUtils.getInstance();
        if (Class.forName("javax.xml.rpc.holders.Holder").isAssignableFrom(javaClass)) {
            javaClass = utils.getJavaTypeForHolder(javaClass);
        }
        name = javaClass.isArray() ? utils.getMessagePartForArray(javaClass) : utils.getJustClassName(javaClass);
        return name;
    }

    private String convertToProperty(String variable) {
        if (Character.isUpperCase(variable.charAt(0))) {
            char c = Character.toLowerCase(variable.charAt(0));
            StringBuffer builder = new StringBuffer(variable);
            builder.setCharAt(0, c);
            variable = builder.toString();
        }
        return variable;
    }
}

