/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.mapping;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.rpc.encoding.TypeMapping;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.tools.JavaWriter;
import org.jboss.ws.tools.XSDTypeToJava;
import org.jboss.ws.tools.helpers.MappingFileGeneratorHelper;

public class MappingFileGenerator {
    protected WSDLDefinitions wsdlDefinitions;
    protected String packageName;
    protected String serviceName;
    protected Class serviceEndpointInterface = null;
    protected String typeNamespace;
    protected LiteralTypeMapping typeMapping = null;

    public MappingFileGenerator(WSDLDefinitions wsdl, TypeMapping typeM) {
        this.wsdlDefinitions = wsdl;
        this.typeMapping = (LiteralTypeMapping)typeM;
    }

    public WSDLDefinitions getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }

    public void setWsdlDefinitions(WSDLDefinitions wsdlDefinitions) {
        this.wsdlDefinitions = wsdlDefinitions;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceEndpointInterface(Class serviceEndpointInterface) {
        this.serviceEndpointInterface = serviceEndpointInterface;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setTypeNamespace(String typeNamespace) {
        this.typeNamespace = typeNamespace;
    }

    public JavaWsdlMapping generate() throws IOException {
        MappingFileGeneratorHelper helper = new MappingFileGeneratorHelper(this.wsdlDefinitions, this.serviceName, this.packageName, this.serviceEndpointInterface, this.typeNamespace, this.typeMapping);
        String targetNS = this.wsdlDefinitions.getTargetNamespace();
        if (this.typeNamespace == null) {
            this.typeNamespace = targetNS;
        }
        JavaWsdlMapping jwm = new JavaWsdlMapping();
        if (this.typeNamespace != null && !this.typeNamespace.equals(targetNS) || this.isServerSideGeneration()) {
            jwm.addPackageMapping(helper.constructPackageMapping(jwm, this.packageName, this.typeNamespace));
        }
        jwm.addPackageMapping(helper.constructPackageMapping(jwm, this.packageName, targetNS));
        helper.constructJavaXmlTypeMapping(jwm);
        WSDLService[] services = this.wsdlDefinitions.getServices();
        int lenServices = 0;
        if (services != null) {
            lenServices = services.length;
        }
        for (int i = 0; i < lenServices; ++i) {
            WSDLService wsdlService = services[i];
            jwm.addServiceInterfaceMappings(helper.constructServiceInterfaceMapping(jwm, wsdlService));
            helper.constructServiceEndpointInterfaceMapping(jwm, wsdlService);
        }
        return jwm;
    }

    public void generateJavaSourceFileForRequestResponseStruct(File location, ServiceEndpointInterfaceMapping seim, JBossXSModel xsmodel, String typeNamespace) throws IOException {
        WSDLUtils utils = WSDLUtils.getInstance();
        XSDTypeToJava xst = new XSDTypeToJava();
        xst.setTypeMapping(this.typeMapping);
        xst.setPackageName(this.packageName);
        ServiceEndpointMethodMapping[] mapArr = seim.getServiceEndpointMethodMappings();
        int len = mapArr != null ? mapArr.length : 0;
        for (int i = 0; i < len; ++i) {
            ServiceEndpointMethodMapping mm = mapArr[i];
            String opname = mm.getJavaMethodName();
            String sei = seim.getServiceEndpointInterface();
            String plainClassName = utils.getJustClassName(sei);
            String classname = plainClassName + "_" + opname + "_RequestStruct";
            ArrayList<XSDTypeToJava.VAR> listInputs = new ArrayList<XSDTypeToJava.VAR>();
            MethodParamPartsMapping[] mppmarr = mm.getMethodParamPartsMappings();
            int lenmppmarr = mppmarr != null ? mppmarr.length : 0;
            for (int j = 0; j < lenmppmarr; ++j) {
                MethodParamPartsMapping mppm = mppmarr[j];
                String paramType = mppm.getParamType();
                listInputs.addAll(xst.getVARList((XSComplexTypeDefinition)xsmodel.getTypeDefinition(opname, typeNamespace), xsmodel, false));
            }
            JavaWriter jw = new JavaWriter();
            jw.createJavaFile(location, classname, this.packageName, listInputs, null, null, false, null);
            classname = plainClassName + "_" + opname + "_ResponseStruct";
            XSTypeDefinition xt = xsmodel.getTypeDefinition(opname + "Response", typeNamespace);
            ArrayList<XSDTypeToJava.VAR> listOutputs = new ArrayList<XSDTypeToJava.VAR>();
            if (xt instanceof XSSimpleTypeDefinition) {
                listOutputs.add(new XSDTypeToJava.VAR("result", xt.getName(), false));
            } else {
                listOutputs.addAll(xst.getVARList((XSComplexTypeDefinition)xt, xsmodel, false));
            }
            jw.createJavaFile(location, classname, this.packageName, listOutputs, null, null, false, null);
        }
    }

    private boolean isServerSideGeneration() {
        return this.serviceEndpointInterface != null;
    }
}

