/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.jsr109.PortComponentMetaData;
import org.jboss.ws.metadata.jsr109.WebserviceDescriptionMetaData;
import org.jboss.ws.metadata.jsr109.WebservicesMetaData;
import org.jboss.ws.tools.interfaces.WSDotXMLCreatorIntf;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDotXMLCreator
implements WSDotXMLCreatorIntf {
    protected static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.tools.WSDotXMLCreator"));
    protected String targetNamespace = null;
    protected String seiName = null;
    protected String portName = null;
    protected String serviceName = null;
    protected String servletLink = null;
    protected String ejbLink = null;
    protected String wsdlFile = null;
    protected String mappingFile = null;

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setSeiName(String seiName) {
        this.seiName = seiName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setEjbLink(String ejbLink) {
        this.ejbLink = ejbLink;
    }

    public void setServletLink(String servletLink) {
        this.servletLink = servletLink;
    }

    public void setMappingFile(String mappingFile) {
        this.mappingFile = mappingFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public void generateWSXMLDescriptor(File file) throws IOException {
        WebservicesMetaData webservices = this.constructWSMetaData();
        String wmdata = webservices.serialize();
        Element act = DOMUtils.parse((String)wmdata);
        FileWriter fw = new FileWriter(file);
        fw.write(DOMWriter.printNode((Node)act, (boolean)true));
        fw.close();
    }

    private WebservicesMetaData constructWSMetaData() {
        WebservicesMetaData wm = new WebservicesMetaData(null);
        WebserviceDescriptionMetaData wsdm = new WebserviceDescriptionMetaData(wm);
        this.populateWebserviceDescriptionMetaData(wsdm);
        wm.addWebserviceDescription(wsdm);
        return wm;
    }

    private void populateWebserviceDescriptionMetaData(WebserviceDescriptionMetaData wsdm) {
        this.checkEssentials();
        wsdm.setWebserviceDescriptionName(this.serviceName);
        wsdm.setWsdlFile(this.wsdlFile);
        wsdm.setJaxrpcMappingFile(this.mappingFile);
        PortComponentMetaData pm1 = new PortComponentMetaData(wsdm);
        pm1.setPortComponentName(this.portName);
        pm1.setWsdlPort(new QName(this.targetNamespace, this.portName, "impl"));
        pm1.setServiceEndpointInterface(this.seiName);
        if (this.servletLink != null && this.servletLink.length() > 0) {
            pm1.setServletLink(this.servletLink);
        } else {
            pm1.setEjbLink(this.ejbLink);
        }
        wsdm.addPortComponent(pm1);
    }

    private void checkEssentials() {
        if (this.serviceName == null) {
            throw new WSException("serviceName is null");
        }
        if (this.wsdlFile == null) {
            throw new WSException("wsdlFile is null");
        }
        if (this.mappingFile == null) {
            throw new WSException("mappingFile is null");
        }
        if (this.targetNamespace == null) {
            throw new WSException("targetNamespace is null");
        }
        if (this.portName == null) {
            throw new WSException("portName is null");
        }
        if (this.seiName == null) {
            throw new WSException("seiName is null");
        }
        if (this.servletLink == null && this.ejbLink == null) {
            throw new WSException("Either servletLink or ejbLink should not be null");
        }
        if (this.servletLink != null && this.ejbLink != null) {
            throw new WSException("One of servletLink or ejbLink should be null");
        }
    }
}

