/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.jboss.lang.ClassRedirects;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.jaxrpc.encoding.SimpleDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.SimpleSerializerFactory;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.utils.JavaUtils;

public class ToolsUtils {
    private static Logger log = Logger.getLogger(Class.forName("org.jboss.ws.tools.ToolsUtils"));
    private static LiteralTypeMapping mapping = new LiteralTypeMapping();

    private ToolsUtils() {
        throw new WSException("Cannot instantiate ToolsUtils.");
    }

    public static void checkParameterType(Class paramType) {
        if (Class.forName("java.rmi.Remote").isAssignableFrom(paramType)) {
            throw new IllegalArgumentException("JAXWS-2.0 Assertion::Method param shouldn't extend Remote");
        }
    }

    public static String firstLetterUpperCase(String fname) {
        if (fname == "" || fname == null) {
            throw new WSException("String passed is null");
        }
        if (Character.isLowerCase(fname.charAt(0))) {
            char f;
            char[] chars = fname.toCharArray();
            chars[0] = f = Character.toUpperCase(chars[0]);
            fname = new String(chars);
        }
        return fname;
    }

    public static String firstLetterLowerCase(String fname) {
        if (fname == "" || fname == null) {
            throw new WSException("String passed is null");
        }
        if (Character.isUpperCase(fname.charAt(0))) {
            char f;
            char[] chars = fname.toCharArray();
            chars[0] = f = Character.toLowerCase(chars[0]);
            fname = new String(chars);
        }
        return fname;
    }

    public static String getJavaPackageName(String targetNS) {
        int ind;
        if (targetNS == null) {
            throw new IllegalArgumentException("TargetNS is null");
        }
        String pkgName = null;
        if (!targetNS.startsWith("http") && !targetNS.startsWith("urn")) {
            throw new IllegalArgumentException("TargetNS should start with http/https/urn");
        }
        if ((targetNS = targetNS.substring(targetNS.indexOf(":") + 1)).startsWith("//www")) {
            targetNS = targetNS.substring(6);
        }
        if (targetNS.endsWith("/")) {
            targetNS = targetNS.substring(0, targetNS.lastIndexOf("/"));
        }
        if ((ind = targetNS.lastIndexOf("/")) > 0) {
            String first = targetNS.substring(0, ind);
            String subs = targetNS.substring(ind + 1);
            int dotindex = subs.lastIndexOf(".");
            if (dotindex > -1) {
                subs = subs.substring(0, dotindex);
            }
            targetNS = first + "." + subs;
        }
        String string = ".";
        String string2 = "/";
        String string3 = targetNS;
        String string4 = null;
        pkgName = string4 = ClassRedirects.replace((String)string3, (CharSequence)string2, (CharSequence)string);
        string = ".";
        string2 = "-";
        string3 = pkgName;
        string4 = null;
        pkgName = string4 = ClassRedirects.replace((String)string3, (CharSequence)string2, (CharSequence)string);
        string = ".";
        string2 = ":";
        string3 = pkgName;
        string4 = null;
        string4 = ClassRedirects.replace((String)string3, (CharSequence)string2, (CharSequence)string);
        pkgName = string4;
        if (pkgName.startsWith("..")) {
            pkgName = pkgName.substring(2);
        }
        StringTokenizer st = new StringTokenizer(pkgName, ".");
        ArrayList<String> lst = new ArrayList<String>();
        String toplevel = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("net".equals(token) || "org".equals(token) || "edu".equals(token) || "gov".equals(token)) {
                toplevel = token;
                continue;
            }
            lst.add(token);
        }
        int len = lst.size();
        pkgName = toplevel != null ? toplevel : "";
        Iterator i$ = lst.iterator();
        while (i$.hasNext()) {
            String token = (String)i$.next();
            if (Character.isDigit(token.charAt(0))) {
                token = "_" + token;
            }
            if (pkgName == "") {
                pkgName = pkgName + token;
                continue;
            }
            pkgName = pkgName + "." + token;
        }
        return pkgName;
    }

    public static String getJavaIdentifier(String xmlName) {
        if (xmlName == null || xmlName == "") {
            throw new IllegalArgumentException("xmlName is null");
        }
        xmlName = xmlName.trim();
        if ((xmlName = ToolsUtils.trimPunctuationMarks(xmlName)) == null) {
            throw new WSException("xmlName has become null");
        }
        int lenStr = xmlName.length();
        char[] mainArr = new char[lenStr];
        int j = 0;
        for (int i = 0; i < lenStr; ++i) {
            char ch = xmlName.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            mainArr[j] = ch;
            ++j;
        }
        char[] secArr = new char[j];
        for (int x = 0; x < j; ++x) {
            secArr[x] = mainArr[x];
        }
        return new String(secArr);
    }

    public static String getJavaMethodName(String xmlName, boolean setter) {
        xmlName = ToolsUtils.getJavaIdentifier(xmlName);
        xmlName = ToolsUtils.firstLetterUpperCase(xmlName);
        String lcase = xmlName.toLowerCase();
        if (setter && !lcase.startsWith("set")) {
            xmlName = "set" + xmlName;
        } else if (!setter && !lcase.startsWith("get")) {
            xmlName = "get" + xmlName;
        }
        return ToolsUtils.firstLetterLowerCase(xmlName);
    }

    public static String getValidClassName(String xmlName) {
        xmlName = ToolsUtils.getJavaIdentifier(xmlName);
        return ToolsUtils.firstLetterUpperCase(xmlName);
    }

    public static QName getXMLType(Class javaClass, String ns) {
        WSDLUtils utils = WSDLUtils.getInstance();
        QName xmlType = null;
        if (Void.TYPE == javaClass) {
            return null;
        }
        if (Class.forName("javax.xml.rpc.holders.ByteArrayHolder") == javaClass) {
            return Constants.TYPE_LITERAL_BASE64BINARY;
        }
        if (Class.forName("javax.xml.rpc.holders.Holder").isAssignableFrom(javaClass)) {
            javaClass = utils.getJavaTypeForHolder(javaClass);
        }
        if ((xmlType = SchemaUtils.getInstance().getToolsOverrideInTypeMapping(javaClass)) != null) {
            return xmlType;
        }
        if (javaClass != Class.forName("[Ljava.lang.Byte;") && javaClass != Class.forName("[Ljava.lang.String;") && (xmlType = mapping.getXMLType(javaClass, false)) != null) {
            return xmlType;
        }
        String typeName = utils.getJustClassName(javaClass);
        if (javaClass.isArray()) {
            int dim = utils.getArrayDimension(javaClass);
            Class<?> cls = javaClass;
            while (cls.isArray()) {
                cls = cls.getComponentType();
            }
            typeName = WSDLUtils.getInstance().getJustClassName(cls);
            while (dim-- > 0) {
                typeName = typeName + ".Array";
            }
        }
        return new QName(ns, typeName);
    }

    public static QName getXMLTypeForAttachmentType(String mimetype) {
        return Constants.TYPE_LITERAL_HEXBINARY;
    }

    public static boolean isPunctuation(char c) {
        boolean ret = true;
        if (Character.isDigit(c)) {
            ret = false;
        } else if (Character.isLetter(c)) {
            ret = false;
        } else if (Character.isISOControl(c)) {
            ret = false;
        } else if (Character.isWhitespace(c)) {
            ret = false;
        }
        return ret;
    }

    public static boolean isJaxrpcValueType(Class cls) {
        boolean result = true;
        if (ToolsUtils.isJaxrpcRegularType(cls)) {
            return false;
        }
        boolean defaultCTR = false;
        Constructor<?>[] cons = cls.getDeclaredConstructors();
        for (int i = 0; i < cons.length; ++i) {
            Class<?>[] paramTypes = cons[i].getParameterTypes();
            if (paramTypes != null && paramTypes.length != 0) continue;
            defaultCTR = true;
            break;
        }
        if (!defaultCTR) {
            return false;
        }
        if (Class.forName("java.rmi.Remote").isAssignableFrom(cls)) {
            return false;
        }
        Field[] fieldArr = cls.getDeclaredFields();
        int length = Array.getLength(fieldArr);
        for (int i = 0; i < length; ++i) {
            if (ToolsUtils.isJaxrpcPermittedType(fieldArr[i].getType())) continue;
            return false;
        }
        return result;
    }

    public static boolean isJavaBean(Class cls) {
        boolean result = false;
        if (ToolsUtils.isJaxrpcRegularType(cls)) {
            return false;
        }
        try {
            BeanInfo bi = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            if (pds != null && pds.length > 0) {
                result = true;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return result;
    }

    public static int getNumberOfParticles(Class javaBean) {
        if (!ToolsUtils.isJavaBean(javaBean)) {
            throw new IllegalArgumentException("Illegal JavaBean argument");
        }
        Field[] pubFields = javaBean.getFields();
        int pub = pubFields != null ? pubFields.length : 0;
        int props = 0;
        try {
            BeanInfo bi = Introspector.getBeanInfo(javaBean);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            props = pds != null ? Array.getLength(pds) : 0;
            int len = 0;
            for (int i = 0; i < props; ++i) {
                PropertyDescriptor pd = pds[i];
                Method readMethod = pd.getReadMethod();
                if ("getClass".equals(readMethod.getName())) continue;
                ++len;
            }
            props = len;
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
        return pub + props;
    }

    public static boolean canUnWrap(Class javaType, boolean isReturnType) {
        boolean bool = false;
        bool = isReturnType ? ToolsUtils.isJavaBean(javaType) && ToolsUtils.getNumberOfParticles(javaType) == 1 : ToolsUtils.isJaxrpcValueType(javaType);
        return bool;
    }

    public static boolean isJaxrpcPermittedType(Class type) {
        if (!ToolsUtils.isJaxrpcRegularType(type)) {
            return ToolsUtils.isJaxrpcValueType(type);
        }
        return true;
    }

    public static boolean isJaxrpcRegularType(Class type) {
        boolean result = false;
        if (JavaUtils.isPrimitive(type)) {
            return true;
        }
        Class wrapperType = JavaUtils.getWrapperType(type);
        if (wrapperType != null && wrapperType != type) {
            return true;
        }
        Class primType = JavaUtils.getPrimitiveType(type);
        if (primType != null && primType != type) {
            return true;
        }
        if (Class.forName("java.lang.String") == type || Class.forName("java.util.Date") == type || Class.forName("java.util.Calendar") == type || Class.forName("java.math.BigInteger") == type || Class.forName("java.math.BigDecimal") == type || Class.forName("javax.xml.namespace.QName") == type || Class.forName("java.net.URI") == type) {
            return true;
        }
        return result;
    }

    public static synchronized void registerJavaType(LiteralTypeMapping typeMapping, Class clazz, QName xmlType) {
        if (!typeMapping.isRegistered(clazz, xmlType)) {
            typeMapping.register(clazz, xmlType, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        }
    }

    private static String trimPunctuationMarks(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Str is null");
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            str = str.substring(1);
        } else if (ToolsUtils.isPunctuation(str.charAt(0))) {
            str = str.substring(1);
        }
        int len = str.length();
        if (ToolsUtils.isPunctuation(str.charAt(len - 1))) {
            str = str.substring(0, len - 1);
        }
        return str;
    }
}

