/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.tools.XSDTypeToJava;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaWriter {
    private String newline = "\n";
    protected WSDLUtils utils = WSDLUtils.getInstance();

    public void createJavaFileForEnumeratedValues(String fname, StringList lst, File loc, String pkgname, XSSimpleTypeDefinition type) throws IOException {
        String str;
        int i;
        ArrayList<String> importList = new ArrayList<String>();
        importList.add("java.util.Map");
        importList.add("java.util.HashMap");
        File sei = this.utils.createPhysicalFile(loc, fname);
        StringBuffer buf = this.utils.createClassBasicStructure(pkgname, fname, (XSTypeDefinition)type, importList, null);
        buf.append(new StringBuffer().append("private java.lang.String value;").append(this.newline).toString());
        buf.append(new StringBuffer().append("private static Map valueMap = new HashMap();").append(this.newline).toString());
        int lenOfArr = lst != null ? lst.getLength() : 0;
        for (i = 0; i < lenOfArr; ++i) {
            str = lst.item(i);
            buf.append(new StringBuffer().append("public static final String _").append(str).append("String = \"").append(str).append("\";").append(this.newline).toString());
        }
        for (i = 0; i < lenOfArr; ++i) {
            str = lst.item(i);
            buf.append(new StringBuffer().append("public static final java.lang.String _").append(str).append(" = new java.lang.String(_").append(str).append("String);").toString());
            buf.append(this.newline);
        }
        for (i = 0; i < lenOfArr; ++i) {
            str = lst.item(i);
            buf.append(new StringBuffer().append("public static final ").append(fname).append(" ").append(str).append(" = new ").append(fname).append("(_").append(str).append(");").toString());
            buf.append(this.newline);
        }
        buf.append(new StringBuffer().append(this.newline).append(this.newline).append("protected ").append(fname).append("(java.lang.String value) { ").append(this.newline).toString());
        buf.append(new StringBuffer().append("this.value = value;valueMap.put(this.toString(), this); ").append(this.newline).append("}").toString());
        buf.append(new StringBuffer().append(this.newline).append(this.newline).toString());
        buf.append(new StringBuffer().append(this.newline).append(" public java.lang.String getValue() {").append(this.newline).append("  return value;").append(this.newline).append("}").toString());
        buf.append(new StringBuffer().append(this.newline).append(this.newline).toString());
        buf.append(new StringBuffer().append(this.newline).append("public static ").append(fname).append("  fromValue(java.lang.String value)").append(this.newline).toString());
        buf.append(new StringBuffer().append(" throws java.lang.IllegalStateException {").append(this.newline).toString());
        for (i = 0; i < lenOfArr; ++i) {
            str = lst.item(i);
            if (i > 0) {
                buf.append("else ");
            }
            buf.append(new StringBuffer().append("if (").append(str).append(".value.equals(value)) {").append(this.newline).toString());
            buf.append(new StringBuffer().append("return ").append(str).append(";").append(this.newline).toString());
            buf.append(new StringBuffer().append("}").append(this.newline).toString());
        }
        buf.append(new StringBuffer().append(" throw new IllegalArgumentException();").append(this.newline).append("}").append(this.newline).append(this.newline).toString());
        buf.append(new StringBuffer().append(this.newline).append("public static ").append(fname).append("  fromString(String value)").append(this.newline).toString());
        buf.append(new StringBuffer().append(" throws java.lang.IllegalStateException {").append(this.newline).toString());
        buf.append(new StringBuffer().append(fname).append(" ret = (").append(fname).append(")valueMap.get(value);").append(this.newline).toString());
        buf.append(new StringBuffer().append("if (ret != null) {").append(this.newline).append(" return ret;").append(this.newline).append(" }").append(this.newline).append(this.newline).toString());
        for (i = 0; i < lenOfArr; ++i) {
            str = lst.item(i);
            if (i > 0) {
                buf.append("else ");
            }
            buf.append(new StringBuffer().append("if (value.equals(_").append(str).append("String)) {").append(this.newline).toString());
            buf.append(new StringBuffer().append("return ").append(str).append(";").append(this.newline).append("}").toString());
        }
        buf.append(new StringBuffer().append(this.newline).append(" throw new IllegalArgumentException();").append(this.newline).append("}").append(this.newline).append(this.newline).toString());
        buf.append(new StringBuffer().append(this.newline).append(" public String toString() {").append(this.newline).append(" return value.toString();").append(this.newline).append("}").append(this.newline).toString());
        buf.append(new StringBuffer().append(this.newline).append("private Object readResolve()").append(this.newline).append("        throws java.io.ObjectStreamException {").append(this.newline).append("        return fromValue(getValue());").append(this.newline).append("    } ").append(this.newline).toString());
        buf.append(new StringBuffer().append(this.newline).append("private boolean equals(Object obj){").append(this.newline).append("         if (!(obj instanceof ").append(fname).append(")) {").append(this.newline).append("         return false;").append(this.newline).append("    } ").append(this.newline).toString());
        buf.append(new StringBuffer().append("return ((").append(fname).append(")obj).value.equals(value);").append(this.newline).append("}").append(this.newline).toString());
        buf.append(new StringBuffer().append(this.newline).append(" public int hashCode() { ").append(this.newline).append("        return value.hashCode(); ").append(this.newline).append("    }").append(this.newline).toString());
        buf.append(new StringBuffer().append("}").append(this.newline).toString());
        FileWriter writer = new FileWriter(sei);
        writer.write(buf.toString());
        writer.flush();
        writer.close();
    }

    public void createJavaFile(File location, String filename, String packageName, List<XSDTypeToJava.VAR> vars, List<String> importList, String baseTypeName, boolean isExceptionType, Map<String, List> typeNameToBaseVARList) throws IOException {
        File newLoc = null;
        newLoc = this.needToCreatePackageStructure(location, packageName) ? this.utils.createPackage(location.getPath(), packageName) : location;
        String classname = this.utils.chop(filename, ".java");
        File sei = this.utils.createPhysicalFile(newLoc, classname);
        StringBuffer buffer = new StringBuffer();
        this.utils.writeJbossHeader(buffer);
        buffer.append(this.newline).append("package ").append(packageName).append(";");
        if (importList != null) {
            for (String imp : importList) {
                buffer.append(this.newline).append("import ").append(imp).append(";");
            }
        }
        buffer.append(this.newline).append(this.newline);
        buffer.append(this.newline).append("public class  ").append(classname).append(this.newline);
        if (baseTypeName != null && baseTypeName.length() > 0) {
            buffer.append(" extends ").append(baseTypeName);
        }
        buffer.append("{").append(this.newline);
        this.createVariables(buffer, vars, isExceptionType);
        this.createCTR(buffer, classname, vars, isExceptionType, typeNameToBaseVARList);
        buffer.append(this.newline);
        this.createAccessors(buffer, vars, isExceptionType);
        buffer.append("}").append(this.newline);
        FileWriter writer = new FileWriter(sei);
        writer.write(buffer.toString());
        writer.flush();
        writer.close();
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private void createCTR(StringBuffer buf, String cname, List vars, boolean isExceptionType, Map typeNameToBaseVARList) {
        if (vars.size() > 0 && !isExceptionType) {
            buf.append(new StringBuffer().append("public ").append(cname).append("(){}").toString());
            buf.append(this.newline);
            buf.append(this.newline);
        }
        StringBuffer ctrvarbuf = new StringBuffer();
        StringBuffer ctrintbuf = new StringBuffer();
        boolean calledSuper = false;
        if (isExceptionType) {
            List baseList = (List)typeNameToBaseVARList.get(cname);
            int baseLen = baseList != null ? baseList.size() : 0;
            String arrStr = "[]";
            if (baseLen > 0) {
                calledSuper = true;
                ctrintbuf.append("super(");
                for (int i = 0; i < baseLen; ++i) {
                    if (i > 0) {
                        ctrvarbuf.append(", ");
                        ctrintbuf.append(", ");
                    }
                    XSDTypeToJava.VAR v = (XSDTypeToJava.VAR)baseList.get(i);
                    ctrvarbuf.append(v.getVartype());
                    if (v.isArrayType) {
                        ctrvarbuf.append(arrStr);
                    }
                    ctrvarbuf.append(" ").append(v.getVarname());
                    ctrintbuf.append(v.getVarname());
                }
                ctrintbuf.append(");").append(this.newline);
            }
        }
        Iterator iter = vars.iterator();
        int index = 0;
        while (iter.hasNext()) {
            if (index++ > 0 || calledSuper) {
                ctrvarbuf.append(", ");
            }
            XSDTypeToJava.VAR v = (XSDTypeToJava.VAR)iter.next();
            String name = v.getVarname();
            String type = v.getVartype();
            boolean isArr = v.isArrayType();
            ctrvarbuf.append(type);
            if (isArr) {
                ctrvarbuf.append("[]");
            }
            ctrvarbuf.append(new StringBuffer().append(" ").append(name).toString());
            if (isExceptionType && !calledSuper && index == 1 && v.getVartype().equals("java.lang.String")) {
                ctrintbuf.append("super(").append(v.getVarname()).append(");").append(this.newline);
                calledSuper = true;
            }
            ctrintbuf.append(new StringBuffer().append("this.").append(name).append("=").append(name).append(";").toString());
            ctrintbuf.append(this.newline);
        }
        buf.append(new StringBuffer().append("public ").append(cname).append("(").append(ctrvarbuf.toString()).append("){").toString());
        buf.append(this.newline);
        buf.append(ctrintbuf.toString());
        buf.append("}");
    }

    private void createAccessors(StringBuffer buf, List vars, boolean isExceptionType) {
        for (XSDTypeToJava.VAR v : vars) {
            String name = v.getVarname();
            String type = v.getVartype();
            boolean isArr = v.isArrayType();
            buf.append(new StringBuffer().append("public ").append(type).toString());
            if (isArr) {
                buf.append("[] ");
            }
            String str = " get";
            if (type.equals("boolean")) {
                str = " is";
            }
            buf.append(new StringBuffer().append(str).append(this.utils.getMixedCase(name)).append("() { return ").append(name).append(" ;}").toString());
            buf.append(this.newline);
            buf.append(this.newline);
            if (!isExceptionType) {
                this.writeSetter(buf, name, type, isArr);
            }
            buf.append(this.newline);
            buf.append(this.newline);
        }
    }

    private List createVariables(StringBuffer buf, List vars, boolean isExceptionType) {
        if (vars == null) {
            return vars;
        }
        for (XSDTypeToJava.VAR v : vars) {
            String name = v.getVarname();
            String type = v.getVartype();
            boolean isArr = v.isArrayType();
            buf.append(this.newline);
            if (isExceptionType) {
                buf.append(new StringBuffer().append("private ").append(type).toString());
            } else {
                buf.append(new StringBuffer().append("protected ").append(type).toString());
            }
            if (isArr) {
                buf.append("[] ");
            }
            buf.append(new StringBuffer().append(" ").append(name).toString()).append(";").append(this.newline);
        }
        return vars;
    }

    private boolean needToCreatePackageStructure(File location, String packageName) {
        packageName = packageName.replace('.', '/');
        try {
            String externalForm = location.toURL().toExternalForm();
            return externalForm.indexOf(packageName) < 0;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private void writeSetter(StringBuffer buf, String name, String type, boolean isArr) {
        buf.append("public void ");
        buf.append(new StringBuffer().append("set").append(this.utils.getMixedCase(name)).append("(").append(type).toString());
        if (isArr) {
            buf.append("[]");
        }
        buf.append(new StringBuffer().append(" ").append(name).append("){ this.").append(name).append("=").append(name).append("; }").toString());
    }
}

