/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.soap.DetailEntryImpl;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPBodyElementDoc;
import org.jboss.ws.soap.SOAPBodyElementMessage;
import org.jboss.ws.soap.SOAPBodyElementRpc;
import org.jboss.ws.soap.SOAPContentElement;
import org.jboss.ws.soap.SOAPElementImpl;
import org.jboss.ws.soap.SOAPEnvelopeImpl;
import org.jboss.ws.soap.SOAPFactoryImpl;
import org.jboss.ws.soap.SOAPFaultImpl;
import org.jboss.ws.soap.SOAPHeaderElementImpl;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.soap.SOAPMessageImpl;
import org.jboss.ws.soap.SOAPPartImpl;
import org.jboss.ws.soap.attachment.MultipartRelatedDecoder;
import org.jboss.ws.utils.IOUtils;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageFactoryImpl
extends MessageFactory {
    private static Logger log = Logger.getLogger(Class.forName("org.jboss.ws.soap.MessageFactoryImpl"));
    private String envelopeURI = "http://schemas.xmlsoap.org/soap/envelope/";
    private Style style;

    public String getEnvelopeURI() {
        return this.envelopeURI;
    }

    public void setEnvelopeURI(String envelopeURI) {
        this.envelopeURI = envelopeURI;
    }

    public Style getStyle() {
        if (this.style == null) {
            SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext != null && msgContext.getOperationMetaData() != null) {
                this.style = msgContext.getOperationMetaData().getStyle();
            }
            log.trace((Object)("Using style: " + this.style));
        }
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public SOAPMessage createMessage() throws SOAPException {
        SOAPMessageImpl soapMessage = new SOAPMessageImpl();
        SOAPPartImpl soapPart = (SOAPPartImpl)soapMessage.getSOAPPart();
        new SOAPEnvelopeImpl(soapPart, this.envelopeURI);
        return soapMessage;
    }

    public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream ins) throws IOException, SOAPException {
        return this.createMessageInternal(mimeHeaders, ins, false);
    }

    public SOAPMessage createMessageInternal(MimeHeaders mimeHeaders, InputStream ins, boolean ingnoreParseException) throws IOException, SOAPException {
        if (mimeHeaders == null) {
            mimeHeaders = new MimeHeaders();
        } else if (log.isTraceEnabled()) {
            Iterator itMimeHeaders = mimeHeaders.getAllHeaders();
            while (itMimeHeaders.hasNext()) {
                MimeHeader mh = (MimeHeader)itMimeHeaders.next();
                log.trace((Object)mh);
            }
        }
        ContentType contentType = MessageFactoryImpl.getContentType(mimeHeaders);
        log.debug((Object)("createMessage: [contentType=" + contentType + "]"));
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            IOUtils.copyStream(baos, ins);
            byte[] bytes = baos.toByteArray();
            log.trace((Object)("createMessage\n" + new String(bytes)));
            ins = new ByteArrayInputStream(bytes);
        }
        Collection<AttachmentPart> attachments = null;
        if (this.isMultipartRelatedContent(contentType)) {
            MultipartRelatedDecoder decoder;
            try {
                decoder = new MultipartRelatedDecoder(contentType);
                decoder.decodeMultipartRelatedMessage(ins);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new SOAPException("Cannot decode multipart related message", (Throwable)ex);
            }
            ins = decoder.getRootPart().getDataHandler().getInputStream();
            attachments = decoder.getRelatedParts();
        } else if (!this.isSoapContent(contentType)) {
            throw new SOAPException("Unsupported content type: " + contentType);
        }
        SOAPMessageImpl soapMessage = new SOAPMessageImpl();
        if (mimeHeaders != null) {
            soapMessage.setMimeHeaders(mimeHeaders);
        }
        if (attachments != null) {
            soapMessage.setAttachments(attachments);
        }
        this.createSOAPEnvelope(soapMessage, ins, ingnoreParseException);
        return soapMessage;
    }

    private void createSOAPEnvelope(SOAPMessageImpl soapMessage, InputStream ins, boolean ingnoreParseException) throws IOException, SOAPException {
        Element domEnv = null;
        try {
            domEnv = DOMUtils.parse((InputStream)ins);
        }
        catch (IOException ex) {
            if (ingnoreParseException) {
                return;
            }
            throw ex;
        }
        String envNS = domEnv.getNamespaceURI();
        String envPrefix = domEnv.getPrefix();
        SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
        SOAPPartImpl soapPart = (SOAPPartImpl)soapMessage.getSOAPPart();
        SOAPEnvelopeImpl soapEnv = new SOAPEnvelopeImpl(soapPart, soapFactory.createElement(domEnv, false));
        NamespaceRegistry namespaceRegistry = soapEnv.getNamespaceRegistry();
        DOMUtils.copyAttributes((Element)((Object)soapEnv), (Element)domEnv);
        this.registerNamespaces(namespaceRegistry, soapEnv);
        Element domHeader = DOMUtils.getFirstChildElement((Node)domEnv, (QName)new QName(envNS, "Header"));
        if (domHeader != null) {
            SOAPHeader soapHeader = soapEnv.getHeader();
            DOMUtils.copyAttributes((Element)soapHeader, (Element)domHeader);
            this.registerNamespaces(namespaceRegistry, (SOAPElement)soapHeader);
            Iterator it = DOMUtils.getChildElements((Node)domHeader);
            while (it.hasNext()) {
                Element srcElement = (Element)it.next();
                String xmlFragment = DOMWriter.printNode((Node)srcElement, (boolean)false);
                NameImpl name = new NameImpl(srcElement.getLocalName(), srcElement.getPrefix(), srcElement.getNamespaceURI());
                SOAPHeaderElementImpl destElement = new SOAPHeaderElementImpl(name);
                soapHeader.addChildElement((SOAPElement)destElement);
                DOMUtils.copyAttributes((Element)((Object)destElement), (Element)srcElement);
                destElement.setXMLFragment(xmlFragment);
            }
        }
        Element domBody = DOMUtils.getFirstChildElement((Node)domEnv, (QName)new QName(envNS, "Body"));
        SOAPBody soapBody = soapEnv.getBody();
        DOMUtils.copyAttributes((Element)soapBody, (Element)domBody);
        this.registerNamespaces(namespaceRegistry, (SOAPElement)soapBody);
        Iterator itBody = DOMUtils.getChildElements((Node)domBody);
        if (itBody.hasNext()) {
            String nsURI;
            String prefix;
            Element domBodyElement = (Element)itBody.next();
            String localName = domBodyElement.getLocalName();
            NameImpl beName = new NameImpl(localName, prefix = domBodyElement.getPrefix(), nsURI = domBodyElement.getNamespaceURI());
            if (((Object)beName).equals(new NameImpl("Fault", envPrefix, envNS))) {
                Element domFaultDetail;
                SOAPFaultImpl soapFault = new SOAPFaultImpl(envNS);
                soapBody.addChildElement((SOAPElement)soapFault);
                DOMUtils.copyAttributes((Element)((Object)soapFault), (Element)domBodyElement);
                Element domFaultCode = DOMUtils.getFirstChildElement((Node)domBodyElement, (QName)new QName("faultcode"));
                if (domFaultCode == null) {
                    throw new SOAPException("SOAPFault does not contain a <faultcode> element");
                }
                Element domFaultString = DOMUtils.getFirstChildElement((Node)domBodyElement, (QName)new QName("faultstring"));
                if (domFaultString == null) {
                    throw new SOAPException("SOAPFault does not contain a <faultstring> element");
                }
                String faultCode = DOMUtils.getTextContent((Node)domFaultCode);
                soapFault.setFaultCode(faultCode);
                String faultString = DOMUtils.getTextContent((Node)domFaultString);
                soapFault.setFaultString(faultString);
                Element domFaultActor = DOMUtils.getFirstChildElement((Node)domBodyElement, (QName)new QName("faultactor"));
                if (domFaultActor != null) {
                    String faultActor = DOMUtils.getTextContent((Node)domFaultActor);
                    soapFault.setFaultActor(faultActor);
                }
                if ((domFaultDetail = DOMUtils.getFirstChildElement((Node)domBodyElement, (String)"detail")) != null) {
                    Detail detail = soapFault.addDetail();
                    Iterator it = DOMUtils.getChildElements((Node)domFaultDetail);
                    while (it.hasNext()) {
                        Element domElement = (Element)it.next();
                        DetailEntryImpl detailEntry = new DetailEntryImpl(soapFactory.createElement(domElement, true));
                        detailEntry = detail.addChildElement((SOAPElement)detailEntry);
                    }
                }
            } else {
                Style style = this.getStyle();
                if (style == Style.RPC) {
                    SOAPBodyElementRpc soapBodyElement = new SOAPBodyElementRpc(beName);
                    soapBodyElement = (SOAPBodyElementRpc)soapBody.addChildElement((SOAPElement)soapBodyElement);
                    DOMUtils.copyAttributes((Element)((Object)soapBodyElement), (Element)domBodyElement);
                    Iterator itBodyElement = DOMUtils.getChildElements((Node)domBodyElement);
                    while (itBodyElement.hasNext()) {
                        Element srcElement = (Element)itBodyElement.next();
                        NameImpl name = new NameImpl(srcElement.getLocalName(), srcElement.getPrefix(), srcElement.getNamespaceURI());
                        SOAPContentElement destElement = new SOAPContentElement(name);
                        soapBodyElement.addChildElement(destElement);
                        String xmlFragment = DOMWriter.printNode((Node)srcElement, (boolean)false);
                        destElement.setXMLFragment(xmlFragment);
                    }
                } else if (style == Style.DOCUMENT) {
                    Element srcElement = domBodyElement;
                    SOAPBodyElementDoc destElement = new SOAPBodyElementDoc(beName);
                    destElement = (SOAPBodyElementDoc)soapBody.addChildElement((SOAPElement)destElement);
                    String xmlFragment = DOMWriter.printNode((Node)srcElement, (boolean)false);
                    destElement.setXMLFragment(xmlFragment);
                } else if (style == null) {
                    SOAPBodyElementMessage soapBodyElement = new SOAPBodyElementMessage(beName);
                    soapBodyElement = (SOAPBodyElementMessage)soapBody.addChildElement((SOAPElement)soapBodyElement);
                    DOMUtils.copyAttributes((Element)((Object)soapBodyElement), (Element)domBodyElement);
                    NodeList nlist = domBodyElement.getChildNodes();
                    for (int i = 0; i < nlist.getLength(); ++i) {
                        String nodeValue;
                        Node child = nlist.item(i);
                        short childType = child.getNodeType();
                        if (childType == 1) {
                            SOAPElementImpl soapElement = soapFactory.createElement((Element)child, true);
                            soapBodyElement.addChildElement(soapElement);
                            continue;
                        }
                        if (childType == 3) {
                            nodeValue = child.getNodeValue();
                            soapBodyElement.addTextNode(nodeValue);
                            continue;
                        }
                        if (childType == 4) {
                            nodeValue = child.getNodeValue();
                            soapBodyElement.addTextNode(nodeValue);
                            continue;
                        }
                        log.trace((Object)("Ignore child type: " + childType));
                    }
                } else {
                    throw new WSException("Unsupported message style: " + style);
                }
            }
        }
    }

    private void registerNamespaces(NamespaceRegistry namespaceRegistry, SOAPElement soapEl) {
        Iterator itNSPrefixes = soapEl.getNamespacePrefixes();
        while (itNSPrefixes.hasNext()) {
            String prefix = (String)itNSPrefixes.next();
            String nsURI = soapEl.getNamespaceURI(prefix);
            namespaceRegistry.registerURI(nsURI, prefix);
        }
    }

    private static ContentType getContentType(MimeHeaders headers) throws SOAPException {
        ContentType contentType = null;
        try {
            String[] type = headers.getHeader("Content-Type");
            contentType = type != null ? new ContentType(type[0]) : new ContentType("text/xml");
            return contentType;
        }
        catch (ParseException e) {
            throw new SOAPException("Could not parse content type:" + (Object)((Object)e));
        }
    }

    private boolean isSoapContent(ContentType type) {
        String baseType = type.getBaseType();
        return "text/xml".equals(baseType) || "application/soap+xml".equals(baseType);
    }

    private boolean isMultipartRelatedContent(ContentType type) {
        String baseType = type.getBaseType();
        return "multipart/related".equals(baseType);
    }
}

