/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.ws.metadata.EndpointMetaData;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointInfo {
    private String targetAddress;
    private Map<String, Object> properties;

    public EndpointInfo(EndpointMetaData epMetaData, String targetAddress, Map<String, Object> callProps) {
        Properties epProps;
        this.targetAddress = targetAddress;
        this.properties = new HashMap<String, Object>();
        Properties serviceProps = epMetaData.getServiceMetaData().getProperties();
        if (serviceProps != null) {
            for (Map.Entry<Object, Object> entry : serviceProps.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                this.properties.put(key, val);
            }
        }
        if ((epProps = epMetaData.getProperties()) != null) {
            for (Map.Entry<Object, Object> entry : epProps.entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                this.properties.put(key, val);
            }
        }
        if (callProps != null) {
            this.properties.putAll(callProps);
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getTargetAddress() {
        return this.targetAddress;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EndpointInfo)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return new StringBuffer().append("[addr=").append(this.targetAddress).append(",props=").append(this.properties).append("]").toString();
    }
}

