/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.lang.AnnotationHelper;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.utils.HolderUtils;
import org.jboss.xb.binding.Util;

public class WSDLUtils {
    private String newline = "\n";
    private static WSDLUtils instance = new WSDLUtils();
    private List wrapperlist = null;
    private List primlist = null;
    private final Map nillableMap = new HashMap();
    private static final Map<String, Class> schemaBasicTypes = new HashMap<String, Class>();
    private static final Map<Class, Class> holderTypes = new HashMap<Class, Class>();
    private static final Map<Class, Class> reverseHolderTypes = new HashMap<Class, Class>();
    private List<String> ignoredMethods;

    public static WSDLUtils getInstance() {
        return instance;
    }

    private WSDLUtils() {
        this.wrapperlist = new ArrayList();
        this.primlist = new ArrayList();
        this.populatePrimList();
        this.populateWrapperList();
        this.createNillableMap();
    }

    public boolean isPrimitive(String str) {
        return this.primlist.contains(str);
    }

    public boolean isWrapper(String str) {
        return this.wrapperlist.contains(str);
    }

    public boolean isBaseTypeIgnorable(XSTypeDefinition baseType, XSComplexTypeDefinition t) {
        boolean bool = false;
        if (baseType != null && baseType.getNamespace() == "http://www.w3.org/2001/XMLSchema" && baseType.getName().equals("anyType")) {
            bool = true;
        }
        if (1 == t.getContentType()) {
            bool = true;
        }
        return bool;
    }

    public boolean checkIgnoreClass(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Illegal null argument:cls");
        }
        if (!cls.isArray()) {
            String pkgname;
            String string = pkgname = cls.getPackage() != null ? cls.getPackage().getName() : null;
            if (pkgname != null && pkgname.startsWith("java")) {
                return true;
            }
            if (Class.forName("org.jboss.ws.jaxrpc.ParameterWrapping$WrapperType").isAssignableFrom(cls)) {
                return true;
            }
        }
        return false;
    }

    public boolean checkIgnoreMethod(Method method) {
        String methodname = method.getName();
        if (this.ignoredMethods == null) {
            this.ignoredMethods = new ArrayList<String>();
            Method[] objMethods = Class.forName("java.lang.Object").getMethods();
            for (int i = 0; i < objMethods.length; ++i) {
                this.ignoredMethods.add(objMethods[i].getName());
            }
            Method[] sbMethods = Class.forName("javax.ejb.SessionBean").getMethods();
            for (int i = 0; i < sbMethods.length; ++i) {
                this.ignoredMethods.add(sbMethods[i].getName());
            }
        }
        boolean ignoreMethod = this.ignoredMethods.contains(methodname);
        Class<?> clazz = Class.forName("javax.jws.WebService");
        GenericDeclaration genericDeclaration = method.getDeclaringClass();
        boolean bl = false;
        bl = AnnotationHelper.isAnnotationPresent(genericDeclaration, clazz);
        if (bl) {
            clazz = Class.forName("javax.jws.WebMethod");
            genericDeclaration = method;
            bl = false;
            bl = AnnotationHelper.isAnnotationPresent(genericDeclaration, clazz);
            if (!bl) {
                ignoreMethod = true;
            }
        }
        return ignoreMethod;
    }

    public String chopPortType(String name) {
        int index = name.lastIndexOf("PortType");
        if (index > 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public String chop(String name, String chopstr) {
        int index = name.lastIndexOf(chopstr);
        if (index > 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public File createPackage(String path, String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("Illegal Null Argument: packageName");
        }
        if (path == null) {
            throw new IllegalArgumentException("Illegal Null Argument: path");
        }
        String pac = packageName.replace('.', '/');
        File dir = new File(path + "/" + pac);
        dir.mkdirs();
        return dir;
    }

    public File createPhysicalFile(File loc, String fname) throws IOException {
        boolean boolCreate;
        if (loc == null) {
            throw new IllegalArgumentException("Illegal Null Argument: loc");
        }
        if (fname == null) {
            throw new IllegalArgumentException("Illegal Null Argument: fname");
        }
        File sei = new File(loc.getAbsolutePath() + "/" + fname + ".java");
        if (sei.exists()) {
            sei.delete();
        }
        if (!(boolCreate = sei.createNewFile())) {
            throw new WSException("SEI " + fname + ".java cannot be created");
        }
        return sei;
    }

    public StringBuffer createClassBasicStructure(String pkgname, String fname, XSTypeDefinition type, List importList, String baseName) {
        StringBuffer buf = new StringBuffer();
        this.writeJbossHeader(buf);
        buf.append(this.newline);
        buf.append("package " + pkgname + ";");
        buf.append(this.newline);
        buf.append(this.newline);
        if (importList != null) {
            Iterator iter = importList.iterator();
            while (iter.hasNext()) {
                buf.append("import " + (String)iter.next() + ";");
                buf.append(this.newline);
            }
        }
        buf.append(this.newline);
        XSTypeDefinition baseType = null;
        if (type instanceof XSComplexTypeDefinition) {
            XSComplexTypeDefinition t = (XSComplexTypeDefinition)type;
            baseType = t.getBaseType();
            if (baseType != null && baseType.getNamespace() == "http://www.w3.org/2001/XMLSchema" && baseType.getName().equals("anyType")) {
                baseType = null;
            }
            if (1 == t.getContentType()) {
                baseType = null;
            }
        }
        buf.append("public class  " + fname);
        if (baseName == null && baseType != null) {
            baseName = baseType.getName();
        }
        if (baseName != null) {
            buf.append(" extends " + baseName);
        }
        buf.append(this.newline);
        buf.append("{");
        buf.append(this.newline);
        return buf;
    }

    public boolean doesPublicFieldExist(Class javaType, String name) {
        Field fld = null;
        try {
            fld = javaType.getField(name);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        int mod = fld.getModifiers();
        return mod == 1;
    }

    public String firstLetterUpperCase(String fname) {
        if (fname == "" || fname == null) {
            throw new WSException("String passed is null");
        }
        if (Character.isLowerCase(fname.charAt(0))) {
            char f;
            char[] chars = fname.toCharArray();
            chars[0] = f = Character.toUpperCase(chars[0]);
            fname = new String(chars);
        }
        return fname;
    }

    public int getArrayDimension(Class arr) {
        if (arr == null || !arr.isArray()) {
            throw new IllegalArgumentException("Illegal null or array arg:arr");
        }
        int counter = 0;
        while (arr.isArray()) {
            ++counter;
            arr = arr.getComponentType();
        }
        return counter;
    }

    public Class getHolder(Class cls) {
        return holderTypes.get(cls);
    }

    public Class getJavaTypeForHolder(Class cls) {
        if (Class.forName("javax.xml.rpc.holders.Holder").isAssignableFrom(cls)) {
            return HolderUtils.getValueType(cls);
        }
        return cls;
    }

    public String getMessagePartForArray(Class javaType) {
        StringBuffer sb = new StringBuffer();
        while (javaType.isArray()) {
            sb.append("arrayOf");
            javaType = javaType.getComponentType();
        }
        sb.append(this.getJustClassName(javaType));
        return sb.toString();
    }

    public String getJustClassName(Class cls) {
        if (cls == null) {
            return null;
        }
        if (cls.isArray()) {
            Class<?> c = cls.getComponentType();
            return this.getJustClassName(c.getName());
        }
        return this.getJustClassName(cls.getName());
    }

    public String getJustClassName(String classname) {
        int index = classname.lastIndexOf(".");
        index = index < 0 ? 0 : ++index;
        return classname.substring(index);
    }

    public Field[] getPublicFields(Class cls) {
        ArrayList<Field> list = new ArrayList<Field>();
        Field[] fld = cls.getDeclaredFields();
        for (int i = 0; i < fld.length; ++i) {
            Field field = fld[i];
            int mod = field.getModifiers();
            if (mod != 1) continue;
            list.add(field);
        }
        Field[] retarr = new Field[list.size()];
        list.toArray(retarr);
        return retarr;
    }

    public Method[] getPublicProtectedMethods(Method[] methods) {
        ArrayList<Method> list = new ArrayList<Method>();
        int len = methods.length;
        for (int i = 0; i < len; ++i) {
            Method method = methods[i];
            int mod = method.getModifiers();
            if (mod != 1 && mod != 4) continue;
            list.add(method);
        }
        Method[] retarr = new Method[list.size()];
        list.toArray(retarr);
        return retarr;
    }

    public Class getJavaType(QName xmlType) {
        if (xmlType == null) {
            return null;
        }
        String localPart = xmlType.getLocalPart();
        return schemaBasicTypes.get(localPart);
    }

    public String getMixedCase(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("String passed to WSDLUtils.getMixedCase is null");
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        char[] charr = str.toCharArray();
        charr[0] = Character.toUpperCase(charr[0]);
        return new String(charr);
    }

    public String getFormattedString(QName qn) {
        if (qn == null) {
            throw new IllegalArgumentException(" QName passed is null");
        }
        StringBuffer sb = new StringBuffer();
        String prefix = qn.getPrefix();
        String localpart = qn.getLocalPart();
        if (prefix == null || prefix == "") {
            prefix = "tns";
        }
        sb.append(prefix + ":");
        sb.append(localpart);
        return sb.toString();
    }

    public QName getQName(String formattedStr) {
        QName qn = null;
        int ind = formattedStr.lastIndexOf(":");
        if (ind < 0) {
            throw new IllegalArgumentException("Formatted String is not of format prefix:localpart");
        }
        String prefix = formattedStr.substring(0, ind);
        String nsuri = null;
        if ("xsd".equals(prefix)) {
            nsuri = "http://www.w3.org/2001/XMLSchema";
        }
        qn = nsuri == null ? new QName(formattedStr.substring(ind + 1)) : new QName(nsuri, formattedStr.substring(ind + 1), prefix);
        return qn;
    }

    public String getNillableEquivalent(String str) {
        return (String)this.nillableMap.get(str);
    }

    public String getPackageName(String typeNS) {
        String pkgname = Util.xmlNamespaceToJavaPackage((String)typeNS);
        int len = pkgname.length();
        if (pkgname.endsWith(".jaws")) {
            pkgname = pkgname.substring(0, len - 5);
        }
        return pkgname;
    }

    public String getTypeNamespace(Class javaType) {
        return this.getTypeNamespace(javaType.getPackage().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTypeNamespace(String packageName) {
        StringBuffer sb = new StringBuffer("http://");
        StringTokenizer st = new StringTokenizer(packageName, ".");
        Stack<String> stk = new Stack<String>();
        while (st != null && st.hasMoreTokens()) {
            stk.push(st.nextToken());
        }
        try {
            while (stk != null) {
                String str = (String)stk.pop();
                if (!sb.toString().equals("http://")) {
                    sb.append(".");
                }
                sb.append(str);
            }
        }
        catch (EmptyStackException e) {
        }
        finally {
            sb.append("/jaws");
        }
        return sb.toString();
    }

    public String getWSDLStyle(WSDLDefinitions wsdl) {
        WSDLInterface wi = wsdl.getInterfaces()[0];
        WSDLInterfaceOperation wio = wi.getOperations()[0];
        String style = wio.getStyle();
        if (style == null || style.equals("http://www.w3.org/2004/03/wsdl/style/rpc") || "rpc".equalsIgnoreCase(style)) {
            return "RPC/Literal";
        }
        return "Document/Literal";
    }

    public boolean isStandardHolder(Class cls) {
        if (!Class.forName("javax.xml.rpc.holders.Holder").isAssignableFrom(cls)) {
            return false;
        }
        return cls.getPackage().getName().startsWith("javax.xml.rpc");
    }

    public void writeJbossHeader(StringBuffer buf) {
        buf.append("/*").append(this.newline);
        buf.append(" * JBossWS WS-Tools Generated Source").append(this.newline);
        buf.append(" *").append(this.newline);
        buf.append(" * Generation Date: " + new Date() + this.newline);
        buf.append(" *").append(this.newline);
        buf.append(" * This generated source code represents a derivative work of the input to").append(this.newline);
        buf.append(" * the generator that produced it. Consult the input for the copyright and").append(this.newline);
        buf.append(" * terms of use that apply to this source code.").append(this.newline);
        buf.append(" */").append(this.newline);
    }

    protected void populatePrimList() {
        this.primlist.add("int");
        this.primlist.add("boolean");
        this.primlist.add("short");
        this.primlist.add("byte");
        this.primlist.add("long");
        this.primlist.add("float");
        this.primlist.add("double");
    }

    protected void populateWrapperList() {
        this.wrapperlist.add("java.lang.Integer");
        this.wrapperlist.add("java.lang.Boolean");
        this.wrapperlist.add("java.lang.Short");
        this.wrapperlist.add("java.lang.Byte");
        this.wrapperlist.add("java.lang.Long");
        this.wrapperlist.add("java.lang.Float");
        this.wrapperlist.add("java.lang.Double");
        this.wrapperlist.add("java.lang.String");
        this.wrapperlist.add("java.math.BigInteger");
        this.wrapperlist.add("java.math.BigDecimal");
        this.wrapperlist.add("java.util.Calendar");
        this.wrapperlist.add("javax.xml.namespace.QName");
    }

    private void createNillableMap() {
        this.nillableMap.put("Integer", "int");
        this.nillableMap.put("Float", "float");
        this.nillableMap.put("Long", "long");
        this.nillableMap.put("Double", "double");
        this.nillableMap.put("Short", "short");
        this.nillableMap.put("Boolean", "boolean");
        this.nillableMap.put("Byte", "byte");
        this.nillableMap.put("java.lang.Integer", "int");
        this.nillableMap.put("java.lang.Float", "float");
        this.nillableMap.put("java.lang.Long", "long");
        this.nillableMap.put("java.lang.Double", "double");
        this.nillableMap.put("java.lang.Short", "short");
        this.nillableMap.put("java.lang.Boolean", "boolean");
        this.nillableMap.put("java.lang.Byte", "byte");
    }

    static {
        schemaBasicTypes.put("anyURI", Class.forName("java.net.URI"));
        schemaBasicTypes.put("boolean", Boolean.TYPE);
        schemaBasicTypes.put("byte", Byte.TYPE);
        schemaBasicTypes.put("decimal", Class.forName("java.math.BigDecimal"));
        schemaBasicTypes.put("double", Double.TYPE);
        schemaBasicTypes.put("dateTime", Class.forName("java.util.Calendar"));
        schemaBasicTypes.put("float", Float.TYPE);
        schemaBasicTypes.put("int", Integer.TYPE);
        schemaBasicTypes.put("integer", Class.forName("java.math.BigInteger"));
        schemaBasicTypes.put("long", Long.TYPE);
        schemaBasicTypes.put("QName", Class.forName("javax.xml.namespace.QName"));
        schemaBasicTypes.put("short", Short.TYPE);
        schemaBasicTypes.put("String", Class.forName("java.lang.String"));
        holderTypes.put(Class.forName("java.math.BigDecimal"), Class.forName("javax.xml.rpc.holders.BigDecimalHolder"));
        holderTypes.put(Class.forName("java.math.BigInteger"), Class.forName("javax.xml.rpc.holders.BigIntegerHolder"));
        holderTypes.put(Boolean.TYPE, Class.forName("javax.xml.rpc.holders.BooleanHolder"));
        holderTypes.put(Class.forName("java.lang.Boolean"), Class.forName("javax.xml.rpc.holders.BooleanWrapperHolder"));
        holderTypes.put(Byte.TYPE, Class.forName("javax.xml.rpc.holders.ByteHolder"));
        holderTypes.put(Class.forName("java.lang.Byte"), Class.forName("javax.xml.rpc.holders.ByteWrapperHolder"));
        holderTypes.put(Class.forName("[Ljava.lang.Byte;"), Class.forName("javax.xml.rpc.holders.ByteArrayHolder"));
        holderTypes.put(Class.forName("java.util.Calendar"), Class.forName("javax.xml.rpc.holders.CalendarHolder"));
        holderTypes.put(Double.TYPE, Class.forName("javax.xml.rpc.holders.DoubleHolder"));
        holderTypes.put(Class.forName("java.lang.Double"), Class.forName("javax.xml.rpc.holders.DoubleWrapperHolder"));
        holderTypes.put(Float.TYPE, Class.forName("javax.xml.rpc.holders.FloatHolder"));
        holderTypes.put(Class.forName("java.lang.Float"), Class.forName("javax.xml.rpc.holders.FloatWrapperHolder"));
        holderTypes.put(Integer.TYPE, Class.forName("javax.xml.rpc.holders.IntHolder"));
        holderTypes.put(Class.forName("java.lang.Integer"), Class.forName("javax.xml.rpc.holders.IntegerWrapperHolder"));
        holderTypes.put(Long.TYPE, Class.forName("javax.xml.rpc.holders.LongHolder"));
        holderTypes.put(Class.forName("java.lang.Long"), Class.forName("javax.xml.rpc.holders.LongWrapperHolder"));
        holderTypes.put(Class.forName("java.lang.Object"), Class.forName("javax.xml.rpc.holders.ObjectHolder"));
        holderTypes.put(Class.forName("javax.xml.namespace.QName"), Class.forName("javax.xml.rpc.holders.QNameHolder"));
        holderTypes.put(Short.TYPE, Class.forName("javax.xml.rpc.holders.ShortHolder"));
        holderTypes.put(Class.forName("java.lang.Short"), Class.forName("javax.xml.rpc.holders.ShortWrapperHolder"));
        holderTypes.put(Class.forName("java.lang.String"), Class.forName("javax.xml.rpc.holders.StringHolder"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.BigDecimalHolder"), Class.forName("java.math.BigDecimal"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.BigIntegerHolder"), Class.forName("java.math.BigInteger"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.BooleanHolder"), Boolean.TYPE);
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.BooleanWrapperHolder"), Class.forName("java.lang.Boolean"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.ByteArrayHolder"), Class.forName("[Ljava.lang.Byte;"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.ByteHolder"), Byte.TYPE);
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.ByteWrapperHolder"), Class.forName("java.lang.Byte"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.CalendarHolder"), Class.forName("java.util.Calendar"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.DoubleHolder"), Double.TYPE);
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.DoubleWrapperHolder"), Class.forName("java.lang.Double"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.FloatHolder"), Float.TYPE);
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.FloatWrapperHolder"), Class.forName("java.lang.Float"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.IntHolder"), Integer.TYPE);
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.IntegerWrapperHolder"), Class.forName("java.lang.Integer"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.LongHolder"), Long.TYPE);
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.LongWrapperHolder"), Class.forName("java.lang.Long"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.ObjectHolder"), Class.forName("java.lang.Object"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.QNameHolder"), Class.forName("javax.xml.namespace.QName"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.ShortHolder"), Short.TYPE);
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.ShortWrapperHolder"), Class.forName("java.lang.Short"));
        reverseHolderTypes.put(Class.forName("javax.xml.rpc.holders.StringHolder"), Class.forName("java.lang.String"));
    }
}

