/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.wsdl.xml.WSDLLocator;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLException;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;

public class WSDL20Reader
implements ObjectModelFactory {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.wsdl.WSDL20Reader"));
    private WSDLLocator locator = null;

    public WSDLDefinitions readWSDL(WSDLLocator wsdlLocator) throws WSDLException, IOException {
        this.locator = wsdlLocator;
        String wsdlURI = wsdlLocator.getBaseURI();
        InputSource inputSource = wsdlLocator.getBaseInputSource();
        if (inputSource == null) {
            throw new WSException("Cannot obtain WSDL input source for: " + wsdlURI);
        }
        InputStream is = inputSource.getByteStream();
        try {
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            unmarshaller.setNamespaceAware(true);
            unmarshaller.setValidation(true);
            WSDLDefinitions wsdl = new WSDLDefinitions();
            wsdl.setWsdlNamespace("http://www.w3.org/2003/11/wsdl");
            unmarshaller.unmarshal(is, (ObjectModelFactory)this, (Object)wsdl);
            WSDLDefinitions wSDLDefinitions = wsdl;
            return wSDLDefinitions;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new WSDLException("Cannot unmarshal: " + wsdlURI, e);
        }
        finally {
            is.close();
        }
    }

    public void setFeature(String name, boolean value) {
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        WSDLDefinitions wsdl = null;
        StringBuffer buf = null;
        if (root instanceof WSDLDefinitions) {
            wsdl = (WSDLDefinitions)root;
            String targetNamespace = attrs.getValue("targetNamespace");
            boolean abs = targetNamespace.startsWith("http");
            if (targetNamespace == null || !abs) {
                throw new RuntimeException("WSDL 2.0 Assertion: targetNamespace must be an absolute uri");
            }
            wsdl.setWsdlNamespace("http://www.w3.org/2003/11/wsdl");
            wsdl.setTargetNamespace(targetNamespace);
            Iterator uris = navigator.getNamespaceURIs();
            while (uris.hasNext()) {
                String namespace = (String)uris.next();
                String prefix = navigator.getNamespaceContext().getPrefix(namespace);
                if (prefix.length() <= 0) continue;
                wsdl.registerNamespaceURI(namespace, prefix);
            }
            return wsdl;
        }
        if (root instanceof WSDLTypes) {
            wsdl = ((WSDLTypes)root).getWsdlDefinitions();
            if ("import".equalsIgnoreCase(localName)) {
                this.importTypes(wsdl, attrs);
                return null;
            }
            if ("schema".equalsIgnoreCase(localName)) {
                buf = new StringBuffer("<schema ");
                Iterator uris = navigator.getNamespaceURIs();
                String targetNS = attrs.getValue("targetNamespace");
                buf.append(" targetNamespace='" + targetNS + "'");
                while (uris.hasNext()) {
                    String namespace = (String)uris.next();
                    Iterator<String> iter = navigator.getNamespaceContext().getPrefixes(namespace);
                    if (namespace.equals("http://www.w3.org/2003/11/wsdl")) continue;
                    if (iter == null) {
                        buf.append(" xmlns='" + namespace + "'");
                        continue;
                    }
                    while (iter.hasNext()) {
                        String prefix = iter.next();
                        if (prefix.length() == 0) {
                            buf.append(" xmlns='" + namespace + "'");
                            continue;
                        }
                        buf.append(" xmlns:" + prefix + "='" + namespace + "'");
                    }
                }
                buf.append(">");
                return buf;
            }
        } else {
            if (root instanceof StringBuffer) {
                return this.newChild((StringBuffer)root, navigator, namespaceURI, localName, attrs);
            }
            throw new IllegalArgumentException("Invalid root for namespace: " + namespaceURI);
        }
        return null;
    }

    public Object newChild(WSDLTypes types, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        WSDLDefinitions wsdl = types.getWsdlDefinitions();
        StringBuffer buf = null;
        if ("import".equalsIgnoreCase(localName)) {
            this.importTypes(wsdl, attrs);
            return null;
        }
        if ("schema".equalsIgnoreCase(localName)) {
            buf = new StringBuffer("<schema ");
            Iterator uris = navigator.getNamespaceURIs();
            String targetNS = attrs.getValue("targetNamespace");
            buf.append(" targetNamespace='" + targetNS + "'");
            while (uris.hasNext()) {
                String namespace = (String)uris.next();
                Iterator<String> iter = navigator.getNamespaceContext().getPrefixes(namespace);
                if (namespace.equals("http://www.w3.org/2003/11/wsdl")) continue;
                if (iter == null) {
                    buf.append(" xmlns='" + namespace + "'");
                    continue;
                }
                while (iter.hasNext()) {
                    String prefix = iter.next();
                    if (prefix.length() == 0) {
                        buf.append(" xmlns='" + namespace + "'");
                        continue;
                    }
                    buf.append(" xmlns:" + prefix + "='" + namespace + "'");
                }
            }
            buf.append(">");
            return buf;
        }
        return null;
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    public Object newChild(StringBuffer buf, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        int len = attrs.getLength();
        buf.append("<" + localName);
        for (int i = 0; i < len; ++i) {
            String val = attrs.getValue(i);
            String attrname = attrs.getLocalName(i);
            buf.append(" " + attrname + "='" + val + "'");
        }
        buf.append(">");
        return buf;
    }

    public Object addChild(StringBuffer buf, StringBuffer buf1, UnmarshallingContext navigator, String namespaceURI, String localName) throws WSDLException {
        buf.append("</" + localName + ">");
        return buf;
    }

    public Object addChild(WSDLTypes types, StringBuffer buf, UnmarshallingContext navigator, String namespaceURI, String localName) throws WSDLException {
        buf.append("</schema>");
        String targetNS = types.getWsdlDefinitions().getTargetNamespace();
        try {
            File file = SchemaUtils.getSchemaTempFile(targetNS);
            file.deleteOnExit();
            FileWriter fwrite = new FileWriter(file);
            fwrite.write(buf.toString());
            fwrite.flush();
            fwrite.close();
        }
        catch (IOException e) {
            String msg = "Cannot extract schema definition for target namespace: " + targetNS;
            log.error((Object)msg, (Throwable)e);
            throw new WSException(msg);
        }
        return types;
    }

    public Object newChild(WSDLDefinitions wsdl20, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) throws WSDLException {
        String defaultNamespace = wsdl20.getWsdlNamespace();
        if ("http://www.w3.org/2003/11/wsdl".equals(defaultNamespace)) {
            if ("types".equals(localName)) {
                WSDLTypes wsdlTypes = new WSDLTypes(wsdl20);
                wsdl20.setWsdlTypes(wsdlTypes);
                return wsdlTypes;
            }
            if ("interface".equals(localName)) {
                WSDLInterface wsdlInterface = new WSDLInterface(wsdl20);
                String name = attrs.getValue("name");
                if (name == null) {
                    throw new RuntimeException("Interface name should not be null");
                }
                if (name.indexOf(" ") > -1 || name.indexOf(":") > -1) {
                    throw new RuntimeException("WSDL 2.0 Assertion:Interface names are tokens that must not contain a space or colon");
                }
                NCName ncname = new NCName(name);
                if (wsdl20.getInterface(ncname) != null) {
                    throw new RuntimeException("WSDL 2.0 Assertion:Each interface must be given a name that is unique within the set of interfaces defined in this WSDL target namespace");
                }
                wsdlInterface.setName(ncname);
                wsdl20.addInterface(wsdlInterface);
                return wsdlInterface;
            }
            if ("binding".equals(localName)) {
                String name = attrs.getValue("name");
                NCName ncname = new NCName(name);
                if (wsdl20.getBinding(ncname) != null) {
                    throw new RuntimeException("WSDL 2.0 Assertion:Each name must be unique among all bindings in this WSDL target namespace");
                }
                WSDLBinding wsdlBinding = new WSDLBinding(wsdl20);
                wsdlBinding.setName(ncname);
                wsdl20.addBinding(wsdlBinding);
                return wsdlBinding;
            }
            if ("service".equals(localName)) {
                WSDLService wsdlService = new WSDLService(wsdl20);
                wsdlService.setName(new NCName(attrs.getValue("name")));
                wsdl20.addService(wsdlService);
                wsdlService.setInterfaceName(navigator.resolveQName(attrs.getValue("interface")));
                return wsdlService;
            }
        } else {
            throw new WSDLException("Invalid default namespace: " + defaultNamespace);
        }
        log.warn((Object)("Unrecogized child element: " + localName));
        return null;
    }

    public Object newChild(WSDLInterface wsdlInterface, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("operation".equals(localName)) {
            String name = attrs.getValue("name");
            if (name == null) {
                throw new RuntimeException("Operation name must not be null");
            }
            NCName ncname = new NCName(name);
            if (wsdlInterface.containsInterfaceOperation(ncname)) {
                throw new RuntimeException("WSDL 2.0 Assertion:Each operation must be given a name that is unique within an interface defined in this WSDL target namespace");
            }
            WSDLInterfaceOperation wsdlOperation = new WSDLInterfaceOperation(wsdlInterface);
            wsdlOperation.setName(ncname);
            wsdlInterface.addOperation(wsdlOperation);
            return wsdlOperation;
        }
        log.warn((Object)("Unrecogized child element: " + localName));
        return null;
    }

    public Object newChild(WSDLInterfaceOperation wsdlOperation, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("input".equals(localName)) {
            WSDLInterfaceOperationInput wsdlInterfaceOperationInput = new WSDLInterfaceOperationInput(wsdlOperation);
            wsdlInterfaceOperationInput.setElement(navigator.resolveQName(attrs.getValue("element")));
            wsdlInterfaceOperationInput.setMessageLabel(new NCName(attrs.getValue("messageLabel")));
            wsdlOperation.addInput(wsdlInterfaceOperationInput);
            return wsdlInterfaceOperationInput;
        }
        if ("output".equals(localName)) {
            WSDLInterfaceOperationOutput output = new WSDLInterfaceOperationOutput(wsdlOperation);
            output.setElement(navigator.resolveQName(attrs.getValue("element")));
            output.setMessageLabel(new NCName(attrs.getValue("messageLabel")));
            wsdlOperation.addOutput(output);
            return output;
        }
        if ("outfault".equals(localName)) {
            WSDLInterfaceOperationOutfault fault = new WSDLInterfaceOperationOutfault(wsdlOperation);
            String messageLabel = attrs.getValue("messageLabel");
            fault.setRef(navigator.resolveQName(attrs.getValue("ref")));
            if (messageLabel != null) {
                fault.setMessageLabel(new NCName(messageLabel));
            }
            wsdlOperation.addOutfault(fault);
            return wsdlOperation;
        }
        log.warn((Object)("Unrecogized child element: " + localName));
        return null;
    }

    public Object newChild(WSDLBinding wsdlBinding, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("operation".equals(localName)) {
            WSDLBindingOperation wsdlBindingOperation = new WSDLBindingOperation(wsdlBinding);
            wsdlBindingOperation.setRef(navigator.resolveQName(attrs.getValue("ref")));
            wsdlBinding.addOperation(wsdlBindingOperation);
            return wsdlBindingOperation;
        }
        log.warn((Object)("Unrecogized child element: " + localName));
        return null;
    }

    public Object newChild(WSDLBindingOperation wsdlBindingOperation, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("input".equals(localName)) {
            WSDLBindingOperationInput wsdlBindingOperationInput = new WSDLBindingOperationInput(wsdlBindingOperation);
            wsdlBindingOperationInput.setMessageLabel(new NCName(attrs.getValue("messageLabel")));
            wsdlBindingOperation.addInput(wsdlBindingOperationInput);
            return wsdlBindingOperationInput;
        }
        if ("output".equals(localName)) {
            WSDLBindingOperationOutput wsdlBindingOperationOutput = new WSDLBindingOperationOutput(wsdlBindingOperation);
            wsdlBindingOperationOutput.setMessageLabel(new NCName(attrs.getValue("messageLabel")));
            wsdlBindingOperation.addOutput(wsdlBindingOperationOutput);
            return wsdlBindingOperationOutput;
        }
        log.warn((Object)("Unrecogized child element: " + localName));
        return null;
    }

    public Object newChild(WSDLService wsdlService, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("endpoint".equals(localName)) {
            WSDLEndpoint wsdlEndpoint = new WSDLEndpoint(wsdlService);
            wsdlEndpoint.setName(new NCName(attrs.getValue("name")));
            wsdlEndpoint.setBinding(navigator.resolveQName(attrs.getValue("binding")));
            wsdlService.addEndpoint(wsdlEndpoint);
            return wsdlEndpoint;
        }
        log.warn((Object)("Unrecogized child element: " + localName));
        return null;
    }

    private void importTypes(WSDLDefinitions wsdl, Attributes attrs) {
    }
}

