/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.webservice.metadata.serviceref.InitParamMetaData;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.config.WSClientConfig;
import org.jboss.ws.metadata.config.WSCommonConfig;
import org.jboss.ws.metadata.config.WSConfig;
import org.jboss.ws.metadata.config.WSEndpointConfig;
import org.jboss.ws.metadata.config.WSHandlerChainConfig;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
import org.xml.sax.Attributes;

public class WSConfigFactory
implements ObjectModelFactory {
    private final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.config.WSConfigFactory"));

    private WSConfigFactory() {
    }

    public static WSConfigFactory newInstance() {
        return new WSConfigFactory();
    }

    public WSConfig parseWithSchemaBinding(URL configURL) throws IOException, JBossXBException {
        this.log.debug((Object)("parse: " + configURL));
        String configSchema = "schema/jbossws_config_1_0.xsd";
        URL xsdURL = Thread.currentThread().getContextClassLoader().getResource(configSchema);
        if (xsdURL == null) {
            throw new WSException("Cannot find: " + configSchema);
        }
        InputStream xsd = xsdURL.openStream();
        SchemaBinding schemaBinding = XsdBinder.bind((InputStream)xsd, (String)"UTF-8");
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        WSConfig wsConfig = (WSConfig)unmarshaller.unmarshal(configURL.openStream(), schemaBinding);
        return wsConfig;
    }

    public WSConfig parseWithObjectModelFactory(URL configURL) throws IOException, JBossXBException {
        this.log.debug((Object)("parse: " + configURL));
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        WSConfig wsConfig = (WSConfig)unmarshaller.unmarshal(configURL.openStream(), (ObjectModelFactory)this, null);
        return wsConfig;
    }

    public Object newRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs) {
        return new WSConfig();
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName) {
        return root;
    }

    public Object newChild(WSConfig wsConfig, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        this.log.trace((Object)("WSConfig newChild: " + localName));
        if ("endpoint-config".equals(localName)) {
            WSEndpointConfig wsEndpointConfig = new WSEndpointConfig();
            wsConfig.getEndpointConfig().add(wsEndpointConfig);
            return wsEndpointConfig;
        }
        if ("client-config".equals(localName)) {
            WSClientConfig wsClientConfig = new WSClientConfig();
            wsConfig.getClientConfig().add(wsClientConfig);
            return wsClientConfig;
        }
        return null;
    }

    public void setValue(WSCommonConfig wsCommonConfig, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("WSCommonConfig setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        if (localName.equals("config-name")) {
            wsCommonConfig.setConfigName(value);
        }
    }

    public Object newChild(WSCommonConfig wsCommonConfig, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        this.log.trace((Object)("WSCommonConfig newChild: " + localName));
        if ("pre-handler-chain".equals(localName)) {
            WSHandlerChainConfig preHandlerChain = new WSHandlerChainConfig();
            wsCommonConfig.setPreHandlerChain(preHandlerChain);
            return preHandlerChain;
        }
        if ("post-handler-chain".equals(localName)) {
            WSHandlerChainConfig postHandlerChain = new WSHandlerChainConfig();
            wsCommonConfig.setPostHandlerChain(postHandlerChain);
            return postHandlerChain;
        }
        return null;
    }

    public void setValue(WSHandlerChainConfig wsHandlerChainConfig, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("WSHandlerChainConfig setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        if (localName.equals("handler-chain-name")) {
            wsHandlerChainConfig.setHandlerChainName(value);
        }
    }

    public Object newChild(WSHandlerChainConfig wsHandlerChainConfig, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        this.log.trace((Object)("WSHandlerChainConfig newChild: " + localName));
        if ("handler".equals(localName)) {
            HandlerMetaData handler = new HandlerMetaData();
            List<HandlerMetaData> handlers = wsHandlerChainConfig.getHandlers();
            handlers.add(handler);
            return handler;
        }
        return null;
    }

    public void setValue(HandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("HandlerMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        if (localName.equals("handler-name")) {
            handler.setHandlerName(value);
        } else if (localName.equals("handler-class")) {
            handler.setHandlerClass(value);
        } else if (localName.equals("soap-header")) {
            handler.addSoapHeader(navigator.resolveQName(value));
        } else if (localName.equals("soap-role")) {
            handler.addSoapRole(value);
        }
    }

    public void setValue(InitParamMetaData param, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("InitParamMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        if (localName.equals("param-name")) {
            param.setParamName(value);
        } else if (localName.equals("param-value")) {
            param.setParamValue(value);
        }
    }
}

