/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.TypeMappingMetaData;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesMetaData {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.TypesMetaData"));
    private ServiceMetaData serviceMetaData;
    private List<TypeMappingMetaData> typeList = new ArrayList<TypeMappingMetaData>();
    private JBossXSModel schemaModel;

    public TypesMetaData(ServiceMetaData serviceMetaData) {
        this.serviceMetaData = serviceMetaData;
    }

    public ServiceMetaData getServiceMetaData() {
        return this.serviceMetaData;
    }

    public JBossXSModel getSchemaModel() {
        return this.schemaModel;
    }

    public void setSchemaModel(JBossXSModel model) {
        this.schemaModel = model;
    }

    public void addSchemaModel(JBossXSModel model) {
        if (this.schemaModel == null) {
            this.schemaModel = model;
        } else {
            this.schemaModel.merge(model);
        }
    }

    public List<TypeMappingMetaData> getTypeMappings() {
        return new ArrayList<TypeMappingMetaData>(this.typeList);
    }

    public void addTypeMapping(TypeMappingMetaData tmMetaData) {
        if (!this.typeList.contains(tmMetaData)) {
            log.trace((Object)new StringBuffer().append("Add type mapping: ").append(tmMetaData).toString());
            this.typeList.add(tmMetaData);
        }
    }

    public TypeMappingMetaData getTypeMappingByXMLType(QName xmlType) {
        XSTypeDefinition xsType;
        TypeMappingMetaData tmMetaData = null;
        for (TypeMappingMetaData aux : this.typeList) {
            boolean isElementScope = "element".equals(aux.getQNameScope());
            if (!aux.getXmlType().equals(xmlType) || isElementScope) continue;
            if (tmMetaData != null) {
                log.error((Object)new StringBuffer().append(tmMetaData).append("\n").append(aux).toString());
                throw new WSException(new StringBuffer().append("Ambiguous type mappping for: ").append(xmlType).toString());
            }
            tmMetaData = aux;
        }
        if (tmMetaData == null && (xsType = this.schemaModel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI())) instanceof XSSimpleTypeDefinition) {
            XSSimpleTypeDefinition itemType;
            QName xmlBaseType;
            XSSimpleTypeDefinition xsSimpleType = (XSSimpleTypeDefinition)xsType;
            String javaTypeName = null;
            if (xsSimpleType.getVariety() == 2 && (javaTypeName = new LiteralTypeMapping().getJavaTypeName(xmlBaseType = new QName((itemType = xsSimpleType.getItemType()).getNamespace(), itemType.getName()))) != null) {
                javaTypeName = new StringBuffer().append(javaTypeName).append("[]").toString();
            }
            for (XSTypeDefinition xsBaseType = xsType.getBaseType(); javaTypeName == null && xsBaseType != null; xsBaseType = xsBaseType.getBaseType()) {
                xmlBaseType = new QName(xsBaseType.getNamespace(), xsBaseType.getName());
                javaTypeName = new LiteralTypeMapping().getJavaTypeName(xmlBaseType);
            }
            if (javaTypeName != null) {
                tmMetaData = new TypeMappingMetaData(this, xmlType, javaTypeName);
                tmMetaData.setQNameScope("simpleType");
                log.debug((Object)new StringBuffer().append("Adding a simpleType without jaxrpc-mapping: ").append(tmMetaData).toString());
                this.addTypeMapping(tmMetaData);
            } else {
                log.warn((Object)new StringBuffer().append("Cannot obtain javaTypeName for xmlType: ").append(xmlType).toString());
            }
        }
        return tmMetaData;
    }

    public TypeMappingMetaData getTypeMappingByJavaType(String javaTypeName) {
        TypeMappingMetaData tmMetaData = null;
        for (TypeMappingMetaData aux : this.typeList) {
            if (!aux.getJavaTypeName().equals(javaTypeName)) continue;
            tmMetaData = aux;
        }
        return tmMetaData;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("\nTypesMetaData: ");
        for (TypeMappingMetaData tmd : this.typeList) {
            buffer.append(new StringBuffer().append("\n  ").append(tmd).toString());
        }
        buffer.append(new StringBuffer().append("\n").append(this.schemaModel != null ? this.schemaModel.serialize() : "<schema/>").toString());
        return buffer.toString();
    }
}

