/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EjbPortComponentMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.util.xml.DOMUtils;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.JSR109MetaDataBuilder;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.jsr109.PortComponentMetaData;
import org.jboss.ws.metadata.jsr109.WebserviceDescriptionMetaData;
import org.jboss.ws.metadata.jsr109.WebservicesFactory;
import org.jboss.ws.metadata.jsr109.WebservicesMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.metadata.wsse.WSSecurityConfigurationFactory;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSR109ServerMetaDataBuilder
extends JSR109MetaDataBuilder {
    final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.JSR109ServerMetaDataBuilder"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnifiedMetaData buildMetaData(DeploymentInfo di, URL webservicesURL) {
        this.log.debug((Object)("START buildMetaData: [url=" + webservicesURL + "]"));
        try {
            WebserviceDescriptionMetaData[] wsDescriptionArr;
            WebservicesMetaData webservices = null;
            InputStream is = webservicesURL.openStream();
            try {
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                WebservicesFactory factory = new WebservicesFactory(webservicesURL);
                webservices = (WebservicesMetaData)unmarshaller.unmarshal(is, (ObjectModelFactory)factory, null);
            }
            finally {
                is.close();
            }
            WSSecurityConfiguration securityConfiguration = this.getWsSecurityConfiguration(di);
            UnifiedMetaData wsMetaData = new UnifiedMetaData();
            wsMetaData.setResourceLoader(this.resourceLoader);
            wsMetaData.setClassLoader(this.classLoader);
            WebserviceDescriptionMetaData[] arr$ = wsDescriptionArr = webservices.getWebserviceDescriptions();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                PortComponentMetaData[] pcMetaDataArr;
                WebserviceDescriptionMetaData wsdMetaData = arr$[i$];
                ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, null);
                serviceMetaData.setWebserviceDescriptionName(wsdMetaData.getWebserviceDescriptionName());
                wsMetaData.addService(serviceMetaData);
                serviceMetaData.setWsdlFile(wsdMetaData.getWsdlFile());
                WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
                serviceMetaData.setJaxrpcMappingFile(wsdMetaData.getJaxrpcMappingFile());
                JavaWsdlMapping javaWsdlMapping = serviceMetaData.getJavaWsdlMapping();
                this.setupTypesMetaData(serviceMetaData);
                serviceMetaData.setSecurityConfiguration(securityConfiguration);
                PortComponentMetaData[] arr$2 = pcMetaDataArr = wsdMetaData.getPortComponents();
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    WSDLEndpoint wsdlEndpoint;
                    PortComponentMetaData pcMetaData = arr$2[i$2];
                    QName epName = pcMetaData.getWsdlPort();
                    if (epName.getNamespaceURI().length() == 0) {
                        String nsURI = wsdlDefinitions.getTargetNamespace();
                        epName = new QName(nsURI, epName.getLocalPart());
                        this.log.warn((Object)("Adding wsdl targetNamespace to: " + epName));
                        pcMetaData.setWsdlPort(epName);
                    }
                    if ((wsdlEndpoint = this.getWsdlEndpoint(wsdlDefinitions, epName)) == null) {
                        throw new WSException("Cannot find port in wsdl: " + epName);
                    }
                    serviceMetaData.setName(wsdlEndpoint.getWsdlService().getQName());
                    ServerEndpointMetaData epMetaData = new ServerEndpointMetaData(serviceMetaData, epName);
                    epMetaData.setPortComponentName(pcMetaData.getPortComponentName());
                    String ejbLink = pcMetaData.getEjbLink();
                    String servletLink = pcMetaData.getServletLink();
                    epMetaData.setLinkName(servletLink != null ? servletLink : ejbLink);
                    serviceMetaData.addEndpoint(epMetaData);
                    this.initEndpointEncodingStyle(epMetaData);
                    ObjectName serviceEndpointID = this.getServiceEndpointID(di, epMetaData);
                    epMetaData.setEndpointID(serviceEndpointID);
                    if (di.metaData instanceof ApplicationMetaData) {
                        EjbPortComponentMetaData bpcMetaData;
                        String configFile;
                        ApplicationMetaData applMetaData = (ApplicationMetaData)di.metaData;
                        BeanMetaData beanMetaData = applMetaData.getBeanByEjbName(ejbLink);
                        if (beanMetaData == null) {
                            throw new WSException("Cannot obtain BeanMetaData for: " + ejbLink);
                        }
                        String configName = applMetaData.getConfigName();
                        if (configName != null) {
                            epMetaData.setConfigName(configName);
                        }
                        if ((configFile = applMetaData.getConfigFile()) != null) {
                            epMetaData.setConfigFile(configFile);
                        }
                        if ((bpcMetaData = beanMetaData.getPortComponent()) != null) {
                            if (bpcMetaData.getAuthMethod() != null) {
                                String authMethod = bpcMetaData.getAuthMethod();
                                epMetaData.setAuthMethod(authMethod);
                            }
                            if (bpcMetaData.getTransportGuarantee() != null) {
                                String transportGuarantee = bpcMetaData.getTransportGuarantee();
                                epMetaData.setTransportGuarantee(transportGuarantee);
                            }
                        }
                        this.initServicePathEJB(di, epMetaData, ejbLink);
                    } else if (di.metaData instanceof WebMetaData) {
                        String configFile;
                        WebMetaData webMetaData = (WebMetaData)di.metaData;
                        String configName = webMetaData.getConfigName();
                        if (configName != null) {
                            epMetaData.setConfigName(configName);
                        }
                        if ((configFile = webMetaData.getConfigFile()) != null) {
                            epMetaData.setConfigFile(configFile);
                        }
                        this.initServicePathJSE(di, epMetaData, servletLink);
                        this.initTransportGuaranteeJSE(di, epMetaData, servletLink);
                    }
                    epMetaData.getEndpointConfig();
                    this.replaceAddressLocation(epMetaData);
                    String seiName = pcMetaData.getServiceEndpointInterface();
                    epMetaData.setServiceEndpointInterfaceName(seiName);
                    ServiceEndpointInterfaceMapping seiMapping = javaWsdlMapping.getServiceEndpointInterfaceMapping(seiName);
                    if (seiMapping == null) {
                        this.log.warn((Object)("Cannot obtain SEI mapping for: " + seiName));
                    }
                    this.processEpMetaDataExtensions(epMetaData, wsdlDefinitions);
                    this.setupOperationsFromWSDL(epMetaData, wsdlEndpoint, seiMapping);
                    HandlerMetaData[] arr$3 = pcMetaData.getHandlers();
                    int len$3 = arr$3.length;
                    for (int i$3 = 0; i$3 < len$3; ++i$3) {
                        HandlerMetaData handlerMetaData = arr$3[i$3];
                        List portNames = Arrays.asList((Object[])handlerMetaData.getPortNames());
                        if (portNames.size() != 0 && !portNames.contains(epName.getLocalPart())) continue;
                        epMetaData.addHandler(handlerMetaData);
                    }
                }
            }
            this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }

    private WSDLEndpoint getWsdlEndpoint(WSDLDefinitions wsdlDefinitions, QName epName) {
        WSDLEndpoint wsdlEndpoint = null;
        WSDLService[] arr$ = wsdlDefinitions.getServices();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            WSDLService wsdlService = arr$[i$];
            WSDLEndpoint auxEndpoint = wsdlService.getEndpoint(epName);
            if (auxEndpoint == null) continue;
            wsdlEndpoint = auxEndpoint;
            break;
        }
        return wsdlEndpoint;
    }

    private void initServicePathEJB(DeploymentInfo di, ServerEndpointMetaData epMetaData, String ejbLink) {
        ApplicationMetaData applMetaData = (ApplicationMetaData)di.metaData;
        BeanMetaData beanMetaData = applMetaData.getBeanByEjbName(ejbLink);
        if (beanMetaData == null) {
            throw new WSException("Cannot obtain meta data for ejb link: " + ejbLink);
        }
        String contextRoot = applMetaData.getWebServiceContextRoot();
        if (contextRoot == null) {
            String shortName = di.shortName;
            contextRoot = shortName.substring(0, shortName.indexOf(46));
            contextRoot = "/" + contextRoot;
        }
        epMetaData.setContextRoot(contextRoot);
        EjbPortComponentMetaData ejbpcMetaData = beanMetaData.getPortComponent();
        String urlPattern = ejbpcMetaData != null && ejbpcMetaData.getPortComponentURI() != null ? ejbpcMetaData.getPortComponentURI() : "/" + ejbLink;
        epMetaData.setURLPattern(urlPattern);
    }

    private void initServicePathJSE(DeploymentInfo di, ServerEndpointMetaData epMetaData, String servletLink) {
        WebMetaData webMetaData = (WebMetaData)di.metaData;
        HashMap servletMappings = webMetaData.getServletMappings();
        String contextRoot = webMetaData.getContextRoot();
        if (contextRoot == null) {
            String shortName = di.shortName;
            contextRoot = shortName.substring(0, shortName.indexOf(46));
            contextRoot = "/" + contextRoot;
        }
        epMetaData.setContextRoot(contextRoot);
        String urlPattern = (String)servletMappings.get(servletLink);
        if (urlPattern == null) {
            throw new WSException("Cannot obtain servlet mapping for servlet link: " + servletLink);
        }
        if (!urlPattern.startsWith("/")) {
            urlPattern = "/" + urlPattern;
        }
        epMetaData.setURLPattern(urlPattern);
    }

    private WSSecurityConfiguration getWsSecurityConfiguration(DeploymentInfo di) throws IOException {
        WSSecurityConfiguration config = null;
        String resource = WSSecurityConfigurationFactory.SERVER_RESOURCE_NAME;
        resource = di.metaData instanceof WebMetaData ? "WEB-INF/" + resource : "META-INF/" + resource;
        URL location = this.resourceLoader.getResource(resource);
        if (location != null) {
            config = WSSecurityConfigurationFactory.newInstance().parse(location);
            if (config.getKeyStoreFile() != null && (location = this.resourceLoader.getResource(config.getKeyStoreFile())) != null) {
                config.setKeyStoreURL(location);
            }
            if (config.getTrustStoreFile() != null && (location = this.resourceLoader.getResource(config.getTrustStoreFile())) != null) {
                config.setTrustStoreURL(location);
            }
        }
        return config;
    }

    protected void initTransportGuaranteeJSE(DeploymentInfo di, EndpointMetaData epMetaData, String servletLink) throws IOException {
        File warFile = new File(di.localUrl.getFile());
        if (!warFile.isDirectory()) {
            throw new WSException("Expected a war directory: " + di.localUrl);
        }
        File webXML = new File(di.localUrl.getFile() + "/WEB-INF/web.xml");
        if (!webXML.isFile()) {
            throw new WSException("Cannot find web.xml: " + webXML);
        }
        Element rootElement = DOMUtils.parse((InputStream)new FileInputStream(webXML));
        Element elServletMapping = null;
        Iterator itServlet = DOMUtils.getChildElements((Node)rootElement, (String)"servlet-mapping");
        while (itServlet.hasNext() && elServletMapping == null) {
            Element elAux = (Element)itServlet.next();
            String servletName = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement((Node)elAux, (String)"servlet-name"));
            if (!servletLink.equals(servletName)) continue;
            elServletMapping = elAux;
        }
        if (elServletMapping != null) {
            String urlPattern = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement(elServletMapping, (String)"url-pattern"));
            if (urlPattern == null) {
                throw new WSException("Cannot find <url-pattern> for servlet-name: " + servletLink);
            }
            Iterator itSecConstraint = DOMUtils.getChildElements((Node)rootElement, (String)"security-constraint");
            while (itSecConstraint.hasNext()) {
                Element elSecurityConstraint = (Element)itSecConstraint.next();
                Iterator itWebResourceCollection = DOMUtils.getChildElements((Node)elSecurityConstraint, (String)"web-resource-collection");
                while (itWebResourceCollection.hasNext()) {
                    Element elUserDataConstraint;
                    Element elWebResourceCollection = (Element)itWebResourceCollection.next();
                    String wrcurlPattern = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement((Node)elWebResourceCollection, (String)"url-pattern"));
                    if (!urlPattern.equals(wrcurlPattern) || (elUserDataConstraint = DOMUtils.getFirstChildElement((Node)elSecurityConstraint, (String)"user-data-constraint")) == null) continue;
                    String transportGuarantee = DOMUtils.getTextContent((Node)DOMUtils.getFirstChildElement((Node)elUserDataConstraint, (String)"transport-guarantee"));
                    epMetaData.setTransportGuarantee(transportGuarantee);
                }
            }
        }
    }
}

