/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.util.ArrayList;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.ws.addressing.AddressingConstants;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.WsdlMessageMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.WsdlReturnValueMapping;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.addressing.AddressingConstantsImpl;
import org.jboss.ws.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.eventing.metadata.EventingEpMetaExt;
import org.jboss.ws.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.jaxrpc.ParameterStyle;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.jaxrpc.TypeMappingRegistryImpl;
import org.jboss.ws.jaxrpc.UnqualifiedFaultException;
import org.jboss.ws.jaxrpc.Use;
import org.jboss.ws.metadata.AbstractMetaDataBuilder;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.TypeMappingMetaData;
import org.jboss.ws.metadata.TypesMetaData;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationPart;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.utils.JavaUtils;

public abstract class JSR109MetaDataBuilder
extends AbstractMetaDataBuilder {
    final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.JSR109MetaDataBuilder"));
    private AddressingConstants ADDR = new AddressingConstantsImpl();

    protected void setupTypesMetaData(ServiceMetaData serviceMetaData) {
        WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
        JavaWsdlMapping javaWsdlMapping = serviceMetaData.getJavaWsdlMapping();
        TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
        if (wsdlDefinitions != null) {
            WSDLTypes wsdlTypes = wsdlDefinitions.getWsdlTypes();
            typesMetaData.setSchemaModel(wsdlTypes.getSchemaModel());
        }
        if (javaWsdlMapping != null) {
            int i$;
            JavaXmlTypeMapping[] arr$ = javaWsdlMapping.getJavaXmlTypeMappings();
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                String nsURI;
                JavaXmlTypeMapping xmlTypeMapping = arr$[i$];
                String javaTypeName = xmlTypeMapping.getJavaType();
                String qnameScope = xmlTypeMapping.getQnameScope();
                QName xmlType = xmlTypeMapping.getRootTypeQName();
                QName anonymousXMLType = xmlTypeMapping.getAnonymousTypeQName();
                if (xmlType == null && anonymousXMLType != null) {
                    xmlType = anonymousXMLType;
                }
                if ("http://www.w3.org/2001/XMLSchema".equals(nsURI = xmlType.getNamespaceURI()) || "http://schemas.xmlsoap.org/soap/encoding/".equals(nsURI)) continue;
                TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
                tmMetaData.setQNameScope(qnameScope);
                typesMetaData.addTypeMapping(tmMetaData);
            }
            arr$ = javaWsdlMapping.getExceptionMappings();
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                JavaXmlTypeMapping exceptionMapping = arr$[i$];
                QName xmlType = exceptionMapping.getWsdlMessage();
                String javaTypeName = exceptionMapping.getExceptionType();
                TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
                typesMetaData.addTypeMapping(tmMetaData);
            }
        }
    }

    protected void setupOperationsFromWSDL(EndpointMetaData epMetaData, WSDLEndpoint wsdlEndpoint, ServiceEndpointInterfaceMapping seiMapping) {
        WSDLDefinitions wsdlDefinitions = wsdlEndpoint.getInterface().getWsdlDefinitions();
        WSDLInterface wsdlInterface = wsdlEndpoint.getInterface();
        WSDLInterfaceOperation[] arr$ = wsdlInterface.getOperations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            WSDLBinding wsdlBinding;
            WSDLBindingOperation wsdlBindingOperation;
            WSDLInterfaceOperation wsdlOperation = arr$[i$];
            String opName = wsdlOperation.getName().toString();
            QName opQName = wsdlOperation.getQName();
            String javaName = opName.substring(0, 1).toLowerCase() + opName.substring(1);
            ServiceEndpointMethodMapping seiMethodMapping = null;
            if (seiMapping != null) {
                epMetaData.setServiceEndpointInterfaceName(seiMapping.getServiceEndpointInterface());
                seiMethodMapping = seiMapping.getServiceEndpointMethodMappingByWsdlOperation(opName);
                if (seiMethodMapping == null) {
                    throw new WSException("Cannot obtain method maping for: " + opName);
                }
                javaName = seiMethodMapping.getJavaMethodName();
            }
            OperationMetaData opMetaData = new OperationMetaData(epMetaData, opQName, javaName);
            epMetaData.addOperation(opMetaData);
            String style = wsdlOperation.getStyle();
            epMetaData.setStyle(Style.valueOf(style));
            if ("http://www.w3.org/2004/08/wsdl/in-only".equals(wsdlOperation.getPattern())) {
                opMetaData.setOneWayOperation(true);
            }
            if ((wsdlBindingOperation = (wsdlBinding = wsdlDefinitions.getBindingByInterfaceName(wsdlInterface.getQName())).getOperationByRef(opQName)) != null) {
                opMetaData.setSOAPAction(wsdlBindingOperation.getSOAPAction());
            }
            String encStyle = epMetaData.getEncodingStyle().toURI();
            TypeMappingRegistryImpl tmRegistry = new TypeMappingRegistryImpl();
            TypeMappingImpl typeMapping = (TypeMappingImpl)tmRegistry.getTypeMapping(encStyle);
            if (opMetaData.getStyle() == Style.RPC) {
                this.buildParameterMetaDataRpc(opMetaData, wsdlOperation, seiMethodMapping, typeMapping);
            } else {
                this.buildParameterMetaDataDoc(opMetaData, wsdlOperation, seiMethodMapping, typeMapping);
            }
            this.buildFaultMetaData(opMetaData, wsdlOperation, seiMapping);
            this.processOpMetaExtensions(opMetaData, wsdlOperation);
        }
    }

    private void buildParameterMetaDataRpc(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping) {
        int i$;
        this.log.trace((Object)("buildParameterMetaDataRpc: " + opMetaData.getXmlName()));
        TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        WSDLInterfaceOperationPart[] arr$ = wsdlOperation.getInputs();
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            String nsURI;
            String packageName;
            WSDLInterfaceOperationInput opInput = arr$[i$];
            QName xmlName = opInput.getElement();
            QName xmlType = opInput.getXMLType();
            String partName = opInput.getProperty("http://www.jboss.org/jbossws/partname").getValue();
            String javaTypeName = typeMapping.getJavaTypeName(xmlType);
            if (seiMethodMapping != null) {
                MethodParamPartsMapping paramMapping = seiMethodMapping.getMethodParamPartsMappingByPartName(partName);
                if (paramMapping == null) {
                    throw new WSException("Cannot obtain method parameter mapping for message part '" + partName + "' in wsdl operation: " + seiMethodMapping.getWsdlOperation());
                }
                javaTypeName = paramMapping.getParamType();
            }
            JavaWsdlMapping javaWsdlMapping = opMetaData.getEndpointMetaData().getServiceMetaData().getJavaWsdlMapping();
            if (javaTypeName == null && javaWsdlMapping != null && (packageName = javaWsdlMapping.getPackageNameForNamespaceURI(xmlType.getNamespaceURI())) != null) {
                javaTypeName = packageName + "." + xmlType.getLocalPart();
                this.log.warn((Object)("Guess java type from package mapping: [xmlType=" + xmlType + ",javaType=" + javaTypeName + "]"));
            }
            if (javaTypeName == null) {
                throw new WSException("Cannot obtain java type mapping for: " + xmlType);
            }
            ParameterMetaData inMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
            opMetaData.addParameter(inMetaData);
            if (typesMetaData.getTypeMappingByXMLType(xmlType) == null && !"http://www.w3.org/2001/XMLSchema".equals(nsURI = xmlType.getNamespaceURI()) && !"http://schemas.xmlsoap.org/soap/encoding/".equals(nsURI)) {
                TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
                typesMetaData.addTypeMapping(tmMetaData);
            }
            this.setupAttachmentParameter(opInput, inMetaData);
            boolean inHeader = opInput.getProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data") != null;
            inMetaData.setInHeader(inHeader);
            this.setupSOAPArrayParameter(inMetaData, javaTypeName);
        }
        arr$ = wsdlOperation.getOutputs();
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            String packageName;
            boolean hasReturnMapping;
            WSDLInterfaceOperationPart opOutput = arr$[i$];
            String partName = opOutput.getProperty("http://www.jboss.org/jbossws/partname").getValue();
            QName xmlName = opOutput.getElement();
            ParameterMetaData outMetaData = opMetaData.getParameter(xmlName);
            if (outMetaData != null && wsdlOperation.getInputByPartName(partName) != null) {
                outMetaData.setMode(ParameterMode.INOUT);
                continue;
            }
            QName xmlType = opOutput.getXMLType();
            String javaTypeName = typeMapping.getJavaTypeName(xmlType);
            boolean inHeader = opOutput.getProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data") != null;
            boolean bl = hasReturnMapping = !inHeader;
            if (seiMethodMapping != null) {
                WsdlReturnValueMapping returnMapping = seiMethodMapping.getWsdlReturnValueMapping();
                if (returnMapping != null) {
                    javaTypeName = returnMapping.getMethodReturnValue();
                    hasReturnMapping = true;
                } else {
                    MethodParamPartsMapping paramMapping = seiMethodMapping.getMethodParamPartsMappingByPartName(partName);
                    if (paramMapping != null) {
                        javaTypeName = paramMapping.getParamType();
                        hasReturnMapping = false;
                    }
                }
            }
            JavaWsdlMapping javaWsdlMapping = opMetaData.getEndpointMetaData().getServiceMetaData().getJavaWsdlMapping();
            if (javaTypeName == null && javaWsdlMapping != null && (packageName = javaWsdlMapping.getPackageNameForNamespaceURI(xmlType.getNamespaceURI())) != null) {
                javaTypeName = packageName + "." + xmlType.getLocalPart();
                this.log.warn((Object)("Guess java type from package mapping: [xmlType=" + xmlType + ",javaType=" + javaTypeName + "]"));
            }
            if (javaTypeName == null) {
                throw new WSException("Cannot obtain java type mapping for: " + xmlType);
            }
            if (hasReturnMapping) {
                String nsURI;
                outMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
                opMetaData.setReturnParameter(outMetaData);
                if (typesMetaData.getTypeMappingByXMLType(xmlType) == null && !"http://www.w3.org/2001/XMLSchema".equals(nsURI = xmlType.getNamespaceURI()) && !"http://schemas.xmlsoap.org/soap/encoding/".equals(nsURI)) {
                    TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
                    typesMetaData.addTypeMapping(tmMetaData);
                }
                this.setupAttachmentParameter(opOutput, outMetaData);
            } else {
                outMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
                outMetaData.setMode(ParameterMode.OUT);
                opMetaData.addParameter(outMetaData);
                this.setupAttachmentParameter(opOutput, outMetaData);
                outMetaData.setInHeader(inHeader);
            }
            this.setupSOAPArrayParameter(outMetaData, javaTypeName);
        }
    }

    private void setupAttachmentParameter(WSDLInterfaceOperationPart wsdlOperationPart, ParameterMetaData paramMetaData) {
        String simpleTypeName;
        XSComplexTypeDefinition xsComplexType;
        WSDLInterfaceOperation wsdlOperation;
        WSDLTypes wsdlTypes;
        JBossXSModel schemaModel;
        XSTypeDefinition xsType;
        QName xmlType = paramMetaData.getXmlType();
        QName xmlName = paramMetaData.getXmlName();
        WSDLProperty mimeTypeProp = wsdlOperationPart.getProperty("http://www.jboss.org/jbossws/attachment/mimetype");
        if (mimeTypeProp != null) {
            String mimeTypes = mimeTypeProp.getValue();
            paramMetaData.setMimeTypes(mimeTypes);
            paramMetaData.setSwA(true);
        }
        if ((xsType = (schemaModel = (wsdlTypes = (wsdlOperation = wsdlOperationPart.getWsdlOperation()).getWsdlInterface().getWsdlDefinitions().getWsdlTypes()).getSchemaModel()).getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI())) instanceof XSComplexTypeDefinition && (xsComplexType = (XSComplexTypeDefinition)xsType).getSimpleType() != null && ("base64Binary".equals(simpleTypeName = xsComplexType.getSimpleType().getName()) || "hexBinary".equals(simpleTypeName))) {
            paramMetaData.setXOP(true);
        }
    }

    private void setupSOAPArrayParameter(ParameterMetaData paramMetaData, String javaTypeName) {
        Use use = paramMetaData.getOperationMetaData().getUse();
        String xmlTypeLocalPart = paramMetaData.getXmlType().getLocalPart();
        if (use == Use.ENCODED && xmlTypeLocalPart.indexOf("ArrayOf") >= 0) {
            paramMetaData.setSOAPArrayParam(true);
            try {
                Class javaType = JavaUtils.loadJavaType(javaTypeName);
                Class<?> compJavaType = javaType.getComponentType();
                if (xmlTypeLocalPart.indexOf("ArrayOfArrayOf") >= 0) {
                    compJavaType = compJavaType.getComponentType();
                }
                QName compXMLType = new LiteralTypeMapping().getXMLType(compJavaType);
                paramMetaData.setSOAPArrayCompType(compXMLType);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }

    private void buildParameterMetaDataDoc(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointMethodMapping seiMethodMapping, TypeMappingImpl typeMapping) {
        int i$;
        this.log.trace((Object)("buildParameterMetaDataDoc: " + opMetaData.getXmlName()));
        EndpointMetaData epMetaData = opMetaData.getEndpointMetaData();
        ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
        TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
        WSDLDefinitions wsdlDefinitions = wsdlOperation.getWsdlInterface().getWsdlDefinitions();
        WSDLTypes wsdlTypes = wsdlDefinitions.getWsdlTypes();
        WSDLInterfaceOperationPart[] arr$ = wsdlOperation.getInputs();
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            MethodParamPartsMapping[] partsMappings;
            WSDLInterfaceOperationInput opInput = arr$[i$];
            QName xmlName = opInput.getElement();
            QName xmlType = opInput.getXMLType();
            String javaTypeName = typeMapping.getJavaTypeName(xmlType);
            TypeMappingMetaData typeMetaData = typesMetaData.getTypeMappingByXMLType(xmlType);
            if (typeMetaData != null) {
                javaTypeName = typeMetaData.getJavaTypeName();
            }
            if (javaTypeName == null) {
                throw new WSException("Cannot obtain java type mapping for: " + xmlType);
            }
            boolean isWrapParameters = seiMethodMapping != null ? seiMethodMapping.isWrappedElement() : false;
            this.log.trace((Object)("isWrapParameters based on wrapped-element: " + isWrapParameters));
            if (!isWrapParameters && seiMethodMapping != null && (partsMappings = seiMethodMapping.getMethodParamPartsMappings()).length > 0) {
                boolean matchingPartFound = false;
                MethodParamPartsMapping[] arr$2 = partsMappings;
                int len$2 = arr$2.length;
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    MethodParamPartsMapping partsMapping = arr$2[i$2];
                    String paramTypeName = partsMapping.getParamType();
                    if (paramTypeName.equals(javaTypeName)) {
                        matchingPartFound = true;
                        break;
                    }
                    try {
                        Class paramType = JavaUtils.loadJavaType(paramTypeName);
                        Class javaType = JavaUtils.loadJavaType(javaTypeName);
                        if (!JavaUtils.isAssignableFrom(javaType, paramType)) continue;
                        javaTypeName = paramTypeName;
                        matchingPartFound = true;
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                isWrapParameters = !matchingPartFound;
                this.log.trace((Object)("isWrapParameters based on matching parts: " + isWrapParameters));
            }
            ParameterMetaData inMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
            epMetaData.setParameterStyle(isWrapParameters ? ParameterStyle.WRAPPED : ParameterStyle.BARE);
            inMetaData.setInHeader(opInput.getProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data") != null);
            opMetaData.addParameter(inMetaData);
            if (!opMetaData.isDocumentWrapped()) continue;
            if (seiMethodMapping == null) {
                throw new IllegalArgumentException("Cannot wrap parameters without SEI method mapping");
            }
            ServiceEndpointInterfaceMapping seiMapping = seiMethodMapping.getServiceEndpointInterfaceMapping();
            JavaXmlTypeMapping javaXmlTypeMapping = seiMapping.getJavaWsdlMapping().getTypeMappingForQName(xmlType);
            if (javaXmlTypeMapping == null) {
                throw new WSException("Cannot obtain java/xml type mapping for: " + xmlType);
            }
            ArrayList<String> variableNames = new ArrayList<String>();
            VariableMapping[] arr$3 = javaXmlTypeMapping.getVariableMappings();
            int len$3 = arr$3.length;
            for (int i$3 = 0; i$3 < len$3; ++i$3) {
                VariableMapping varMapping = arr$3[i$3];
                variableNames.add(varMapping.getJavaVariableName());
            }
            inMetaData.setWrappedVariables(variableNames);
        }
        arr$ = wsdlOperation.getOutputs();
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            boolean hasReturnMapping;
            WSDLInterfaceOperationPart opOutput = arr$[i$];
            String partName = opOutput.getProperty("http://www.jboss.org/jbossws/partname").getValue();
            QName xmlName = opOutput.getElement();
            ParameterMetaData paramMetaData = opMetaData.getParameter(xmlName);
            if (paramMetaData != null && wsdlOperation.getInputByPartName(partName) != null) {
                paramMetaData.setMode(ParameterMode.INOUT);
                continue;
            }
            QName xmlType = opOutput.getXMLType();
            String javaTypeName = typeMapping.getJavaTypeName(xmlType);
            boolean inHeader = opOutput.getProperty("http://www.w3.org/2004/08/wsdl/feature/AD/data") != null;
            boolean bl = hasReturnMapping = !inHeader;
            if (typesMetaData.getTypeMappingByXMLType(xmlType) != null) {
                javaTypeName = typesMetaData.getTypeMappingByXMLType(xmlType).getJavaTypeName();
            }
            if (javaTypeName == null) {
                throw new WSException("Cannot obtain java/xml type mapping for: " + xmlType);
            }
            if (hasReturnMapping) {
                WsdlReturnValueMapping returnValueMapping;
                if (seiMethodMapping != null && !((returnValueMapping = seiMethodMapping.getWsdlReturnValueMapping()) != null && returnValueMapping.getMethodReturnValue().equals(javaTypeName)) && xmlType.equals(Constants.TYPE_LITERAL_ANYTYPE)) {
                    javaTypeName = returnValueMapping.getMethodReturnValue();
                }
                ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
                opMetaData.setReturnParameter(retMetaData);
                this.setupAttachmentParameter(opOutput, retMetaData);
                if (opMetaData.getParameterStyle() != ParameterStyle.WRAPPED) continue;
                if (seiMethodMapping == null) {
                    throw new IllegalArgumentException("Cannot wrap parameters without SEI method mapping");
                }
                ServiceEndpointInterfaceMapping seiMapping = seiMethodMapping.getServiceEndpointInterfaceMapping();
                JavaWsdlMapping javaWsdlMapping = seiMapping.getJavaWsdlMapping();
                JavaXmlTypeMapping javaXmlTypeMapping = javaWsdlMapping.getTypeMappingForQName(xmlType);
                if (typeMapping == null) {
                    throw new WSException("Cannot obtain java/xml type mapping for: " + xmlType);
                }
                ArrayList<String> variableNames = new ArrayList<String>();
                VariableMapping[] arr$4 = javaXmlTypeMapping.getVariableMappings();
                int len$4 = arr$4.length;
                for (int i$4 = 0; i$4 < len$4; ++i$4) {
                    VariableMapping varMapping = arr$4[i$4];
                    variableNames.add(varMapping.getJavaVariableName());
                }
                retMetaData.setWrappedVariables(variableNames);
                continue;
            }
            ParameterMetaData outMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
            opMetaData.addParameter(outMetaData);
            outMetaData.setMode(ParameterMode.OUT);
            this.setupAttachmentParameter(opOutput, outMetaData);
            outMetaData.setInHeader(inHeader);
        }
        if (seiMethodMapping != null && wsdlDefinitions.getWsdlOneOneDefinition() != null) {
            MethodParamPartsMapping[] mppMappings = seiMethodMapping.getMethodParamPartsMappings();
            for (int i = 0; i < mppMappings.length; ++i) {
                MethodParamPartsMapping mppMapping = mppMappings[i];
                String javaTypeName = mppMapping.getParamType();
                WsdlMessageMapping wmMapping = mppMapping.getWsdlMessageMapping();
                if (!wmMapping.isSoapHeader()) continue;
                QName wsdlMessageName = wmMapping.getWsdlMessage();
                String partName = wmMapping.getWsdlMessagePartName();
                Message wsdl11Message = wsdlDefinitions.getWsdlOneOneDefinition().getMessage(wsdlMessageName);
                Part wsdl11Part = wsdl11Message.getPart(partName);
                QName xmlName = wsdl11Part.getElementName();
                if (opMetaData.getParameter(xmlName) != null) continue;
                String mode = wmMapping.getParameterMode();
                QName xmlType = wsdlTypes.getXMLType(xmlName);
                ParameterMetaData headerMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
                opMetaData.addParameter(headerMetaData);
                headerMetaData.setInHeader(true);
                headerMetaData.setMode(mode);
            }
        }
    }

    private void buildFaultMetaData(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation, ServiceEndpointInterfaceMapping seiMapping) {
        TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        WSDLInterface wsdlInterface = wsdlOperation.getWsdlInterface();
        WSDLInterfaceOperationOutfault[] arr$ = wsdlOperation.getOutfaults();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            WSDLInterfaceOperationOutfault outFault = arr$[i$];
            QName ref = outFault.getRef();
            WSDLInterfaceFault wsdlFault = wsdlInterface.getFault(new NCName(ref.getLocalPart()));
            QName xmlName = wsdlFault.getXmlName();
            QName xmlType = wsdlFault.getXmlType();
            String javaTypeName = null;
            if (typesMetaData.getTypeMappingByXMLType(xmlType) != null) {
                javaTypeName = typesMetaData.getTypeMappingByXMLType(xmlType).getJavaTypeName();
            }
            if (javaTypeName == null) {
                this.log.warn((Object)("Cannot obtain java type mapping for: " + xmlType));
                javaTypeName = new UnqualifiedFaultException(xmlType).getClass().getName();
            }
            FaultMetaData faultMetaData = new FaultMetaData(opMetaData, xmlName, xmlType, javaTypeName);
            opMetaData.addFault(faultMetaData);
        }
    }

    protected void initEndpointEncodingStyle(EndpointMetaData epMetaData) {
        WSDLDefinitions wsdlDefinitions = epMetaData.getServiceMetaData().getWsdlDefinitions();
        WSDLService[] arr$ = wsdlDefinitions.getServices();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            WSDLService wsdlService = arr$[i$];
            WSDLEndpoint[] arr$2 = wsdlService.getEndpoints();
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                WSDLEndpoint wsdlEndpoint = arr$2[i$2];
                if (!epMetaData.getName().equals(wsdlEndpoint.getQName())) continue;
                QName bindQName = wsdlEndpoint.getBinding();
                NCName ncName = new NCName(bindQName.getLocalPart());
                WSDLBinding wsdlBinding = wsdlDefinitions.getBinding(ncName);
                if (wsdlBinding == null) {
                    throw new WSException("Cannot obtain binding: " + ncName);
                }
                WSDLBindingOperation[] arr$3 = wsdlBinding.getOperations();
                int len$3 = arr$3.length;
                for (int i$3 = 0; i$3 < len$3; ++i$3) {
                    WSDLBindingOperation wsdlBindingOperation = arr$3[i$3];
                    String encStyle = wsdlBindingOperation.getEncodingStyle();
                    epMetaData.setEncodingStyle(Use.valueOf(encStyle));
                }
            }
        }
    }

    protected void processEpMetaDataExtensions(EndpointMetaData epMetaData, WSDLDefinitions wsdlDefinitions) {
        WSDLInterface[] arr$ = wsdlDefinitions.getInterfaces();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            WSDLInterface wsdlInterface = arr$[i$];
            WSDLProperty eventSourceProp = wsdlInterface.getProperty("http://www.jboss.org/jbossws/wse/isEventSource");
            if (eventSourceProp == null) continue;
            String eventSourceNS = wsdlInterface.getQName().getNamespaceURI() + "/" + wsdlInterface.getQName().getLocalPart();
            Object notificationSchema = null;
            EventingEpMetaExt ext = new EventingEpMetaExt("http://schemas.xmlsoap.org/ws/2004/08/eventing");
            ext.setEventSourceNS(eventSourceNS);
            ext.setNotificationSchema(notificationSchema);
            epMetaData.addExtension(ext);
        }
    }

    protected void processOpMetaExtensions(OperationMetaData opMetaData, WSDLInterfaceOperation wsdlOperation) {
        String tns = wsdlOperation.getQName().getNamespaceURI();
        String portTypeName = wsdlOperation.getQName().getLocalPart();
        AddressingOpMetaExt addrExt = new AddressingOpMetaExt(this.ADDR.getNamespaceURI());
        WSDLProperty wsaInAction = wsdlOperation.getProperty("http://www.jboss.org/jbossws/wsa/actionIn");
        if (wsaInAction != null) {
            addrExt.setInboundAction(wsaInAction.getValue());
        } else {
            WSDLProperty messageName = wsdlOperation.getProperty("http://www.jboss.org/jbossws/messagename/in");
            addrExt.setInboundAction(tns + "/" + portTypeName + "/" + messageName);
        }
        WSDLProperty wsaOutAction = wsdlOperation.getProperty("http://www.jboss.org/jbossws/wsa/actionOut");
        if (wsaOutAction != null) {
            addrExt.setOutboundAction(wsaOutAction.getValue());
        } else {
            WSDLProperty messageName = wsdlOperation.getProperty("http://www.jboss.org/jbossws/messagename/out");
            addrExt.setOutboundAction(tns + "/" + portTypeName + "/" + messageName);
        }
        opMetaData.addExtension(addrExt);
    }

    private String buildWsaActionValue(WSDLInterfaceOperation wsdlOperation) {
        WSDLProperty wsaAction = wsdlOperation.getProperty(Constants.WSDL_ATTRIBUTE_WSA_ACTION.toString());
        String actionValue = null;
        if (null == wsaAction) {
            String tns = wsdlOperation.getQName().getNamespaceURI();
            String portTypeName = wsdlOperation.getQName().getLocalPart();
            WSDLProperty messageName = wsdlOperation.getProperty("http://www.jboss.org/jbossws/messagename/in");
            actionValue = new String(tns + "/" + portTypeName + "/" + messageName.getValue());
        } else {
            actionValue = wsaAction.getValue();
        }
        return actionValue;
    }
}

