/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.util.Iterator;
import java.util.Map;
import javax.jws.WebService;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.lang.AnnotationHelper;
import org.jboss.logging.Logger;
import org.jboss.metadata.WebMetaData;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.AnnotationsMetaDataBuilder;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;

public class AnnotationsMetaDataBuilderJSE
extends AnnotationsMetaDataBuilder {
    private final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.AnnotationsMetaDataBuilderJSE"));

    public UnifiedMetaData buildMetaData(DeploymentInfo di) {
        this.log.debug((Object)("START buildMetaData: [canonicalName=" + di.getCanonicalName() + "]"));
        try {
            UnifiedMetaData wsMetaData = new UnifiedMetaData();
            wsMetaData.setResourceLoader(this.resourceLoader);
            wsMetaData.setClassLoader(this.classLoader);
            if (di.annotationsCl == null) {
                throw new WSException("Annotations class loader not initialized");
            }
            WebMetaData webMetaData = (WebMetaData)di.metaData;
            Map servletClassMap = webMetaData.getServletClassMap();
            Iterator i$ = servletClassMap.keySet().iterator();
            while (i$.hasNext()) {
                String servletName = (String)i$.next();
                String servletClassName = (String)servletClassMap.get(servletName);
                Class<?> beanClass = di.annotationsCl.loadClass(servletClassName);
                Class<?> clazz = Class.forName("javax.jws.WebService");
                Class<?> clazz2 = beanClass;
                boolean bl = false;
                bl = AnnotationHelper.isAnnotationPresent(clazz2, clazz);
                if (!bl) continue;
                Class<?> annotatedClass = beanClass;
                clazz = Class.forName("javax.jws.WebService");
                clazz2 = beanClass;
                Object object = null;
                object = AnnotationHelper.getAnnotation(clazz2, clazz);
                WebService anWebService = (WebService)object;
                String seiName = annotatedClass.getName();
                if (anWebService.endpointInterface().length() > 0) {
                    seiName = anWebService.endpointInterface();
                    annotatedClass = di.annotationsCl.loadClass(seiName);
                    clazz = Class.forName("javax.jws.WebService");
                    clazz2 = annotatedClass;
                    object = null;
                    object = AnnotationHelper.getAnnotation(clazz2, clazz);
                    anWebService = (WebService)object;
                    if (anWebService == null) {
                        throw new WSException("Interface does not have a @WebService annotation: " + seiName);
                    }
                }
                ServerEndpointMetaData sepMetaData = this.setupEndpointFromAnnotations(wsMetaData, di, annotatedClass, servletName);
                sepMetaData.setEndpointImplementationName(beanClass.getName());
                sepMetaData.setServiceEndpointInterfaceName(seiName);
            }
            this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }
}

