/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;

public abstract class AbstractMetaDataBuilder {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.AbstractMetaDataBuilder"));
    protected ClassLoader classLoader;
    protected URLClassLoader resourceLoader;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setResourceLoader(URLClassLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected ObjectName getServiceEndpointID(DeploymentInfo di, ServerEndpointMetaData sepMetaData) {
        StringBuffer idstr = new StringBuffer("jboss.ws:");
        idstr.append("di=" + di.getCanonicalName());
        idstr.append(",service=" + sepMetaData.getServiceMetaData().getName().getLocalPart());
        idstr.append(",port=" + sepMetaData.getName().getLocalPart());
        if (di.metaData instanceof ApplicationMetaData) {
            String ejbName = sepMetaData.getLinkName();
            if (ejbName == null) {
                throw new WSException("Cannot obtain ejb-link from port component");
            }
            ApplicationMetaData applMetaData = (ApplicationMetaData)di.metaData;
            BeanMetaData beanMetaData = applMetaData.getBeanByEjbName(ejbName);
            if (beanMetaData == null) {
                throw new WSException("Cannot obtain ejb meta data for: " + ejbName);
            }
            if (beanMetaData instanceof MessageDrivenMetaData) {
                MessageDrivenMetaData mdMetaData = (MessageDrivenMetaData)beanMetaData;
                String jndiName = mdMetaData.getDestinationJndiName();
                idstr.append(",jms=" + jndiName);
            }
        }
        return ObjectNameFactory.create((String)idstr.toString());
    }

    public String getServiceEndpointAddress(String uriScheme, String servicePath) {
        if (servicePath == null || servicePath.length() == 0) {
            throw new WSException("Service path cannot be null");
        }
        if (servicePath.endsWith("/*")) {
            servicePath = servicePath.substring(0, servicePath.length() - 2);
        }
        if (uriScheme == null) {
            uriScheme = "http";
        }
        int port = 0;
        String host = null;
        try {
            ObjectName objectName = ObjectNameFactory.create((String)"jboss.ws:service=ServiceEndpointManager");
            MBeanServer server = MBeanServerLocator.locateJBoss();
            host = (String)server.getAttribute(objectName, "WebServiceHost");
            port = (Integer)server.getAttribute(objectName, "WebServicePort");
            if ("https".equals(uriScheme)) {
                port = (Integer)server.getAttribute(objectName, "WebServiceSecurePort");
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot obtain attribute from ServiceEndpointManager, cause: " + e.toString()));
        }
        String urlStr = uriScheme + "://" + host + ":" + port + servicePath;
        try {
            return new URL(urlStr).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new WSException("Malformed URL: " + urlStr);
        }
    }

    protected void replaceAddressLocation(ServerEndpointMetaData epMetaData) {
        WSDLDefinitions wsdlDefinitions = epMetaData.getServiceMetaData().getWsdlDefinitions();
        QName epName = epMetaData.getName();
        boolean endpointFound = false;
        WSDLService[] arr$ = wsdlDefinitions.getServices();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            WSDLService wsdlService = arr$[i$];
            WSDLEndpoint[] arr$2 = wsdlService.getEndpoints();
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                WSDLEndpoint wsdlEndpoint = arr$2[i$2];
                QName wsdlPortName = wsdlEndpoint.getQName();
                if (!wsdlPortName.equals(epName)) continue;
                endpointFound = true;
                String orgAddress = wsdlEndpoint.getAddress();
                String uriScheme = this.getUriScheme(orgAddress);
                String transportGuarantee = epMetaData.getTransportGuarantee();
                if ("CONFIDENTIAL".equals(transportGuarantee)) {
                    uriScheme = "https";
                }
                String servicePath = epMetaData.getContextRoot() + epMetaData.getURLPattern();
                String serviceEndpointURL = this.getServiceEndpointAddress(uriScheme, servicePath);
                boolean alwaysModify = false;
                try {
                    ObjectName objectName = ObjectNameFactory.create((String)"jboss.ws:service=ServiceEndpointManager");
                    MBeanServer server = MBeanServerLocator.locateJBoss();
                    alwaysModify = (Boolean)server.getAttribute(objectName, "AlwaysModifySOAPAddress");
                }
                catch (Exception ex) {
                    log.error((Object)("Cannot obtain attribute from ServiceEndpointManager, cause: " + ex));
                }
                if (alwaysModify || uriScheme == null || orgAddress.indexOf("REPLACE_WITH_ACTUAL_URL") >= 0) {
                    log.debug((Object)("Replace service endpoint address '" + orgAddress + "' with '" + serviceEndpointURL + "'"));
                    wsdlEndpoint.setAddress(serviceEndpointURL);
                    epMetaData.setEndpointAddress(serviceEndpointURL);
                    if (wsdlDefinitions.getWsdlOneOneDefinition() == null) continue;
                    this.replaceWSDL11SOAPAddress(wsdlDefinitions, epName, serviceEndpointURL);
                    continue;
                }
                log.debug((Object)("Don't replace service endpoint address '" + orgAddress + "'"));
                try {
                    epMetaData.setEndpointAddress(new URL(orgAddress).toExternalForm());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new WSException("Malformed URL: " + orgAddress);
                }
            }
        }
        if (!endpointFound) {
            throw new WSException("Cannot find service endpoint '" + epName + "' in wsdl document");
        }
    }

    private void replaceWSDL11SOAPAddress(WSDLDefinitions wsdlDefinitions, QName portQName, String serviceEndpointURL) {
        Definition wsdlOneOneDefinition = wsdlDefinitions.getWsdlOneOneDefinition();
        String tnsURI = wsdlOneOneDefinition.getTargetNamespace();
        Port wsdlOneOnePort = this.modifyPortAddress(tnsURI, portQName, serviceEndpointURL, wsdlOneOneDefinition.getServices());
        if (wsdlOneOnePort == null && !wsdlOneOneDefinition.getImports().isEmpty()) {
            Iterator imports = wsdlOneOneDefinition.getImports().values().iterator();
            while (imports.hasNext()) {
                List l = (List)imports.next();
                Iterator importsByNS = l.iterator();
                while (importsByNS.hasNext()) {
                    Import anImport = (Import)importsByNS.next();
                    wsdlOneOnePort = this.modifyPortAddress(anImport.getNamespaceURI(), portQName, serviceEndpointURL, anImport.getDefinition().getServices());
                }
            }
        }
        if (wsdlOneOnePort == null) {
            throw new IllegalArgumentException("Cannot find port with name '" + portQName + "' in wsdl document");
        }
    }

    private Port modifyPortAddress(String tnsURI, QName portQName, String serviceEndpointURL, Map services) {
        Port wsdlOneOnePort = null;
        Iterator itServices = services.values().iterator();
        while (itServices.hasNext()) {
            Service wsdlOneOneService = (Service)itServices.next();
            Map wsdlOneOnePorts = wsdlOneOneService.getPorts();
            Iterator itPorts = wsdlOneOnePorts.keySet().iterator();
            while (itPorts.hasNext()) {
                String portLocalName = (String)itPorts.next();
                if (!portQName.equals(new QName(tnsURI, portLocalName))) continue;
                wsdlOneOnePort = (Port)wsdlOneOnePorts.get(portLocalName);
                Iterator itElements = wsdlOneOnePort.getExtensibilityElements().iterator();
                while (itElements.hasNext()) {
                    Object obj = itElements.next();
                    if (!(obj instanceof SOAPAddress)) continue;
                    SOAPAddress address = (SOAPAddress)obj;
                    address.setLocationURI(serviceEndpointURL);
                }
            }
        }
        return wsdlOneOnePort;
    }

    private String getUriScheme(String addrStr) {
        try {
            URI addrURI = new URI(addrStr);
            String scheme = addrURI.getScheme();
            return scheme;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

