/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc.encoding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.SerializationContext;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.TypesMetaData;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.utils.JavaUtils;
import org.jboss.xb.binding.NamespaceRegistry;

public class SerializationContextImpl
implements SerializationContext {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.jaxrpc.encoding.SerializationContextImpl"));
    public static final String PROPERTY_PARAMETER_META_DATA = "org.jboss.ws.metadata.ParameterMetaData";
    private TypeMappingImpl typeMapping;
    private NamespaceRegistry namespaceRegistry;
    private JavaWsdlMapping jaxrpcMapping;
    private Map<Object, Object> properties = new HashMap<Object, Object>();

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public TypeMappingImpl getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMappingImpl typeMapping) {
        this.typeMapping = typeMapping;
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public void setNamespaceRegistry(NamespaceRegistry namespaceRegistry) {
        this.namespaceRegistry = namespaceRegistry;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        if (this.jaxrpcMapping == null) {
            log.debug((Object)"Generate jaxrpcMapping from typeMapping");
            this.jaxrpcMapping = new JavaWsdlMapping();
            Iterator<QName> i$ = this.typeMapping.getRegisteredXmlTypes().iterator();
            while (i$.hasNext()) {
                JavaXmlTypeMapping xmlTypeMapping;
                String packageType;
                Package packageObject;
                String packageName;
                QName xmlType = i$.next();
                String nsURI = xmlType.getNamespaceURI();
                if ("http://www.w3.org/2001/XMLSchema".equals(nsURI) || "http://www.jboss.org/jbossws/attachment/mimetype".equals(nsURI)) continue;
                Class javaType = this.typeMapping.getJavaType(xmlType);
                String javaTypeName = javaType.getName();
                Class componentType = javaType;
                while (componentType.isArray()) {
                    componentType = componentType.getComponentType();
                }
                if (JavaUtils.isPrimitive(componentType)) {
                    componentType = JavaUtils.getWrapperType(componentType);
                }
                if (!(packageName = (packageObject = componentType.getPackage()) != null ? packageObject.getName() : "").equals(packageType = this.jaxrpcMapping.getPackageNameForNamespaceURI(nsURI))) {
                    PackageMapping packageMapping = new PackageMapping(this.jaxrpcMapping);
                    packageMapping.setNamespaceURI(nsURI);
                    packageMapping.setPackageType(packageName);
                    this.jaxrpcMapping.addPackageMapping(packageMapping);
                    log.debug((Object)("Add package mapping: " + packageMapping));
                }
                if (javaType.isArray() || (xmlTypeMapping = this.jaxrpcMapping.getTypeMappingForQName(xmlType)) != null) continue;
                xmlTypeMapping = new JavaXmlTypeMapping(this.jaxrpcMapping);
                xmlTypeMapping.setQNameScope("complexType");
                xmlTypeMapping.setJavaType(javaTypeName);
                xmlTypeMapping.setRootTypeQName(xmlType);
                this.jaxrpcMapping.addJavaXmlTypeMappings(xmlTypeMapping);
                log.debug((Object)("Add type mapping: " + xmlTypeMapping));
            }
        }
        return this.jaxrpcMapping;
    }

    public void setJavaWsdlMapping(JavaWsdlMapping jaxrpcMapping) {
        this.jaxrpcMapping = jaxrpcMapping;
    }

    public XSModel getXsModel() {
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext == null) {
            throw new WSException("MessageContext not available");
        }
        OperationMetaData opMetaData = msgContext.getOperationMetaData();
        ServiceMetaData serviceMetaData = opMetaData.getEndpointMetaData().getServiceMetaData();
        TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
        return typesMetaData.getSchemaModel();
    }
}

