/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.encoding.TypeMapping;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.jaxrpc.encoding.Base64DeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.Base64SerializerFactory;
import org.jboss.ws.jaxrpc.encoding.CalendarDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.CalendarSerializerFactory;
import org.jboss.ws.jaxrpc.encoding.DateDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.DateSerializerFactory;
import org.jboss.ws.jaxrpc.encoding.HexDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.HexSerializerFactory;
import org.jboss.ws.jaxrpc.encoding.QNameDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.QNameSerializerFactory;
import org.jboss.ws.jaxrpc.encoding.SimpleDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.SimpleSerializerFactory;
import org.jboss.ws.utils.JavaUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeMappingImpl
implements TypeMapping {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.jaxrpc.TypeMappingImpl"));
    private Map<KeyPair, FactoryPair> tupleMap = new LinkedHashMap<KeyPair, FactoryPair>();

    public DeserializerFactory getDeserializer(Class javaType, QName xmlType) {
        FactoryPair fPair = this.getFactoryPair(xmlType, javaType);
        return fPair != null ? fPair.getDeserializerFactory() : null;
    }

    public SerializerFactory getSerializer(Class javaType, QName xmlType) {
        FactoryPair fPair = this.getFactoryPair(xmlType, javaType);
        return fPair != null ? fPair.getSerilaizerFactory() : null;
    }

    public abstract String[] getSupportedEncodings();

    public abstract void setSupportedEncodings(String[] var1);

    public boolean isRegistered(Class javaType, QName xmlType) {
        return this.getFactoryPair(xmlType, javaType) != null;
    }

    public void register(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory df) {
        log.debug((Object)new StringBuffer().append("register: TypeMappingImpl@").append(this.hashCode()).append(" [xmlType=").append(xmlType).append(",javaType=").append(javaType.getName()).append(",sf=").append(sf).append(",df=").append(df).append("]").toString());
        this.registerInternal(javaType, xmlType, sf, df);
    }

    void registerInternal(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory df) {
        if (javaType == null) {
            throw new IllegalArgumentException(new StringBuffer().append("javaType cannot be null for: ").append(xmlType).toString());
        }
        if (xmlType == null) {
            throw new IllegalArgumentException(new StringBuffer().append("xmlType cannot be null for: ").append(javaType).toString());
        }
        KeyPair kPair = new KeyPair(xmlType, javaType);
        FactoryPair fPair = new FactoryPair(sf, df);
        this.tupleMap.put(kPair, fPair);
    }

    public void removeDeserializer(Class javaType, QName xmlType) {
        FactoryPair fPair = this.getFactoryPair(xmlType, javaType);
        if (fPair != null) {
            fPair.setDeserializerFactory(null);
        }
    }

    public void removeSerializer(Class javaType, QName xmlType) {
        FactoryPair fPair = this.getFactoryPair(xmlType, javaType);
        if (fPair != null) {
            fPair.setSerializerFactory(null);
        }
    }

    public List<QName> getRegisteredXmlTypes() {
        ArrayList<QName> types = new ArrayList<QName>();
        for (KeyPair keyPair : this.getKeyPairs(null, null)) {
            types.add(keyPair.getXmlType());
        }
        return types;
    }

    public List<Class> getRegisteredJavaTypes() {
        ArrayList<Class> types = new ArrayList<Class>();
        for (KeyPair keyPair : this.getKeyPairs(null, null)) {
            types.add(keyPair.getJavaType());
        }
        return types;
    }

    public Class getJavaType(QName xmlType) {
        Class javaType = null;
        List<KeyPair> keyPairList = this.getKeyPairs(xmlType, null);
        int size = keyPairList.size();
        if (size > 0) {
            KeyPair kPair = keyPairList.get(size - 1);
            javaType = kPair.getJavaType();
        }
        return javaType;
    }

    public Class getJavaType(QName xmlType, boolean getPrimitive) {
        Class javaType = null;
        List<KeyPair> keyPairList = this.getKeyPairs(xmlType, null);
        int size = keyPairList.size();
        if (size == 2 && getPrimitive) {
            KeyPair kPair1 = keyPairList.get(0);
            Class javaType1 = kPair1.getJavaType();
            KeyPair kPair2 = keyPairList.get(1);
            Class javaType2 = kPair2.getJavaType();
            javaType = javaType2.isPrimitive() && !javaType1.isPrimitive() ? javaType2 : (javaType1.isPrimitive() && !javaType2.isPrimitive() ? javaType1 : javaType2);
        } else {
            return this.getJavaType(xmlType);
        }
        return javaType;
    }

    public String getJavaTypeName(QName xmlType) {
        Class javaType = this.getJavaType(xmlType);
        return javaType != null ? javaType.getName() : null;
    }

    public QName getXMLType(Class javaType) {
        QName xmlType = null;
        List<KeyPair> keyPairList = this.getKeyPairs(null, javaType);
        int size = keyPairList.size();
        if (size > 0) {
            KeyPair kPair = keyPairList.get(size - 1);
            xmlType = kPair.getXmlType();
        }
        return xmlType;
    }

    public QName getXMLType(Class javaType, boolean tryAssignable) {
        if (tryAssignable) {
            return this.getXMLType(javaType);
        }
        QName xmlType = null;
        List<KeyPair> keyPairList = this.getKeyPairs(null, javaType, tryAssignable);
        int size = keyPairList.size();
        if (size > 0) {
            KeyPair kPair = keyPairList.get(size - 1);
            xmlType = kPair.getXmlType();
        }
        return xmlType;
    }

    List<KeyPair> getKeyPairs(QName xmlType, Class javaType) {
        ArrayList<KeyPair> keyPairList = new ArrayList<KeyPair>();
        if (xmlType != null && javaType != null) {
            for (KeyPair entry : this.tupleMap.keySet()) {
                if (!xmlType.equals(entry.getXmlType()) || entry.getJavaType() != javaType) continue;
                keyPairList.add(entry);
            }
            if (keyPairList.size() == 0) {
                for (KeyPair entry : this.tupleMap.keySet()) {
                    if (!xmlType.equals(entry.getXmlType()) || !JavaUtils.isAssignableFrom(entry.getJavaType(), javaType)) continue;
                    keyPairList.add(entry);
                }
            }
        } else if (xmlType != null && javaType == null) {
            for (KeyPair entry : this.tupleMap.keySet()) {
                if (!xmlType.equals(entry.getXmlType())) continue;
                keyPairList.add(entry);
            }
        } else if (xmlType == null && javaType != null) {
            for (KeyPair entry : this.tupleMap.keySet()) {
                if (entry.getJavaType() != javaType) continue;
                keyPairList.add(entry);
            }
            if (keyPairList.size() == 0) {
                for (KeyPair entry : this.tupleMap.keySet()) {
                    if (!JavaUtils.isAssignableFrom(entry.getJavaType(), javaType)) continue;
                    keyPairList.add(entry);
                }
            }
        } else if (xmlType == null && javaType == null) {
            keyPairList.addAll(this.tupleMap.keySet());
        }
        return keyPairList;
    }

    List<KeyPair> getKeyPairs(QName xmlType, Class javaType, boolean tryAssignable) {
        if (tryAssignable) {
            return this.getKeyPairs(xmlType, javaType);
        }
        ArrayList<KeyPair> keyPairList = new ArrayList<KeyPair>();
        if (xmlType != null && javaType != null) {
            for (KeyPair entry : this.tupleMap.keySet()) {
                if (!xmlType.equals(entry.getXmlType()) || entry.getJavaType() != javaType) continue;
                keyPairList.add(entry);
            }
        } else if (xmlType != null && javaType == null) {
            for (KeyPair entry : this.tupleMap.keySet()) {
                if (!xmlType.equals(entry.getXmlType())) continue;
                keyPairList.add(entry);
            }
        } else if (xmlType == null && javaType != null) {
            for (KeyPair entry : this.tupleMap.keySet()) {
                if (entry.getJavaType() != javaType) continue;
                keyPairList.add(entry);
            }
        } else if (xmlType == null && javaType == null) {
            keyPairList.addAll(this.tupleMap.keySet());
        }
        return keyPairList;
    }

    FactoryPair getFactoryPair(QName xmlType, Class javaType) {
        FactoryPair fPair = null;
        List<KeyPair> keyPairList = this.getKeyPairs(xmlType, javaType);
        int size = keyPairList.size();
        if (size > 0) {
            KeyPair kPair = keyPairList.get(size - 1);
            fPair = this.tupleMap.get(kPair);
        }
        return fPair;
    }

    protected void registerStandardLiteralTypes() {
        this.registerInternal(Class.forName("java.math.BigDecimal"), Constants.TYPE_LITERAL_DECIMAL, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.math.BigInteger"), Constants.TYPE_LITERAL_POSITIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.math.BigInteger"), Constants.TYPE_LITERAL_NEGATIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.math.BigInteger"), Constants.TYPE_LITERAL_NONPOSITIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.math.BigInteger"), Constants.TYPE_LITERAL_NONNEGATIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.math.BigInteger"), Constants.TYPE_LITERAL_UNSIGNEDLONG, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.math.BigInteger"), Constants.TYPE_LITERAL_INTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.util.Date"), Constants.TYPE_LITERAL_DATETIME, new DateSerializerFactory(), new DateDeserializerFactory());
        this.registerInternal(Class.forName("java.util.Calendar"), Constants.TYPE_LITERAL_DATE, new CalendarSerializerFactory(), new CalendarDeserializerFactory());
        this.registerInternal(Class.forName("java.util.Calendar"), Constants.TYPE_LITERAL_TIME, new CalendarSerializerFactory(), new CalendarDeserializerFactory());
        this.registerInternal(Class.forName("java.util.Calendar"), Constants.TYPE_LITERAL_DATETIME, new CalendarSerializerFactory(), new CalendarDeserializerFactory());
        this.registerInternal(Class.forName("javax.xml.namespace.QName"), Constants.TYPE_LITERAL_QNAME, new QNameSerializerFactory(), new QNameDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_ANYSIMPLETYPE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_DURATION, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_GDAY, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_GMONTH, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_GMONTHDAY, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_GYEAR, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_GYEARMONTH, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_ID, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_LANGUAGE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_NAME, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_NCNAME, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_NMTOKEN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_NORMALIZEDSTRING, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_TOKEN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.String"), Constants.TYPE_LITERAL_STRING, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("[Ljava.lang.String;"), Constants.TYPE_LITERAL_NMTOKENS, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.net.URI"), Constants.TYPE_LITERAL_ANYURI, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Boolean.TYPE, Constants.TYPE_LITERAL_BOOLEAN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.Boolean"), Constants.TYPE_LITERAL_BOOLEAN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Byte.TYPE, Constants.TYPE_LITERAL_BYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.Byte"), Constants.TYPE_LITERAL_BYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("[B"), Constants.TYPE_LITERAL_HEXBINARY, new HexSerializerFactory(), new HexDeserializerFactory());
        this.registerInternal(Class.forName("[Ljava.lang.Byte;"), Constants.TYPE_LITERAL_HEXBINARY, new HexSerializerFactory(), new HexDeserializerFactory());
        this.registerInternal(Class.forName("[B"), Constants.TYPE_LITERAL_BASE64BINARY, new Base64SerializerFactory(), new Base64DeserializerFactory());
        this.registerInternal(Class.forName("[Ljava.lang.Byte;"), Constants.TYPE_LITERAL_BASE64BINARY, new Base64SerializerFactory(), new Base64DeserializerFactory());
        this.registerInternal(Double.TYPE, Constants.TYPE_LITERAL_DOUBLE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.Double"), Constants.TYPE_LITERAL_DOUBLE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Float.TYPE, Constants.TYPE_LITERAL_FLOAT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.Float"), Constants.TYPE_LITERAL_FLOAT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Integer.TYPE, Constants.TYPE_LITERAL_UNSIGNEDSHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.Integer"), Constants.TYPE_LITERAL_UNSIGNEDSHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Integer.TYPE, Constants.TYPE_LITERAL_INT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.Integer"), Constants.TYPE_LITERAL_INT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Long.TYPE, Constants.TYPE_LITERAL_UNSIGNEDINT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.Long"), Constants.TYPE_LITERAL_UNSIGNEDINT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Long.TYPE, Constants.TYPE_LITERAL_LONG, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.Long"), Constants.TYPE_LITERAL_LONG, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Short.TYPE, Constants.TYPE_LITERAL_UNSIGNEDBYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.Short"), Constants.TYPE_LITERAL_UNSIGNEDBYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Short.TYPE, Constants.TYPE_LITERAL_SHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        this.registerInternal(Class.forName("java.lang.Short"), Constants.TYPE_LITERAL_SHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
    }

    public static class FactoryPair {
        private SerializerFactory serializerFactory;
        private DeserializerFactory deserializerFactory;

        FactoryPair(SerializerFactory sf, DeserializerFactory df) {
            this.deserializerFactory = df;
            this.serializerFactory = sf;
        }

        public DeserializerFactory getDeserializerFactory() {
            return this.deserializerFactory;
        }

        public SerializerFactory getSerilaizerFactory() {
            return this.serializerFactory;
        }

        public void setDeserializerFactory(DeserializerFactory df) {
            this.deserializerFactory = df;
        }

        public void setSerializerFactory(SerializerFactory sf) {
            this.serializerFactory = sf;
        }
    }

    public static class KeyPair {
        private QName xmlType;
        private Class javaType;

        public KeyPair(QName xmlType, Class javaType) {
            this.javaType = javaType;
            this.xmlType = xmlType;
        }

        public Class getJavaType() {
            return this.javaType;
        }

        public QName getXmlType() {
            return this.xmlType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyPair)) {
                return false;
            }
            KeyPair keyPair = (KeyPair)o;
            if (!this.javaType.equals(keyPair.javaType)) {
                return false;
            }
            return this.xmlType.equals(keyPair.xmlType);
        }

        public int hashCode() {
            int result = this.xmlType.hashCode();
            result = 29 * result + this.javaType.hashCode();
            return result;
        }

        public String toString() {
            return "[xmlType=" + this.xmlType + ",javaType=" + this.javaType.getName() + "]";
        }
    }
}

