/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.addressing.AddressingConstantsImpl;
import org.jboss.ws.binding.BindingProvider;
import org.jboss.ws.binding.BindingProviderRegistry;
import org.jboss.ws.binding.EndpointInvocation;
import org.jboss.ws.binding.UnboundHeader;
import org.jboss.ws.handler.HandlerChainBaseImpl;
import org.jboss.ws.jaxrpc.ParameterWrapping;
import org.jboss.ws.jaxrpc.SchemaGenerator;
import org.jboss.ws.jaxrpc.ServiceImpl;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.jaxrpc.UnqualifiedCallParameter;
import org.jboss.ws.jaxrpc.encoding.JAXBDeserializerFactory;
import org.jboss.ws.jaxrpc.encoding.JAXBSerializerFactory;
import org.jboss.ws.metadata.ClientEndpointMetaData;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.TypesMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.soap.EndpointInfo;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.SOAPConnectionImpl;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.utils.HolderUtils;
import org.jboss.ws.utils.JavaUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallImpl
implements Call {
    private static Logger log = Logger.getLogger(Class.forName("org.jboss.ws.jaxrpc.CallImpl"));
    private ServiceImpl jaxrpcService;
    private EndpointMetaData epMetaData;
    private QName operationName;
    private QName portType;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private EndpointInvocation epInv;
    private Map<QName, UnboundHeader> unboundHeaders = new LinkedHashMap<QName, UnboundHeader>();
    private static final Set<String> allowedProperties = new HashSet<String>();

    CallImpl(ServiceImpl service) {
        this.jaxrpcService = service;
        ServiceMetaData serviceMetaData = service.getServiceMetaData();
        if (serviceMetaData != null && serviceMetaData.getEndpoints().size() == 1) {
            this.epMetaData = serviceMetaData.getEndpoints().get(0);
            this.setTargetEndpointAddress(this.epMetaData.getEndpointAddress());
        }
    }

    CallImpl(ServiceImpl service, EndpointMetaData epMetaData) {
        this.jaxrpcService = service;
        this.epMetaData = epMetaData;
        this.setTargetEndpointAddress(epMetaData.getEndpointAddress());
    }

    CallImpl(ServiceImpl service, QName epName, QName opName) throws ServiceException {
        this.jaxrpcService = service;
        ServiceMetaData serviceMetaData = service.getServiceMetaData();
        if (serviceMetaData != null) {
            EndpointMetaData epMetaData = null;
            if (serviceMetaData.getEndpoints().size() > 0 && (epMetaData = serviceMetaData.getEndpoint(epName)) == null) {
                throw new ServiceException(new StringBuffer().append("Cannot find endpoint for name: ").append(epName).toString());
            }
            if (epMetaData != null) {
                this.epMetaData = epMetaData;
                this.setTargetEndpointAddress(epMetaData.getEndpointAddress());
            }
        }
        if (opName != null) {
            this.setOperationName(opName);
        }
    }

    public void addUnboundHeader(QName xmlName, QName xmlType, Class javaType, ParameterMode mode) {
        UnboundHeader unboundHeader = new UnboundHeader(xmlName, xmlType, javaType, mode);
        this.unboundHeaders.put(xmlName, unboundHeader);
    }

    public Object getUnboundHeaderValue(QName xmlName) {
        UnboundHeader unboundHeader = this.unboundHeaders.get(xmlName);
        return unboundHeader != null ? unboundHeader.getHeaderValue() : null;
    }

    public void setUnboundHeaderValue(QName xmlName, Object value) {
        UnboundHeader unboundHeader = this.unboundHeaders.get(xmlName);
        if (unboundHeader == null) {
            throw new IllegalArgumentException(new StringBuffer().append("Cannot find unbound header: ").append(xmlName).toString());
        }
        unboundHeader.setHeaderValue(value);
    }

    public void clearUnboundHeaders() {
        this.unboundHeaders.clear();
    }

    public void removeUnboundHeader(QName xmlName) {
        this.unboundHeaders.remove(xmlName);
    }

    public Iterator getUnboundHeaders() {
        return this.unboundHeaders.keySet().iterator();
    }

    public String getTargetEndpointAddress() {
        return (String)this.properties.get("javax.xml.rpc.service.endpoint.address");
    }

    public void setTargetEndpointAddress(String address) {
        this.properties.put("javax.xml.rpc.service.endpoint.address", address);
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName operationName) {
        this.operationName = operationName;
    }

    public void addParameter(String paramName, QName xmlType, ParameterMode parameterMode) {
        TypeMappingImpl typeMapping = this.getEndpointMetaData().getServiceMetaData().getTypeMapping();
        Class<?> javaType = typeMapping.getJavaType(xmlType);
        if (javaType == null) {
            log.warn((Object)new StringBuffer().append("Register unqualified call parameter for: ").append(xmlType).toString());
            javaType = new UnqualifiedCallParameter(xmlType).getClass();
            typeMapping.register(javaType, xmlType, null, null);
        }
        this.addParameter(paramName, xmlType, javaType, parameterMode);
    }

    public void addParameter(String paramName, QName xmlType, Class javaType, ParameterMode mode) {
        QName xmlName = new QName(paramName);
        this.addParameter(xmlName, xmlType, javaType, mode, false);
    }

    public void addParameter(QName xmlName, QName xmlType, Class javaType, ParameterMode mode, boolean inHeader) {
        if (xmlType == null || javaType == null) {
            throw new IllegalArgumentException("Invalid null parameter");
        }
        OperationMetaData opMetaData = this.getOperationMetaData();
        ParameterMetaData paramMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaType.getName());
        opMetaData.addParameter(paramMetaData);
        paramMetaData.setMode(mode);
        paramMetaData.setInHeader(inHeader);
        this.registerParameterType(xmlType, javaType);
    }

    public void removeAllParameters() {
        OperationMetaData opMetaData = this.getOperationMetaData();
        opMetaData.removeAllParameters();
    }

    public void setReturnType(QName xmlType) {
        Class javaType = this.getEndpointMetaData().getServiceMetaData().getTypeMapping().getJavaType(xmlType);
        this.setReturnType(xmlType, javaType);
    }

    public void setReturnType(QName xmlType, Class javaType) {
        if (xmlType == null || javaType == null) {
            throw new IllegalArgumentException("Invalid null parameter");
        }
        OperationMetaData opMetaData = this.getOperationMetaData();
        QName xmlName = new QName("result");
        String javaTypeName = javaType.getName();
        ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
        opMetaData.setReturnParameter(retMetaData);
        this.registerParameterType(xmlType, javaType);
    }

    private void registerParameterType(QName xmlType, Class javaType) {
        ServiceMetaData serviceMetaData = this.getEndpointMetaData().getServiceMetaData();
        String nsURI = xmlType.getNamespaceURI();
        if (!"http://www.jboss.org/jbossws/attachment/mimetype".equals(nsURI)) {
            TypeMappingImpl typeMapping = serviceMetaData.getTypeMapping();
            Class regJavaType = typeMapping.getJavaType(xmlType);
            if (regJavaType == null) {
                typeMapping.register(javaType, xmlType, new JAXBSerializerFactory(), new JAXBDeserializerFactory());
            } else if (regJavaType != null && !JavaUtils.isAssignableFrom(regJavaType, javaType)) {
                throw new IllegalArgumentException(new StringBuffer().append("Different java type already registered: ").append(regJavaType.getName()).toString());
            }
        }
    }

    public void invokeOneWay(Object[] inputParams) {
        try {
            this.invokeInternal(this.operationName, inputParams, true);
        }
        catch (RemoteException rex) {
            throw new JAXRPCException("Cannot invokeOneWay", rex.getCause());
        }
    }

    public Object invoke(Object[] inputParams) throws RemoteException {
        return this.invokeInternal(this.operationName, inputParams, false);
    }

    public Object invoke(QName operationName, Object[] inputParams) throws RemoteException {
        return this.invokeInternal(operationName, inputParams, false);
    }

    public List getOutputValues() {
        if (this.epInv == null) {
            throw new JAXRPCException("Output params not available");
        }
        try {
            OperationMetaData opMetaData = this.getOperationMetaData();
            List<Object> objPayload = new ArrayList<Object>();
            for (QName xmlName : this.epInv.getResponseParamNames()) {
                Object paramValue = this.epInv.getResponseParamValue(xmlName);
                if (opMetaData.isDocumentWrapped()) {
                    objPayload = Arrays.asList((Object[])((Object[])paramValue));
                    break;
                }
                objPayload.add(paramValue);
            }
            return objPayload;
        }
        catch (SOAPException ex) {
            throw new JAXRPCException("Cannot obtain response payload", (Throwable)ex);
        }
    }

    public Map getOutputParams() {
        if (this.epInv == null) {
            throw new JAXRPCException("Output params not available");
        }
        try {
            LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
            for (QName xmlName : this.epInv.getResponseParamNames()) {
                Object value = this.epInv.getResponseParamValue(xmlName);
                outMap.put(xmlName.getLocalPart(), value);
            }
            return outMap;
        }
        catch (SOAPException ex) {
            throw new JAXRPCException("Cannot obtain response payload", (Throwable)ex);
        }
    }

    public QName getPortTypeName() {
        if (this.portType != null) {
            return this.portType;
        }
        return new QName("");
    }

    public QName getReturnType() {
        OperationMetaData opDesc;
        ParameterMetaData retMetaData;
        QName retType = null;
        if (this.operationName != null && (retMetaData = (opDesc = this.getOperationMetaData()).getReturnParameter()) != null) {
            retType = retMetaData.getXmlType();
        }
        return retType;
    }

    public void setPortTypeName(QName portType) {
        this.portType = portType;
    }

    public boolean isParameterAndReturnSpecRequired(QName opName) {
        this.setOperationName(opName);
        OperationMetaData opMetaData = this.getOperationMetaData();
        return opMetaData.getParameters().size() == 0 && opMetaData.getReturnParameter() == null;
    }

    public Iterator getPropertyNames() {
        return allowedProperties.iterator();
    }

    public Object getProperty(String name) {
        if (!allowedProperties.contains(name)) {
            throw new JAXRPCException(new StringBuffer().append("Unsupported property: ").append(name).toString());
        }
        return this.getPropertyExt(name);
    }

    public Object getPropertyExt(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (!allowedProperties.contains(name)) {
            throw new JAXRPCException(new StringBuffer().append("Unsupported property: ").append(name).toString());
        }
        this.setPropertyExt(name, value);
    }

    public void setPropertyExt(String name, Object value) {
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public QName getParameterTypeByName(String paramName) {
        OperationMetaData opMetaData = this.getOperationMetaData();
        ParameterMetaData paramMetaData = opMetaData.getParameter(new QName(paramName));
        if (paramMetaData != null) {
            return paramMetaData.getXmlType();
        }
        return null;
    }

    private Object invokeInternal(QName opName, Object[] inputParams, boolean oneway) throws RemoteException {
        if (!opName.equals(this.operationName)) {
            this.setOperationName(opName);
        }
        OperationMetaData opMetaData = this.getOperationMetaData();
        this.generateOrUpdateSchemas(opMetaData);
        SOAPMessageContextImpl msgContext = new SOAPMessageContextImpl();
        MessageContextAssociation.pushMessageContext(msgContext);
        msgContext.setOperationMetaData(opMetaData);
        for (String key : this.properties.keySet()) {
            Object value = this.properties.get(key);
            msgContext.setProperty(key, value);
        }
        try {
            BindingProvider bindingProvider = BindingProviderRegistry.getDefaultProvider();
            this.epInv = new EndpointInvocation(opMetaData);
            this.epInv.initInputParams(inputParams);
            SOAPMessage reqMessage = bindingProvider.bindRequestMessage(opMetaData, this.epInv, this.unboundHeaders);
            QName portName = this.epMetaData.getName();
            if (this.callRequestHandlerChain(portName, msgContext)) {
                String targetAddress = this.getTargetEndpointAddress();
                AddressingProperties addrProps = (AddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.outbound");
                if (targetAddress == null && addrProps != null && addrProps.getTo() != null) {
                    AddressingConstantsImpl ADDR = new AddressingConstantsImpl();
                    String wsaTo = addrProps.getTo().getURI().toString();
                    if (!wsaTo.equals(ADDR.getAnonymousURI())) {
                        try {
                            URL wsaToURL = new URL(wsaTo);
                            log.debug((Object)new StringBuffer().append("Sending request to addressing destination: ").append(wsaToURL).toString());
                            targetAddress = wsaToURL.toExternalForm();
                        }
                        catch (MalformedURLException ex) {
                            log.debug((Object)new StringBuffer().append("Not a valid URL: ").append(wsaTo).toString());
                        }
                    }
                }
                if (targetAddress == null) {
                    throw new WSException("Target endpoint address not set");
                }
                HashMap<String, Object> callProps = new HashMap<String, Object>();
                callProps.putAll(this.properties);
                this.syncMessageProperties(callProps, msgContext);
                EndpointInfo epInfo = new EndpointInfo(this.epMetaData, targetAddress, callProps);
                SOAPMessage resMessage = new SOAPConnectionImpl().call(reqMessage, epInfo, oneway);
                msgContext.setMessage(resMessage);
            }
            Object retObj = null;
            if (!oneway) {
                this.callResponseHandlerChain(portName, msgContext);
                SOAPMessage resMessage = msgContext.getMessage();
                bindingProvider.unbindResponseMessage(opMetaData, resMessage, this.epInv, this.unboundHeaders);
                retObj = this.syncOutputParams(inputParams, this.epInv);
            }
            Object object = retObj;
            return object;
        }
        catch (SOAPFaultException ex) {
            log.error((Object)"Call invocation failed", (Throwable)ex);
            String faultCode = ex.getFaultCode().getLocalPart();
            throw new RemoteException(new StringBuffer().append("Call invocation failed with code [").append(faultCode).append("] because of: ").append(ex.getFaultString()).toString(), ex);
        }
        catch (Exception ex) {
            throw new RemoteException(new StringBuffer().append("Call invocation failed: ").append(ex.getMessage()).toString(), ex);
        }
        finally {
            this.syncMessageProperties(this.properties, msgContext);
            MessageContextAssociation.popMessageContext();
        }
    }

    private void syncMessageProperties(Map<String, Object> props, MessageContext msgContext) {
        Iterator it = msgContext.getPropertyNames();
        while (it.hasNext()) {
            String propName = (String)it.next();
            Object property = msgContext.getProperty(propName);
            props.put(propName, property);
        }
    }

    private boolean callRequestHandlerChain(QName portName, SOAPMessageContextImpl msgContext) {
        HandlerChain handlerChain = this.jaxrpcService.getHandlerChain(portName);
        return handlerChain != null ? handlerChain.handleRequest((MessageContext)msgContext) : true;
    }

    private boolean callResponseHandlerChain(QName portName, SOAPMessageContextImpl msgContext) {
        boolean status = true;
        String[] roles = null;
        HandlerChain handlerChain = this.jaxrpcService.getHandlerChain(portName);
        if (handlerChain != null) {
            roles = handlerChain.getRoles();
            status = handlerChain.handleResponse((MessageContext)msgContext);
        }
        HandlerChainBaseImpl.checkMustUnderstand(msgContext, roles);
        return status;
    }

    private void generateOrUpdateSchemas(OperationMetaData opMetaData) {
        ServiceMetaData serviceMetaData = opMetaData.getEndpointMetaData().getServiceMetaData();
        if (serviceMetaData.getWsdlFile() == null) {
            TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
            for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                this.generateOrUpdateParameterSchema(typesMetaData, paramMetaData);
            }
            ParameterMetaData retMetaData = opMetaData.getReturnParameter();
            if (retMetaData != null) {
                this.generateOrUpdateParameterSchema(typesMetaData, retMetaData);
            }
        }
    }

    private void generateOrUpdateParameterSchema(TypesMetaData typesMetaData, ParameterMetaData paramMetaData) {
        if (!paramMetaData.isSwA()) {
            QName xmlType = paramMetaData.getXmlType();
            Class javaType = paramMetaData.getJavaType();
            ServiceMetaData serviceMetaData = this.getEndpointMetaData().getServiceMetaData();
            TypeMappingImpl typeMapping = serviceMetaData.getTypeMapping();
            SerializerFactory serFactory = typeMapping.getSerializer(javaType, xmlType);
            if (serFactory instanceof JAXBSerializerFactory) {
                SchemaGenerator xsdGenerator = new SchemaGenerator();
                JBossXSModel model = xsdGenerator.generateXSDSchema(xmlType, javaType);
                typesMetaData.addSchemaModel(model);
            }
        }
    }

    public OperationMetaData getOperationMetaData() {
        if (this.operationName == null) {
            throw new WSException("Operation name not set");
        }
        return this.getOperationMetaData(this.operationName);
    }

    public OperationMetaData getOperationMetaData(QName opName) {
        if (opName == null) {
            throw new IllegalArgumentException("Cannot get OperationMetaData for null");
        }
        EndpointMetaData epMetaData = this.getEndpointMetaData();
        OperationMetaData opMetaData = epMetaData.getOperation(opName);
        if (opMetaData == null && this.jaxrpcService.getWSDLDocumentLocation() == null) {
            opMetaData = new OperationMetaData(epMetaData, opName, opName.getLocalPart());
            epMetaData.addOperation(opMetaData);
        }
        if (opMetaData == null) {
            throw new JAXRPCException(new StringBuffer().append("Cannot obtain operation meta data for: ").append(opName).toString());
        }
        return opMetaData;
    }

    public EndpointMetaData getEndpointMetaData() {
        if (this.epMetaData == null) {
            UnifiedMetaData wsMetaData = new UnifiedMetaData();
            ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, new QName("http://www.jboss.org/jbossws", "AnonymousService"));
            wsMetaData.addService(serviceMetaData);
            this.epMetaData = new ClientEndpointMetaData(serviceMetaData, new QName("http://www.jboss.org/jbossws", "AnonymousEndpoint"));
            this.epMetaData.setStyle(Style.RPC);
            serviceMetaData.addEndpoint(this.epMetaData);
        }
        return this.epMetaData;
    }

    private Object syncOutputParams(Object[] inParams, EndpointInvocation epInv) throws SOAPException {
        Object retValue = null;
        OperationMetaData opMetaData = this.getOperationMetaData();
        ParameterMetaData retMetaData = opMetaData.getReturnParameter();
        if (retMetaData != null) {
            retValue = epInv.getReturnValue();
            if (opMetaData.isDocumentWrapped()) {
                retValue = ParameterWrapping.unwrapResponseParameter(opMetaData, retValue);
            }
            if (JavaUtils.isPrimitive(retMetaData.getJavaType())) {
                retValue = JavaUtils.getPrimitiveValue(retValue);
            }
        }
        int index = 0;
        for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
            ParameterMode paramMode = paramMetaData.getMode();
            if (paramMode == ParameterMode.INOUT || paramMode == ParameterMode.OUT) {
                QName xmlName = paramMetaData.getXmlName();
                Object value = epInv.getResponseParamValue(xmlName);
                log.debug((Object)new StringBuffer().append("holder [").append(index).append("] ").append(xmlName).toString());
                HolderUtils.setHolderValue(inParams[index], value);
            }
            if (index == 0 && opMetaData.isDocumentWrapped()) {
                index = paramMetaData.getWrappedVariables().size() - 1;
            }
            ++index;
        }
        return retValue;
    }

    static {
        allowedProperties.add("javax.xml.rpc.encodingstyle.namespace.uri");
        allowedProperties.add("javax.xml.rpc.soap.operation.style");
        allowedProperties.add("javax.xml.rpc.session.maintain");
        allowedProperties.add("javax.xml.rpc.soap.http.soapaction.uri");
        allowedProperties.add("javax.xml.rpc.soap.http.soapaction.use");
        allowedProperties.add("javax.xml.rpc.security.auth.username");
        allowedProperties.add("javax.xml.rpc.security.auth.password");
    }
}

