/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing.mgmt;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.ws.WSException;
import org.jboss.ws.eventing.deployment.EventSourceDesc;
import org.jboss.ws.eventing.element.EndpointReference;
import org.jboss.ws.eventing.element.ReferenceParameters;
import org.jboss.ws.eventing.mgmt.DispatchJob;
import org.jboss.ws.eventing.mgmt.DispatcherDelegate;
import org.jboss.ws.eventing.mgmt.EventDispatcher;
import org.jboss.ws.eventing.mgmt.EventSource;
import org.jboss.ws.eventing.mgmt.EventingBuilder;
import org.jboss.ws.eventing.mgmt.Filter;
import org.jboss.ws.eventing.mgmt.Subscription;
import org.jboss.ws.eventing.mgmt.SubscriptionError;
import org.jboss.ws.eventing.mgmt.SubscriptionManagerMBean;
import org.jboss.ws.eventing.mgmt.SubscriptionTicket;
import org.jboss.ws.utils.UUIDGenerator;
import org.w3c.dom.Element;

public class SubscriptionManager
extends ServiceMBeanSupport
implements SubscriptionManagerMBean,
EventDispatcher {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.eventing.mgmt.SubscriptionManager"));
    private ConcurrentMap<URI, EventSource> eventSourceMapping = new ConcurrentHashMap();
    private ConcurrentMap<URI, List<Subscription>> subscriptionMapping = new ConcurrentHashMap();
    private BlockingQueue<Runnable> eventQueue = new LinkedBlockingQueue();
    private ThreadPoolExecutor threadPool;
    private WatchDog watchDog;
    private static EventingBuilder builder = EventingBuilder.createEventingBuilder();

    protected void startService() throws Exception {
        super.startService();
        this.threadPool = new ThreadPoolExecutor(5, 15, 5000L, TimeUnit.MILLISECONDS, this.eventQueue);
        this.watchDog = new WatchDog(this, this.subscriptionMapping);
        this.watchDog.startup();
        Util.rebind((Context)new InitialContext(), (String)"EventDispatcher", (Object)new DispatcherDelegate("localhost"));
        log.info((Object)"Bound event dispatcher to java:/EventDispatcher");
    }

    protected void stopService() throws Exception {
        super.stopService();
        Util.unbind((Context)new InitialContext(), (String)"EventDispatcher");
        this.threadPool.shutdown();
        this.watchDog.shutdown();
        Iterator i$ = this.eventSourceMapping.keySet().iterator();
        while (i$.hasNext()) {
            URI eventSourceNS = (URI)i$.next();
            this.removeEventSource(eventSourceNS);
        }
    }

    private static URI generateSubscriptionID() {
        try {
            return new URI("urn:jbwse:" + UUIDGenerator.generateRandomUUIDString());
        }
        catch (URISyntaxException e) {
            throw new WSException(e.getMessage());
        }
    }

    public void registerEventSource(EventSourceDesc descriptor) {
        EventSource eventSource = builder.newEventSource(descriptor);
        if (this.eventSourceMapping.containsKey(eventSource.getNameSpace())) {
            throw new IllegalArgumentException("EventSource " + descriptor.getName() + " already registered");
        }
        this.eventSourceMapping.put(eventSource.getNameSpace(), eventSource);
        this.subscriptionMapping.put(eventSource.getNameSpace(), new CopyOnWriteArrayList());
        eventSource.setState(EventSource.State.STARTED);
        log.debug((Object)("Registered: " + eventSource));
    }

    public void removeEventSource(URI eventSourceNS) {
        if (this.eventSourceMapping.containsKey(eventSourceNS)) {
            List subscriptions = (List)this.subscriptionMapping.get(eventSourceNS);
            Iterator i$ = subscriptions.iterator();
            while (i$.hasNext()) {
                Subscription s = (Subscription)i$.next();
                s.end("http://schemas.xmlsoap.org/ws/2004/08/eventing/SourceShuttingDown");
            }
            subscriptions.clear();
            this.eventSourceMapping.remove(eventSourceNS);
            log.debug((Object)("Event source " + eventSourceNS + " removed"));
        }
    }

    public SubscriptionTicket subscribe(URI eventSourceNS, EndpointReference notifyTo, EndpointReference endTo, Date expires, Filter filter) throws SubscriptionError {
        log.debug((Object)("Subscription request for " + eventSourceNS));
        EventSource eventSource = (EventSource)this.eventSourceMapping.get(eventSourceNS);
        if (null == eventSource) {
            throw new SubscriptionError("EventSourceUnableToProcess", "EventSource '" + eventSourceNS + "' not registered");
        }
        if (expires != null) {
            this.assertLeaseConstraints(expires);
        } else {
            expires = new Date(System.currentTimeMillis() + 300000L);
        }
        if (filter != null) {
            if (eventSource.getSupportedFilterDialects().isEmpty()) {
                throw new SubscriptionError("FilteringNotSupported", "Filtering is not supported.");
            }
            boolean filterAvailable = false;
            Iterator<URI> i$ = eventSource.getSupportedFilterDialects().iterator();
            while (i$.hasNext()) {
                URI supportedDialect = i$.next();
                if (!filter.getDialect().equals(supportedDialect)) continue;
                filterAvailable = true;
                break;
            }
            if (!filterAvailable) {
                throw new SubscriptionError("FilteringRequestedUnavailable", "The requested filter dialect is not supported.");
            }
        }
        EndpointReference endpointReference = new EndpointReference();
        endpointReference.setAddress(eventSource.getManagerAddress());
        endpointReference.setReferenceParams(new ReferenceParameters(SubscriptionManager.generateSubscriptionID()));
        Subscription subscription = new Subscription(eventSource.getNameSpace(), endpointReference, notifyTo, endTo, expires, filter);
        ((List)this.subscriptionMapping.get(eventSourceNS)).add(subscription);
        log.debug((Object)("Registered subscription " + subscription.getIdentifier()));
        return new SubscriptionTicket(endpointReference, subscription.getExpires());
    }

    private void assertLeaseConstraints(Date expireDate) throws SubscriptionError {
        long expires = expireDate.getTime() - System.currentTimeMillis();
        if (expires < 0L || 600000L < expires) {
            throw new SubscriptionError("InvalidExpirationTime", "The expiration time requested is invalid: " + expires + "ms");
        }
    }

    public Date renew(URI identifier, Date lease) throws SubscriptionError {
        Subscription subscription = this.subscriberForID(identifier);
        if (null == subscription) {
            throw new SubscriptionError("UnableToRenew", "Subscription " + identifier + " does not exist");
        }
        if (lease != null) {
            this.assertLeaseConstraints(lease);
        } else {
            lease = new Date(System.currentTimeMillis() + 300000L);
        }
        subscription.setExpires(lease);
        return lease;
    }

    public final Date getStatus(URI identifier) throws SubscriptionError {
        Subscription subscription = this.subscriberForID(identifier);
        if (null == subscription) {
            throw new SubscriptionError("EventSourceUnableToProcess", "Subscription " + identifier + " does not exist");
        }
        return subscription.getExpires();
    }

    public void unsubscribe(URI identifier) throws SubscriptionError {
        Iterator i$ = this.subscriptionMapping.values().iterator();
        block0: while (i$.hasNext()) {
            List subscriptions = (List)i$.next();
            Iterator i$2 = subscriptions.iterator();
            while (i$2.hasNext()) {
                Subscription s = (Subscription)i$2.next();
                if (!identifier.equals(s.getIdentifier())) continue;
                subscriptions.remove(s);
                log.debug((Object)("Removed subscription " + s));
                continue block0;
            }
        }
    }

    public String showEventsourceTable() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<h3>Deployed Eventsources</h3>");
        pw.println("<table>");
        pw.println("<tr><td>Name</td><td>NS</td></tr>");
        Iterator i$ = this.eventSourceMapping.values().iterator();
        while (i$.hasNext()) {
            EventSource source = (EventSource)i$.next();
            pw.println("<tr><td>" + source.getName() + "</td><td>" + source.getNameSpace() + "</td></tr>");
        }
        pw.println("</table>");
        pw.close();
        return sw.toString();
    }

    public String showSubscriptionTable() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<h3>Registered Subscriptions</h3>");
        pw.println("<table>");
        pw.println("<tr><td>Identifier</td><td>Expires</td><td>Filter</td></tr>");
        Iterator i$ = this.subscriptionMapping.values().iterator();
        while (i$.hasNext()) {
            List subscriptions = (List)i$.next();
            Iterator i$2 = subscriptions.iterator();
            while (i$2.hasNext()) {
                Subscription s = (Subscription)i$2.next();
                pw.println("<tr><td>" + s.getIdentifier() + "</td><td>" + s.getExpires() + "</td><td>" + s.getFilter().getExpression() + "</td></tr>");
            }
        }
        pw.println("</table>");
        pw.close();
        return sw.toString();
    }

    private Subscription subscriberForID(URI id) {
        Subscription subscription = null;
        Iterator i$ = this.subscriptionMapping.values().iterator();
        block0: while (i$.hasNext()) {
            List subscriptions = (List)i$.next();
            Iterator i$2 = subscriptions.iterator();
            while (i$2.hasNext()) {
                Subscription s = (Subscription)i$2.next();
                if (!id.equals(s.getIdentifier())) continue;
                subscription = s;
                continue block0;
            }
        }
        return subscription;
    }

    public void dispatch(URI eventSourceNS, Element payload) {
        DispatchJob dispatchJob = new DispatchJob(eventSourceNS, payload, (edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap)this.subscriptionMapping);
        this.threadPool.execute((Runnable)dispatchJob);
    }

    public int getCorePoolSize() {
        return this.threadPool.getCorePoolSize();
    }

    public int getMaximumPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    public int getLargestPoolSize() {
        return this.threadPool.getLargestPoolSize();
    }

    public int getActiveCount() {
        return this.threadPool.getActiveCount();
    }

    public long getCompletedTaskCount() {
        return this.threadPool.getCompletedTaskCount();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.threadPool.setCorePoolSize(corePoolSize);
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.threadPool.setMaximumPoolSize(maxPoolSize);
    }

    public void setEventKeepAlive(long millies) {
        this.threadPool.setKeepAliveTime(millies, TimeUnit.MILLISECONDS);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WatchDog
    implements Runnable {
        private ConcurrentMap<URI, List<Subscription>> subscriptions;
        private boolean active = true;
        private Thread worker;
        final /* synthetic */ SubscriptionManager this$0;

        public WatchDog(ConcurrentMap<URI, List<Subscription>> subscriptions) {
            this.this$0 = var1_1;
            this.subscriptions = subscriptions;
        }

        @Override
        public void run() {
            while (this.active) {
                for (List subscriptions : this.this$0.subscriptionMapping.values()) {
                    for (Subscription s : subscriptions) {
                        if (!s.isExpired()) continue;
                        s.end("http://schemas.xmlsoap.org/ws/2004/08/eventing/SourceCanceling");
                        subscriptions.remove(s);
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
            }
        }

        public void startup() {
            this.worker = new Thread((Runnable)this, "SubscriptionWatchDog");
            this.worker.start();
        }

        public void shutdown() {
            this.active = false;
        }
    }
}

