/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing.deployment;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.ws.eventing.deployment.EventSourceDesc;
import org.jboss.ws.eventing.metadata.EventingEpMetaExt;
import org.jboss.ws.eventing.mgmt.SubscriptionManagerFactory;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.server.ServiceEndpointInfo;
import org.jboss.ws.server.ServiceEndpointLifecycle;

public class EventingEndpointLifecycle
implements ServiceEndpointLifecycle {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.eventing.deployment.EventingEndpointLifecycle"));
    private Map<ObjectName, EventSourceDesc> serviceEndpoints = new HashMap<ObjectName, EventSourceDesc>();
    private Map<String, EventSourceDesc> pendingEventSources = new HashMap<String, EventSourceDesc>();
    private SubscriptionManagerFactory factory = SubscriptionManagerFactory.getInstance();
    private String previousServiceName = null;

    public void createServiceEndpoint(ServiceEndpointInfo seInfo) throws Exception {
        ServerEndpointMetaData epMetaData = seInfo.getEndpointMetaData();
        EventingEpMetaExt ext = (EventingEpMetaExt)epMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/08/eventing");
        if (null == ext) {
            return;
        }
        ObjectName serviceID = seInfo.getServiceID();
        String serviceName = serviceID.getKeyProperty("service");
        if (this.previousServiceName != null && !this.previousServiceName.equals(serviceName)) {
            if (!this.pendingEventSources.isEmpty()) {
                log.warn((Object)("Removing incomplete event source deployments: " + this.pendingEventSources.keySet()));
            }
            this.pendingEventSources.clear();
        }
        if (!this.isRegistered(ext) && !this.isPending(ext)) {
            EventSourceDesc desc = new EventSourceDesc(ext.getEventSourceNS(), ext.getNotificationSchema());
            String portName = epMetaData.getPortComponentName();
            if (portName.equals("SubscriptionManagerPort")) {
                desc.setManagerEPAddress(epMetaData.getEndpointAddress());
            } else if (portName.equals("EventSourcePort")) {
                desc.setEventSourceEPAddress(epMetaData.getEndpointAddress());
            } else {
                throw new IllegalArgumentException("Invalid port name: " + portName);
            }
            this.pendingEventSources.put(serviceName, desc);
            log.debug((Object)("Pending event source: " + serviceID));
        } else if (this.isPending(ext)) {
            EventSourceDesc desc = this.pendingEventSources.get(serviceName);
            this.serviceEndpoints.put(serviceID, desc);
            this.factory.createSubscriptionManager().registerEventSource(this.serviceEndpoints.get(serviceID));
            log.debug((Object)("Registered event source: " + serviceID));
            this.pendingEventSources.remove(serviceName);
        }
    }

    public void startServiceEndpoint(ObjectName serviceID) throws Exception {
        if (this.serviceEndpoints.keySet().contains(serviceID)) {
            log.info((Object)("Start event source " + this.serviceEndpoints.get(serviceID).getName()));
        }
    }

    public void stopServiceEndpoint(ObjectName serviceID) throws Exception {
        if (this.serviceEndpoints.keySet().contains(serviceID)) {
            log.info((Object)("Stop event source " + this.serviceEndpoints.get(serviceID).getName()));
        }
    }

    public void destroyServiceEndpoint(ObjectName serviceID) throws Exception {
        if (this.serviceEndpoints.keySet().contains(serviceID)) {
            this.factory.createSubscriptionManager().removeEventSource(new URI(this.serviceEndpoints.get(serviceID).getName()));
            log.info((Object)("Remove event source " + this.serviceEndpoints.get(serviceID).getName()));
            this.serviceEndpoints.remove(serviceID);
        }
    }

    private boolean isRegistered(EventingEpMetaExt ext) {
        boolean isRegistered = false;
        Iterator<EventSourceDesc> i$ = this.serviceEndpoints.values().iterator();
        while (i$.hasNext()) {
            EventSourceDesc desc = i$.next();
            if (!desc.getName().equals(ext.getEventSourceNS())) continue;
            isRegistered = true;
        }
        return isRegistered;
    }

    private boolean isPending(EventingEpMetaExt ext) {
        boolean isPending = false;
        Iterator<EventSourceDesc> i$ = this.pendingEventSources.values().iterator();
        while (i$.hasNext()) {
            EventSourceDesc desc = i$.next();
            if (!desc.getName().equals(ext.getEventSourceNS())) continue;
            isPending = true;
        }
        return isPending;
    }
}

