/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.binding.soap;

import java.awt.Image;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.mail.internet.MimeMultipart;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.ws.WSException;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.binding.BindingProvider;
import org.jboss.ws.binding.EndpointInvocation;
import org.jboss.ws.binding.UnboundHeader;
import org.jboss.ws.jaxrpc.ParameterWrapping;
import org.jboss.ws.jaxrpc.SOAPFaultExceptionHelper;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.TypesMetaData;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPBodyElementDoc;
import org.jboss.ws.soap.SOAPBodyElementRpc;
import org.jboss.ws.soap.SOAPContentElement;
import org.jboss.ws.soap.SOAPElementImpl;
import org.jboss.ws.soap.SOAPFaultImpl;
import org.jboss.ws.soap.SOAPHeaderElementImpl;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.soap.SOAPMessageImpl;
import org.jboss.ws.soap.attachment.AttachmentPartImpl;
import org.jboss.ws.soap.attachment.CIDGenerator;
import org.jboss.ws.utils.JavaUtils;
import org.jboss.ws.utils.MimeUtils;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SOAPBindingProvider
implements BindingProvider {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.binding.soap.SOAPBindingProvider"));

    protected abstract SOAPMessage createMessage(OperationMetaData var1) throws SOAPException;

    @Override
    public SOAPMessage bindRequestMessage(OperationMetaData opMetaData, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders) throws BindingException {
        log.debug((Object)new StringBuffer().append("bindRequestMessage: ").append(opMetaData.getXmlName()).toString());
        try {
            Object value;
            QName xmlName;
            SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException("MessageContext not available");
            }
            SOAPMessageImpl reqMessage = (SOAPMessageImpl)this.createMessage(opMetaData);
            msgContext.setMessage(reqMessage);
            SOAPEnvelope soapEnvelope = reqMessage.getSOAPPart().getEnvelope();
            SOAPBody soapBody = soapEnvelope.getBody();
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
            Style style = opMetaData.getStyle();
            if (style == Style.RPC) {
                QName opQName = opMetaData.getXmlName();
                NameImpl opName = new NameImpl(namespaceRegistry.registerQName(opQName));
                log.debug((Object)new StringBuffer().append("Create RPC body element: ").append(opName).toString());
                SOAPBodyElementRpc soapBodyElement = new SOAPBodyElementRpc(opName);
                soapBodyElement = (SOAPBodyElement)soapBody.addChildElement((SOAPElement)soapBodyElement);
                for (ParameterMetaData paramMetaData : opMetaData.getInputParameters()) {
                    QName xmlName2 = paramMetaData.getXmlName();
                    Object value2 = epInv.getRequestParamValue(xmlName2);
                    if (paramMetaData.isSwA()) {
                        CIDGenerator cidGenerator = reqMessage.getCidGenerator();
                        AttachmentPart part = this.getAttachmentPart(paramMetaData, value2, cidGenerator);
                        reqMessage.addAttachmentPart(part);
                        continue;
                    }
                    Object soapElement = paramMetaData.isInHeader() ? soapHeader : soapBodyElement;
                    SOAPContentElement contentElement = this.addParameterToMessage(paramMetaData, value2, (SOAPElement)soapElement);
                    if (!paramMetaData.isXOP()) continue;
                    CIDGenerator cidGenerator = reqMessage.getCidGenerator();
                    AttachmentPart part = this.getAttachmentPart(paramMetaData, value2, cidGenerator);
                    String contentType = part.getMimeHeader("Content-Type")[0];
                    contentElement.setXMimeContentType(contentType);
                    contentElement.setObjectValue(value2);
                }
            } else if (style == Style.DOCUMENT) {
                for (ParameterMetaData paramMetaData : opMetaData.getInputParameters()) {
                    xmlName = paramMetaData.getXmlName();
                    value = epInv.getRequestParamValue(xmlName);
                    if (paramMetaData.isSwA()) {
                        CIDGenerator cidGenerator = reqMessage.getCidGenerator();
                        AttachmentPart part = this.getAttachmentPart(paramMetaData, value, cidGenerator);
                        reqMessage.addAttachmentPart(part);
                        continue;
                    }
                    SOAPHeader soapElement = paramMetaData.isInHeader() ? soapHeader : soapBody;
                    this.addParameterToMessage(paramMetaData, value, (SOAPElement)soapElement);
                }
            } else {
                throw new WSException(new StringBuffer().append("Unsupported message style: ").append(style).toString());
            }
            if (unboundHeaders != null) {
                for (UnboundHeader unboundHeader : unboundHeaders.values()) {
                    if (unboundHeader.getMode() == ParameterMode.OUT) continue;
                    xmlName = unboundHeader.getXmlName();
                    value = unboundHeader.getHeaderValue();
                    xmlName = namespaceRegistry.registerQName(xmlName);
                    NameImpl soapName = new NameImpl(xmlName.getLocalPart(), xmlName.getPrefix(), xmlName.getNamespaceURI());
                    SOAPHeaderElementImpl contentElement = new SOAPHeaderElementImpl(soapName);
                    contentElement.setParamMetaData(unboundHeader.toParameterMetaData(opMetaData));
                    contentElement.setObjectValue(value);
                    log.debug((Object)new StringBuffer().append("Add unboundHeader element: ").append(soapName).toString());
                    soapHeader.addChildElement((SOAPElement)contentElement);
                }
            }
            return reqMessage;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public EndpointInvocation unbindRequestMessage(OperationMetaData opMetaData, SOAPMessage reqMessage) throws BindingException {
        log.debug((Object)new StringBuffer().append("unbindRequestMessage: ").append(opMetaData.getXmlName()).toString());
        try {
            SOAPEnvelope soapEnvelope = reqMessage.getSOAPPart().getEnvelope();
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            SOAPBody soapBody = soapEnvelope.getBody();
            EndpointInvocation epInv = new EndpointInvocation(opMetaData);
            SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException("MessageContext not available");
            }
            NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
            if (!opMetaData.isMessageEndpoint()) {
                Style style = opMetaData.getStyle();
                if (style == Style.RPC) {
                    SOAPBodyElement soapBodyElement = (SOAPBodyElement)soapBody.getChildElements().next();
                    Name elName = soapBodyElement.getElementName();
                    QName elQName = new QName(elName.getURI(), elName.getLocalName(), elName.getPrefix());
                    elQName = namespaceRegistry.registerQName(elQName);
                    for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                        Object value;
                        QName xmlName = paramMetaData.getXmlName();
                        if (paramMetaData.getMode() == ParameterMode.OUT) {
                            epInv.setRequestParamValue(xmlName, null);
                            continue;
                        }
                        if (paramMetaData.isSwA()) {
                            value = this.getAttachmentFromMessage(paramMetaData, reqMessage);
                            epInv.setRequestParamValue(xmlName, value);
                            continue;
                        }
                        if (!paramMetaData.isInHeader()) {
                            value = this.getParameterFromMessage(paramMetaData, (SOAPElement)soapBodyElement, false);
                            epInv.setRequestParamValue(xmlName, value);
                            continue;
                        }
                        value = this.getParameterFromMessage(paramMetaData, (SOAPElement)soapHeader, false);
                        epInv.setRequestParamValue(xmlName, value);
                    }
                } else {
                    for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                        Object value;
                        QName xmlName = paramMetaData.getXmlName();
                        if (paramMetaData.isSwA()) {
                            value = this.getAttachmentFromMessage(paramMetaData, reqMessage);
                            epInv.setRequestParamValue(xmlName, value);
                            continue;
                        }
                        if (paramMetaData.isInHeader()) {
                            if (paramMetaData.getMode() == ParameterMode.IN) {
                                value = this.getParameterFromMessage(paramMetaData, (SOAPElement)soapHeader, false);
                                epInv.setRequestParamValue(xmlName, value);
                                continue;
                            }
                            value = this.getParameterFromMessage(paramMetaData, (SOAPElement)soapHeader, true);
                            epInv.setRequestParamValue(xmlName, value);
                            continue;
                        }
                        value = this.getParameterFromMessage(paramMetaData, (SOAPElement)soapBody, false);
                        epInv.setRequestParamValue(xmlName, value);
                    }
                }
            } else {
                for (ParameterMetaData paramMetaData : opMetaData.getParameters()) {
                    QName xmlName = paramMetaData.getXmlName();
                    Object value = soapBody.getChildElements().next();
                    epInv.setRequestParamValue(xmlName, value);
                }
            }
            return epInv;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public SOAPMessage bindResponseMessage(OperationMetaData opMetaData, EndpointInvocation epInv) throws BindingException {
        log.debug((Object)new StringBuffer().append("bindResponseMessage: ").append(opMetaData.getXmlName()).toString());
        try {
            SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException("MessageContext not available");
            }
            SOAPMessageImpl resMessage = (SOAPMessageImpl)this.createMessage(opMetaData);
            msgContext.setMessage(resMessage);
            if (opMetaData.isOneWayOperation()) {
                resMessage.getSOAPPart().setContent(null);
                return resMessage;
            }
            SOAPEnvelope soapEnvelope = resMessage.getSOAPPart().getEnvelope();
            SOAPHeader soapHeader = soapEnvelope.getHeader();
            SOAPBody soapBody = soapEnvelope.getBody();
            NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
            Style style = opMetaData.getStyle();
            if (style == Style.RPC) {
                QName opQName = opMetaData.getResponseName();
                NameImpl opName = new NameImpl(namespaceRegistry.registerQName(opQName));
                SOAPBodyElementRpc soapBodyElement = new SOAPBodyElementRpc(opName);
                soapBodyElement = (SOAPBodyElement)soapBody.addChildElement((SOAPElement)soapBodyElement);
                ParameterMetaData retMetaData = opMetaData.getReturnParameter();
                if (retMetaData != null) {
                    Object value = epInv.getReturnValue();
                    if (retMetaData.isSwA()) {
                        CIDGenerator cidGenerator = resMessage.getCidGenerator();
                        AttachmentPart part = this.getAttachmentPart(retMetaData, value, cidGenerator);
                        resMessage.addAttachmentPart(part);
                        epInv.setReturnValue(part);
                    } else {
                        SOAPContentElement soapElement = this.addParameterToMessage(retMetaData, value, soapBodyElement);
                        epInv.setReturnValue(soapElement);
                    }
                }
                for (ParameterMetaData paramMetaData : opMetaData.getOutputParameters()) {
                    QName xmlName = paramMetaData.getXmlName();
                    Object value = epInv.getResponseParamValue(xmlName);
                    if (paramMetaData.isSwA()) {
                        CIDGenerator cidGenerator = resMessage.getCidGenerator();
                        AttachmentPart part = this.getAttachmentPart(retMetaData, value, cidGenerator);
                        resMessage.addAttachmentPart(part);
                        continue;
                    }
                    if (paramMetaData.isInHeader()) {
                        this.addParameterToMessage(paramMetaData, value, (SOAPElement)soapHeader);
                        continue;
                    }
                    this.addParameterToMessage(paramMetaData, value, soapBodyElement);
                }
            } else if (style == Style.DOCUMENT) {
                ParameterMetaData retMetaData = opMetaData.getReturnParameter();
                if (retMetaData != null) {
                    Object value = epInv.getReturnValue();
                    if (opMetaData.isDocumentWrapped()) {
                        value = ParameterWrapping.wrapResponseParameter(opMetaData, value);
                    }
                    if (retMetaData.isSwA()) {
                        CIDGenerator cidGenerator = resMessage.getCidGenerator();
                        AttachmentPart part = this.getAttachmentPart(retMetaData, value, cidGenerator);
                        resMessage.addAttachmentPart(part);
                        epInv.setReturnValue(part);
                    } else {
                        SOAPContentElement soapElement = this.addParameterToMessage(retMetaData, value, (SOAPElement)soapBody);
                        epInv.setReturnValue(soapElement);
                    }
                }
                for (ParameterMetaData paramMetaData : opMetaData.getOutputParameters()) {
                    QName xmlName = paramMetaData.getXmlName();
                    if (!paramMetaData.isInHeader()) continue;
                    Object value = epInv.getResponseParamValue(xmlName);
                    this.addParameterToMessage(paramMetaData, value, (SOAPElement)soapHeader);
                }
            } else {
                throw new WSException(new StringBuffer().append("Unsupported message style: ").append(style).toString());
            }
            return resMessage;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void unbindResponseMessage(OperationMetaData opMetaData, SOAPMessage resMessage, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders) throws BindingException {
        block20: {
            log.debug((Object)new StringBuffer().append("unbindResponseMessage: ").append(opMetaData.getXmlName()).toString());
            try {
                Object value;
                Object value2;
                ParameterMetaData retMetaData;
                Style style;
                Object value3;
                QName xmlName;
                if (opMetaData.isOneWayOperation()) {
                    return;
                }
                SOAPEnvelope soapEnvelope = resMessage.getSOAPPart().getEnvelope();
                if (soapEnvelope == null) {
                    return;
                }
                SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
                if (msgContext == null) {
                    throw new WSException("MessageContext not available");
                }
                SOAPHeader soapHeader = soapEnvelope.getHeader();
                SOAPBody soapBody = soapEnvelope.getBody();
                Iterator bodyChildren = soapBody.getChildElements();
                SOAPBodyElement soapBodyElement = null;
                if (bodyChildren.hasNext()) {
                    soapBodyElement = (SOAPBodyElement)bodyChildren.next();
                }
                if (soapBodyElement instanceof SOAPFaultImpl) {
                    SOAPFaultImpl soapFault = (SOAPFaultImpl)soapBodyElement;
                    SOAPFaultException faultEx = SOAPFaultExceptionHelper.getSOAPFaultException(soapFault);
                    throw faultEx;
                }
                if (unboundHeaders != null) {
                    HashMap<QName, UnboundHeader> outHeaders = new HashMap<QName, UnboundHeader>();
                    Iterator itHeaderElements = soapHeader.getChildElements();
                    while (itHeaderElements.hasNext()) {
                        SOAPHeaderElementImpl soapHeaderElement = (SOAPHeaderElementImpl)itHeaderElements.next();
                        Name elName = soapHeaderElement.getElementName();
                        xmlName = new QName(elName.getURI(), elName.getLocalName());
                        UnboundHeader unboundHeader = unboundHeaders.get(xmlName);
                        if (unboundHeader == null) continue;
                        soapHeaderElement.setParamMetaData(unboundHeader.toParameterMetaData(opMetaData));
                        value3 = soapHeaderElement.getObjectValue();
                        unboundHeader.setHeaderValue(value3);
                        outHeaders.put(xmlName, unboundHeader);
                    }
                    unboundHeaders.clear();
                    unboundHeaders.putAll(outHeaders);
                }
                if ((style = opMetaData.getStyle()) == Style.RPC) {
                    retMetaData = opMetaData.getReturnParameter();
                    if (retMetaData != null) {
                        if (retMetaData.isSwA()) {
                            value2 = this.getAttachmentFromMessage(retMetaData, resMessage);
                            epInv.setReturnValue(value2);
                        } else {
                            value2 = this.getParameterFromMessage(retMetaData, (SOAPElement)soapBodyElement, false);
                            epInv.setReturnValue(value2);
                        }
                    }
                    for (ParameterMetaData paramMetaData : opMetaData.getOutputParameters()) {
                        xmlName = paramMetaData.getXmlName();
                        if (paramMetaData.isSwA()) {
                            value = this.getAttachmentFromMessage(paramMetaData, resMessage);
                            epInv.setResponseParamValue(xmlName, value);
                            continue;
                        }
                        SOAPHeader soapElement = paramMetaData.isInHeader() ? soapHeader : soapBodyElement;
                        value3 = this.getParameterFromMessage(paramMetaData, (SOAPElement)soapElement, false);
                        epInv.setResponseParamValue(xmlName, value3);
                    }
                    break block20;
                }
                if (style == Style.DOCUMENT) {
                    retMetaData = opMetaData.getReturnParameter();
                    if (retMetaData != null) {
                        if (retMetaData.isSwA()) {
                            value2 = this.getAttachmentFromMessage(retMetaData, resMessage);
                            epInv.setReturnValue(value2);
                        } else {
                            value2 = this.getParameterFromMessage(retMetaData, (SOAPElement)soapBody, false);
                            epInv.setReturnValue(value2);
                        }
                        for (ParameterMetaData paramMetaData : opMetaData.getOutputParameters()) {
                            xmlName = paramMetaData.getXmlName();
                            if (!paramMetaData.isInHeader()) continue;
                            value = this.getParameterFromMessage(paramMetaData, (SOAPElement)soapHeader, false);
                            epInv.setResponseParamValue(xmlName, value);
                        }
                    }
                    break block20;
                }
                throw new WSException(new StringBuffer().append("Unsupported message style: ").append(style).toString());
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private AttachmentPart getAttachmentPart(ParameterMetaData paramMetaData, Object value, CIDGenerator cidGenerator) throws SOAPException, BindingException {
        String partName = paramMetaData.getXmlName().getLocalPart();
        Set<String> mimeTypes = paramMetaData.getMimeTypes();
        AttachmentPartImpl part = new AttachmentPartImpl();
        if (value instanceof DataHandler) {
            DataHandler handler = (DataHandler)value;
            String mimeType = MimeUtils.getBaseMimeType(handler.getContentType());
            if (mimeTypes != null && !MimeUtils.isMemberOf(mimeType, mimeTypes)) {
                throw new BindingException(new StringBuffer().append("Mime type ").append(mimeType).append(" not allowed for parameter ").append(partName).append(" allowed types are ").append(mimeTypes).toString());
            }
            part.setDataHandler((DataHandler)value);
        } else {
            String mimeType = null;
            if (mimeTypes != null && mimeTypes.size() > 0) {
                mimeType = mimeTypes.iterator().next();
            } else {
                if (value instanceof Image) {
                    mimeType = "image/jpeg";
                }
                if (value instanceof Source) {
                    mimeType = "application/xml";
                }
                if (value instanceof String) {
                    mimeType = "text/plain";
                }
                if (value instanceof MimeMultipart) {
                    mimeType = ((MimeMultipart)value).getContentType();
                }
            }
            if (mimeType == null) {
                throw new BindingException(new StringBuffer().append("Could not determine mime type for attachment parameter: ").append(partName).toString());
            }
            part.setContent(value, mimeType);
        }
        if (paramMetaData.isSwA()) {
            String swaCID = new StringBuffer().append("<").append(partName).append("=").append(cidGenerator.generateFromCount()).append(">").toString();
            part.setContentId(swaCID);
        }
        if (paramMetaData.isXOP()) {
            String xopCID = new StringBuffer().append("<").append(cidGenerator.generateFromName(partName)).append(">").toString();
            part.setContentId(xopCID);
        }
        return part;
    }

    private Object getAttachmentFromMessage(ParameterMetaData paramMetaData, SOAPMessage message) throws SOAPException, BindingException {
        QName xmlName = paramMetaData.getXmlName();
        AttachmentPart part = ((SOAPMessageImpl)message).getAttachmentByPartName(xmlName.getLocalPart());
        if (part == null) {
            throw new BindingException(new StringBuffer().append("Could not locate attachment for parameter: ").append(paramMetaData.getXmlName()).toString());
        }
        return part;
    }

    private SOAPContentElement addParameterToMessage(ParameterMetaData paramMetaData, Object value, SOAPElement soapElement) throws SOAPException, BindingException {
        SOAPContentElement contentElement;
        Class<?> valueType;
        QName xmlName = paramMetaData.getXmlName();
        Class javaType = paramMetaData.getJavaType();
        if (value != null && !paramMetaData.isXOP() && !JavaUtils.isAssignableFrom(javaType, valueType = value.getClass())) {
            throw new BindingException(new StringBuffer().append("javaType ").append(javaType.getName()).append(" is not assignable from: ").append(valueType.getName()).toString());
        }
        if (xmlName.getNamespaceURI().length() > 0) {
            SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
            NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
            xmlName = namespaceRegistry.registerQName(xmlName);
        }
        NameImpl soapName = new NameImpl(xmlName.getLocalPart(), xmlName.getPrefix(), xmlName.getNamespaceURI());
        if (paramMetaData.isSOAPArrayParam()) {
            soapName = new NameImpl("Array", "soap11-enc", "http://schemas.xmlsoap.org/soap/encoding/");
        }
        if (soapElement instanceof SOAPHeader) {
            contentElement = new SOAPHeaderElementImpl(soapName);
            soapElement.addChildElement((SOAPElement)contentElement);
        } else {
            Style style = paramMetaData.getOperationMetaData().getStyle();
            if (style == Style.DOCUMENT) {
                contentElement = new SOAPBodyElementDoc(soapName);
                soapElement.addChildElement((SOAPElement)contentElement);
            } else {
                contentElement = new SOAPContentElement(soapName);
                soapElement.addChildElement((SOAPElement)contentElement);
            }
        }
        contentElement.setParamMetaData(paramMetaData);
        if (paramMetaData.isSOAPArrayParam()) {
            contentElement.addNamespaceDeclaration("soap11-enc", "http://schemas.xmlsoap.org/soap/encoding/");
        }
        if (!paramMetaData.isXOP()) {
            contentElement.setObjectValue(value);
        }
        return contentElement;
    }

    private Object getParameterFromMessage(ParameterMetaData paramMetaData, SOAPElement soapElement, boolean optional) throws BindingException {
        NameImpl xmlName = new NameImpl(paramMetaData.getXmlName());
        NameImpl soapArrayName = new NameImpl("Array", "soap11-enc", "http://schemas.xmlsoap.org/soap/encoding/");
        SOAPContentElement soapContentElement = null;
        Iterator childElements = soapElement.getChildElements();
        while (childElements.hasNext()) {
            SOAPContentElement aux;
            Name elName;
            SOAPElementImpl childElement = (SOAPElementImpl)childElements.next();
            if (!(childElement instanceof SOAPContentElement)) {
                childElement = (SOAPContentElement)((Object)soapElement.replaceChild((Node)((Object)new SOAPContentElement(childElement)), (Node)((Object)childElement)));
            }
            if (((Object)xmlName).equals(elName = (aux = (SOAPContentElement)childElement).getElementName())) {
                soapContentElement = aux;
                soapContentElement.setParamMetaData(paramMetaData);
                break;
            }
            if (!((Object)soapArrayName).equals(elName)) continue;
            QName compXMLName = paramMetaData.getXmlName();
            Element compElement = DOMUtils.getFirstChildElement((Node)((Object)aux));
            if (!compElement.getNodeName().equals(compXMLName.getLocalPart())) continue;
            soapContentElement = aux;
            soapContentElement.setParamMetaData(paramMetaData);
            break;
        }
        if (soapContentElement == null) {
            childElements = soapElement.getChildElements();
            OperationMetaData opMetaData = paramMetaData.getOperationMetaData();
            TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
            if (childElements.hasNext() && opMetaData.getStyle() == Style.DOCUMENT) {
                SOAPElementImpl childElement = (SOAPElementImpl)childElements.next();
                SOAPContentElement aux = (SOAPContentElement)childElement;
                Name elName = aux.getElementName();
                QName elType = null;
                XSElementDeclaration xsdElement = typesMetaData.getSchemaModel().getElementDeclaration(elName.getLocalName(), elName.getURI());
                if (xsdElement != null && xsdElement.getTypeDefinition() != null) {
                    XSTypeDefinition xsdType = xsdElement.getTypeDefinition();
                    elType = new QName(xsdType.getNamespace(), xsdType.getName());
                }
                if (paramMetaData.getXmlType().equals(elType)) {
                    soapContentElement = aux;
                    soapContentElement.setParamMetaData(paramMetaData);
                }
            }
        }
        if (soapContentElement == null && !optional) {
            throw new JAXRPCException(new StringBuffer().append("Cannot find child element: ").append(xmlName).toString());
        }
        return soapContentElement;
    }

    private void handleException(Exception ex) throws BindingException {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof BindingException) {
            throw (BindingException)ex;
        }
        throw new BindingException(ex);
    }
}

