/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.binding;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.holders.Holder;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.jaxrpc.ParameterWrapping;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.soap.SOAPContentElement;
import org.jboss.ws.utils.HolderUtils;
import org.jboss.ws.utils.JavaUtils;
import org.jboss.ws.utils.MimeUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointInvocation {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.binding.EndpointInvocation"));
    private OperationMetaData opMetaData;
    private Map<QName, Object> reqPayload = new LinkedHashMap<QName, Object>();
    private Map<QName, Object> resPayload = new LinkedHashMap<QName, Object>();
    private Object returnValue;

    public EndpointInvocation(OperationMetaData opMetaData) {
        this.opMetaData = opMetaData;
    }

    public OperationMetaData getOperationMetaData() {
        return this.opMetaData;
    }

    public Method getJavaMethod() {
        return this.opMetaData.getJavaMethod();
    }

    public List<QName> getRequestParamNames() {
        ArrayList<QName> xmlNames = new ArrayList<QName>();
        xmlNames.addAll(this.reqPayload.keySet());
        return xmlNames;
    }

    public void setRequestParamValue(QName xmlName, Object value) {
        log.debug((Object)new StringBuffer().append("setRequestParamValue: [name=").append(xmlName).append(",value=").append(this.getTypeName(value)).append("]").toString());
        this.reqPayload.put(xmlName, value);
    }

    public Object getRequestParamValue(QName xmlName) throws SOAPException {
        log.debug((Object)new StringBuffer().append("getRequestParamValue: ").append(xmlName).toString());
        Object paramValue = this.reqPayload.get(xmlName);
        ParameterMetaData paramMetaData = this.opMetaData.getParameter(xmlName);
        paramValue = this.transformPayloadValue(paramMetaData, paramValue);
        return paramValue;
    }

    public Object[] getRequestPayload() throws SOAPException {
        log.debug((Object)"getRequestPayload");
        List<QName> xmlNames = this.getRequestParamNames();
        ArrayList<Object> objPayload = new ArrayList<Object>();
        for (int i = 0; i < xmlNames.size(); ++i) {
            QName xmlName = xmlNames.get(i);
            Object paramValue = this.getRequestParamValue(xmlName);
            ParameterMetaData paramMetaData = this.opMetaData.getParameter(xmlName);
            paramValue = this.syncEndpointInputParam(paramMetaData, paramValue);
            if (this.opMetaData.isDocumentWrapped() && !paramMetaData.isInHeader()) {
                List objList = Arrays.asList((Object[])((Object[])paramValue));
                objPayload.addAll(objList);
                continue;
            }
            objPayload.add(paramValue);
        }
        return objPayload.toArray();
    }

    public List<QName> getResponseParamNames() {
        ArrayList<QName> xmlNames = new ArrayList<QName>();
        xmlNames.addAll(this.resPayload.keySet());
        return xmlNames;
    }

    public void setResponseParamValue(QName xmlName, Object value) {
        log.debug((Object)new StringBuffer().append("setResponseParamValue: [name=").append(xmlName).append(",value=").append(this.getTypeName(value)).append("]").toString());
        this.resPayload.put(xmlName, value);
    }

    public Object getResponseParamValue(QName xmlName) throws SOAPException {
        Class valueType;
        log.debug((Object)new StringBuffer().append("getResponseParamValue: ").append(xmlName).toString());
        Object paramValue = this.resPayload.get(xmlName);
        ParameterMetaData paramMetaData = this.opMetaData.getParameter(xmlName);
        paramValue = this.transformPayloadValue(paramMetaData, paramValue);
        if (paramValue != null && HolderUtils.isHolderType(valueType = paramValue.getClass())) {
            valueType = HolderUtils.getValueType(valueType);
            paramValue = HolderUtils.getHolderValue(paramValue);
        }
        return paramValue;
    }

    public void setReturnValue(Object value) {
        ParameterMetaData retMetaData = this.opMetaData.getReturnParameter();
        if (value != null && retMetaData == null) {
            throw new WSException(new StringBuffer().append("Operation does not have a return value: ").append(this.opMetaData.getXmlName()).toString());
        }
        log.debug((Object)new StringBuffer().append("setReturnValue: ").append(this.getTypeName(value)).toString());
        this.returnValue = value;
    }

    public Object getReturnValue() throws SOAPException {
        log.debug((Object)"getReturnValue");
        Object paramValue = this.returnValue;
        ParameterMetaData paramMetaData = this.opMetaData.getReturnParameter();
        if (paramMetaData != null) {
            paramValue = this.transformPayloadValue(paramMetaData, paramValue);
        }
        return paramValue;
    }

    private Object transformPayloadValue(ParameterMetaData paramMetaData, Object paramValue) throws SOAPException {
        QName xmlName = paramMetaData.getXmlName();
        QName xmlType = paramMetaData.getXmlType();
        Class javaType = paramMetaData.getJavaType();
        Object retValue = paramValue;
        if (paramValue instanceof AttachmentPart) {
            AttachmentPart part = (AttachmentPart)paramValue;
            Set<String> mimeTypes = paramMetaData.getMimeTypes();
            if (Class.forName("javax.activation.DataHandler").isAssignableFrom(javaType) && !javaType.equals(Class.forName("java.lang.Object"))) {
                DataHandler handler = part.getDataHandler();
                String mimeType = MimeUtils.getBaseMimeType(handler.getContentType());
                if (mimeTypes != null && !MimeUtils.isMemberOf(mimeType, mimeTypes)) {
                    throw new SOAPException(new StringBuffer().append("Mime type ").append(mimeType).append(" not allowed for parameter ").append(xmlName).append(" allowed types are ").append(mimeTypes).toString());
                }
                retValue = part.getDataHandler();
            } else {
                Class<?> valueType;
                retValue = part.getContent();
                String mimeType = MimeUtils.getBaseMimeType(part.getContentType());
                if (mimeTypes != null && !MimeUtils.isMemberOf(mimeType, mimeTypes)) {
                    throw new SOAPException(new StringBuffer().append("Mime type ").append(mimeType).append(" not allowed for parameter ").append(xmlName).append(" allowed types are ").append(mimeTypes).toString());
                }
                if (retValue != null && !JavaUtils.isAssignableFrom(javaType, valueType = retValue.getClass())) {
                    throw new SOAPException(new StringBuffer().append("javaType [").append(javaType.getName()).append("] is not assignable from attachment content: ").append(valueType.getName()).toString());
                }
            }
        } else if (paramValue instanceof SOAPContentElement && !xmlType.getLocalPart().equals("anyType")) {
            SOAPContentElement soapElement = (SOAPContentElement)paramValue;
            retValue = soapElement.getObjectValue();
        }
        log.debug((Object)new StringBuffer().append("transformPayloadValue: ").append(this.getTypeName(paramValue)).append(" -> ").append(this.getTypeName(retValue)).toString());
        return retValue;
    }

    public void initInputParams(Object[] inputParams) {
        block9: {
            List<ParameterMetaData> paramMetaDataList;
            block8: {
                paramMetaDataList = this.opMetaData.getParameters();
                if (!this.opMetaData.isDocumentWrapped()) break block8;
                Object value = ParameterWrapping.wrapRequestParameters(this.opMetaData, inputParams);
                ParameterMetaData paramMetaData = paramMetaDataList.get(0);
                QName xmlName = paramMetaData.getXmlName();
                this.setRequestParamValue(xmlName, value);
                if (inputParams == null) break block9;
                int wrappedParamsCount = paramMetaData.getWrappedVariables().size();
                int lastParam = Math.min(paramMetaDataList.size() - 1, inputParams.length - wrappedParamsCount);
                for (int i = 0; i < lastParam - 1; ++i) {
                    paramMetaData = paramMetaDataList.get(i + 1);
                    if (!paramMetaData.isInHeader()) continue;
                    xmlName = paramMetaData.getXmlName();
                    Class javaType = paramMetaData.getJavaType();
                    value = inputParams[i + wrappedParamsCount];
                    if (value != null) {
                        Class inputType = value.getClass();
                        if (HolderUtils.isHolderType(inputType)) {
                            inputType = HolderUtils.getValueType(inputType);
                            value = HolderUtils.getHolderValue(value);
                        }
                        if (!(paramMetaData.isSwA() || paramMetaData.isXOP() || JavaUtils.isAssignableFrom(javaType, inputType))) {
                            throw new WSException(new StringBuffer().append("Parameter '").append(javaType).append("' not assignable from: ").append(inputType).toString());
                        }
                    }
                    this.setRequestParamValue(xmlName, value);
                }
                break block9;
            }
            for (int i = 0; i < paramMetaDataList.size(); ++i) {
                ParameterMetaData paramMetaData = paramMetaDataList.get(i);
                QName xmlName = paramMetaData.getXmlName();
                Class javaType = paramMetaData.getJavaType();
                Object value = inputParams[i];
                if (value != null) {
                    Class inputType = value.getClass();
                    if (HolderUtils.isHolderType(inputType)) {
                        inputType = HolderUtils.getValueType(inputType);
                        value = HolderUtils.getHolderValue(value);
                    }
                    if (!(paramMetaData.isSwA() || paramMetaData.isXOP() || JavaUtils.isAssignableFrom(javaType, inputType))) {
                        throw new WSException(new StringBuffer().append("Parameter '").append(javaType).append("' not assignable from: ").append(inputType).toString());
                    }
                }
                this.setRequestParamValue(xmlName, value);
            }
        }
    }

    private Object syncEndpointInputParam(ParameterMetaData paramMetaData, Object paramValue) {
        Object retValue = paramValue;
        Method method = this.opMetaData.getJavaMethod();
        Class<?>[] targetParameterTypes = method.getParameterTypes();
        if (this.opMetaData.isDocumentWrapped()) {
            if (!paramMetaData.isInHeader()) {
                retValue = ParameterWrapping.unwrapRequestParameters(this.opMetaData, paramValue);
            } else if (paramMetaData.getMode() == ParameterMode.INOUT || paramMetaData.getMode() == ParameterMode.OUT) {
                Class javaType = paramMetaData.getJavaType();
                for (int i = 0; i < targetParameterTypes.length; ++i) {
                    Class valueType;
                    Class<?> targetType = targetParameterTypes[i];
                    if (!HolderUtils.isHolderType(targetType) || !JavaUtils.isAssignableFrom(valueType = HolderUtils.getValueType(targetType), javaType)) continue;
                    Holder holder = HolderUtils.getHolderInstance(targetType);
                    HolderUtils.setHolderValue(holder, paramValue);
                    retValue = holder;
                    QName xmlName = paramMetaData.getXmlName();
                    this.setResponseParamValue(xmlName, holder);
                }
            }
        } else {
            Class<?> valueType;
            int paramTypeIndex = this.opMetaData.getParameters().indexOf(paramMetaData);
            Class<?> targetParameterType = targetParameterTypes[paramTypeIndex];
            if (paramMetaData.getMode() == ParameterMode.INOUT || paramMetaData.getMode() == ParameterMode.OUT) {
                Holder holder = HolderUtils.getHolderInstance(targetParameterType);
                HolderUtils.setHolderValue(holder, paramValue);
                retValue = holder;
                QName xmlName = paramMetaData.getXmlName();
                this.setResponseParamValue(xmlName, holder);
            }
            if (JavaUtils.isPrimitive(targetParameterType)) {
                retValue = JavaUtils.getPrimitiveValue(paramValue);
            }
            if (retValue != null && !JavaUtils.isAssignableFrom(targetParameterType, valueType = retValue.getClass())) {
                throw new WSException(new StringBuffer().append("Parameter ").append(targetParameterType.getName()).append(" is not assignable from: ").append(this.getTypeName(retValue)).toString());
            }
        }
        log.debug((Object)new StringBuffer().append("syncEndpointInputParam: ").append(this.getTypeName(paramValue)).append(" -> ").append(this.getTypeName(retValue)).toString());
        return retValue;
    }

    private String getTypeName(Object value) {
        String valueType = value != null ? value.getClass().getName() : null;
        return valueType;
    }
}

