/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.ContextObjectInputStream;
import org.jgroups.util.Range;

public class Util {
    private static Object mutex = new Object();
    private static ByteArrayOutputStream out_stream = new ByteArrayOutputStream(65535);
    protected static Log log = LogFactory.getLog((Class)(class$org$jgroups$util$Util == null ? (class$org$jgroups$util$Util = Util.class$("org.jgroups.util.Util")) : class$org$jgroups$util$Util));
    public static final int MAX_PORT = 65535;
    public static final String DIAG_GROUP = "DIAG_GROUP-BELA-322649";
    static /* synthetic */ Class class$org$jgroups$util$Util;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object objectFromByteBuffer(byte[] buffer) throws Exception {
        Object object = mutex;
        synchronized (object) {
            if (buffer == null) {
                return null;
            }
            Object retval = null;
            ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer);
            ContextObjectInputStream in = new ContextObjectInputStream(in_stream);
            retval = in.readObject();
            in.close();
            if (retval == null) {
                return null;
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToByteBuffer(Object obj) throws Exception {
        byte[] result = null;
        ByteArrayOutputStream byteArrayOutputStream = out_stream;
        synchronized (byteArrayOutputStream) {
            out_stream.reset();
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(obj);
            result = out_stream.toByteArray();
            out.close();
        }
        return result;
    }

    public static void sleep(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sleep(long msecs, boolean busy_sleep) {
        if (!busy_sleep) {
            Util.sleep(msecs);
            return;
        }
        long start = System.currentTimeMillis();
        long stop = start + msecs;
        while (stop > start) {
            start = System.currentTimeMillis();
        }
    }

    public static long random(long range) {
        return (long)(Math.random() * 100000.0 % (double)range) + 1L;
    }

    public static void sleepRandom(long timeout) {
        if (timeout <= 0L) {
            log.error((Object)"timeout must be > 0 !");
            return;
        }
        long r = (int)(Math.random() * 100000.0 % (double)timeout) + 1;
        Util.sleep(r);
    }

    public static boolean tossWeightedCoin(double probability) {
        long cutoff;
        long r = Util.random(100L);
        return r < (cutoff = (long)(probability * 100.0));
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "localhost";
        }
    }

    public static void dumpStack(boolean exit) {
        try {
            throw new Exception("Dumping stack:");
        }
        catch (Exception e) {
            e.printStackTrace();
            if (exit) {
                System.exit(0);
            }
            return;
        }
    }

    public static String printStackTrace(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        t.printStackTrace(p);
        return s.toString();
    }

    public static String getStackTrace(Throwable t) {
        return Util.printStackTrace(t);
    }

    public static String printStackTrace() {
        try {
            throw new Exception("Dumping stack:");
        }
        catch (Throwable t) {
            StringWriter s = new StringWriter();
            PrintWriter p = new PrintWriter(s);
            t.printStackTrace(p);
            return s.toString();
        }
    }

    public static String print(Throwable t) {
        return Util.printStackTrace(t);
    }

    public static void crash() {
        System.exit(-1);
    }

    public static String printEvent(Event evt) {
        Message msg;
        if (evt.getType() == 1 && (msg = (Message)evt.getArg()) != null) {
            if (msg.getLength() > 0) {
                return Util.printMessage(msg);
            }
            return msg.printObjectHeaders();
        }
        return evt.toString();
    }

    public static String printMessage(Message msg) {
        if (msg == null) {
            return "";
        }
        if (msg.getLength() == 0) {
            return null;
        }
        try {
            return msg.getObject().toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String printMethodCall(Message msg) {
        if (msg == null) {
            return "";
        }
        if (msg.getLength() == 0) {
            return "";
        }
        try {
            Object obj = msg.getObject();
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void printThreads() {
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        System.out.println("------- Threads -------");
        for (int i = 0; i < threads.length; ++i) {
            System.out.println("#" + i + ": " + threads[i]);
        }
        System.out.println("------- Threads -------\n");
    }

    public static String activeThreads() {
        StringBuffer sb = new StringBuffer();
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        sb.append("------- Threads -------\n");
        for (int i = 0; i < threads.length; ++i) {
            sb.append("#" + i + ": " + threads[i] + '\n');
        }
        sb.append("------- Threads -------\n");
        return sb.toString();
    }

    public static byte[][] fragmentBuffer(byte[] buf, int frag_size) {
        long total_size = buf.length;
        int accumulated_size = 0;
        int tmp_size = 0;
        int index = 0;
        int num_frags = buf.length % frag_size == 0 ? buf.length / frag_size : buf.length / frag_size + 1;
        byte[][] retval = new byte[num_frags][];
        while ((long)accumulated_size < total_size) {
            tmp_size = (long)(accumulated_size + frag_size) <= total_size ? frag_size : (int)(total_size - (long)accumulated_size);
            byte[] fragment = new byte[tmp_size];
            System.arraycopy(buf, accumulated_size, fragment, 0, tmp_size);
            retval[index++] = fragment;
            accumulated_size += tmp_size;
        }
        return retval;
    }

    public static List computeFragOffsets(int offset, int length, int frag_size) {
        ArrayList<Range> retval = new ArrayList<Range>();
        long total_size = length + offset;
        int index = offset;
        int tmp_size = 0;
        while ((long)index < total_size) {
            tmp_size = (long)(index + frag_size) <= total_size ? frag_size : (int)(total_size - (long)index);
            Range r = new Range(index, tmp_size);
            retval.add(r);
            index += tmp_size;
        }
        return retval;
    }

    public static List computeFragOffsets(byte[] buf, int frag_size) {
        return Util.computeFragOffsets(0, buf.length, frag_size);
    }

    public static byte[] defragmentBuffer(byte[][] fragments) {
        int i;
        int total_length = 0;
        int index = 0;
        if (fragments == null) {
            return null;
        }
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i] == null) continue;
            total_length += fragments[i].length;
        }
        byte[] ret = new byte[total_length];
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i] == null) continue;
            System.arraycopy(fragments[i], 0, ret, index, fragments[i].length);
            index += fragments[i].length;
        }
        return ret;
    }

    public static void printFragments(byte[][] frags) {
        for (int i = 0; i < frags.length; ++i) {
            System.out.println('\'' + new String(frags[i]) + '\'');
        }
    }

    public static String array2String(long[] array) {
        StringBuffer ret = new StringBuffer("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i] + " ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(int[] array) {
        StringBuffer ret = new StringBuffer("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i] + " ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(boolean[] array) {
        StringBuffer ret = new StringBuffer("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i] + " ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static Vector pickSubset(Vector members, double subset_percentage) {
        Vector ret = new Vector();
        int num_mbrs = members.size();
        if (num_mbrs == 0) {
            return ret;
        }
        int subset_size = (int)Math.ceil((double)num_mbrs * subset_percentage);
        Vector tmp_mbrs = (Vector)members.clone();
        for (int i = subset_size; i > 0 && tmp_mbrs.size() > 0; --i) {
            int index = (int)(Math.random() * (double)num_mbrs % (double)tmp_mbrs.size());
            ret.addElement(tmp_mbrs.elementAt(index));
            tmp_mbrs.removeElementAt(index);
        }
        return ret;
    }

    public static Vector determineLeftMembers(Vector old_mbrs, Vector new_mbrs) {
        Vector retval = new Vector();
        if (old_mbrs == null || new_mbrs == null) {
            return retval;
        }
        for (int i = 0; i < old_mbrs.size(); ++i) {
            Object mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            retval.addElement(mbr);
        }
        return retval;
    }

    public static String printMembers(Vector v) {
        StringBuffer sb = new StringBuffer("(");
        boolean first = true;
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                Object el = v.elementAt(i);
                if (el instanceof Address) {
                    sb.append(el);
                    continue;
                }
                sb.append(el);
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public static void doubleWrite(byte[] buf, OutputStream out) throws Exception {
        if (buf.length > 1) {
            out.write(buf, 0, 1);
            out.write(buf, 1, buf.length - 1);
        } else {
            out.write(buf, 0, 0);
            out.write(buf);
        }
    }

    public static long sizeOf(String classname) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Object inst = loader.loadClass(classname).newInstance();
            byte[] data = Util.objectToByteBuffer(inst);
            return data.length;
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("exception=" + ex));
            }
            return 0L;
        }
    }

    public static long sizeOf(Object inst) {
        try {
            byte[] data = Util.objectToByteBuffer(inst);
            return data.length;
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("exception+" + ex));
            }
            return 0L;
        }
    }

    public static boolean sameHost(Address one, Address two) {
        if (one == null || two == null) {
            return false;
        }
        if (!(one instanceof IpAddress) || !(two instanceof IpAddress)) {
            if (log.isErrorEnabled()) {
                log.error((Object)"addresses have to be of type IpAddress to be compared");
            }
            return false;
        }
        InetAddress a = ((IpAddress)one).getIpAddress();
        InetAddress b = ((IpAddress)two).getIpAddress();
        if (a == null || b == null) {
            return false;
        }
        String host_a = a.getHostAddress();
        String host_b = b.getHostAddress();
        return host_a.equals(host_b);
    }

    public static void removeFile(String fname) {
        block3: {
            if (fname == null) {
                return;
            }
            try {
                new File(fname).delete();
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("exception=" + ex));
            }
        }
    }

    public static boolean fileExists(String fname) {
        return new File(fname).exists();
    }

    public static long[] parseCommaDelimitedLongs(String s) {
        Vector<Long> v = new Vector<Long>();
        long[] retval = null;
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            Long l = new Long(tok.nextToken());
            v.addElement(l);
        }
        if (v.size() == 0) {
            return null;
        }
        retval = new long[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            retval[i] = (Long)v.elementAt(i);
        }
        return retval;
    }

    public static List parseCommaDelimitedStrings(String l) {
        ArrayList<String> tmp = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            tmp.add(t);
        }
        return tmp;
    }

    public static String shortName(String hostname) {
        StringBuffer sb = new StringBuffer();
        if (hostname == null) {
            return null;
        }
        int index = hostname.indexOf(46);
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            sb.append(hostname.substring(0, index));
        } else {
            sb.append(hostname);
        }
        return sb.toString();
    }

    public static ServerSocket createServerSocket(int start_port) {
        ServerSocket ret = null;
        while (true) {
            try {
                ret = new ServerSocket(start_port);
            }
            catch (BindException bind_ex) {
                ++start_port;
                continue;
            }
            catch (IOException io_ex) {
                if (!log.isErrorEnabled()) break;
                log.error((Object)("exception is " + io_ex));
            }
            break;
        }
        return ret;
    }

    public static DatagramSocket createDatagramSocket(InetAddress addr, int port) throws Exception {
        DatagramSocket sock = null;
        if (addr == null) {
            if (port == 0) {
                return new DatagramSocket();
            }
            while (port < 65535) {
                try {
                    return new DatagramSocket(port);
                }
                catch (BindException bind_ex) {
                    ++port;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        } else {
            if (port == 0) {
                port = 1024;
            }
            while (port < 65535) {
                try {
                    return new DatagramSocket(port, addr);
                }
                catch (BindException bind_ex) {
                    ++port;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        }
        return sock;
    }

    public static boolean checkForLinux() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("linux");
    }

    public static boolean checkForSolaris() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("sun");
    }

    public static boolean checkForWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("win");
    }

    public static void prompt(String s) {
        System.out.println(s);
        System.out.flush();
        try {
            while (System.in.available() > 0) {
                System.in.read();
            }
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String memStats(boolean gc) {
        StringBuffer sb = new StringBuffer();
        Runtime rt = Runtime.getRuntime();
        if (gc) {
            rt.gc();
        }
        long free_mem = rt.freeMemory();
        long total_mem = rt.totalMemory();
        long used_mem = total_mem - free_mem;
        sb.append("Free mem: ").append(free_mem).append("\nUsed mem: ").append(used_mem);
        sb.append("\nTotal mem: ").append(total_mem);
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("Check for Linux:   " + Util.checkForLinux());
        System.out.println("Check for Solaris: " + Util.checkForSolaris());
        System.out.println("Check for Windows: " + Util.checkForWindows());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

