/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adaptudp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgroups.tests.adaptudp.Request;
import org.jgroups.tests.adaptudp.Test;
import org.jgroups.util.Util;

public class SenderThread
extends Thread {
    private int num_msgs;
    private int msg_size;
    Logger log = Logger.getLogger(this.getClass());
    long log_interval = 1000L;
    boolean gnuplot_output = Boolean.getBoolean("gnuplot_output");
    List nodes;
    DatagramSocket send_sock;

    public SenderThread(DatagramSocket send_sock, int num_msgs, int ms, long log_interval) {
        this.num_msgs = num_msgs;
        this.msg_size = ms;
        this.log_interval = log_interval;
        this.send_sock = send_sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long total_msgs = 0L;
        System.out.println("Sender thread started...");
        try {
            InetAddress mcast_addr = InetAddress.getByName(Test.mcast_addr);
            byte[] msg = new byte[this.msg_size];
            for (int h = 0; h < this.msg_size; ++h) {
                msg[h] = (byte)h;
            }
            System.out.println("Everyone joined, ready to begin test...\n");
            for (int i = 0; i < this.num_msgs; ++i) {
                Request req = new Request(3, msg);
                byte[] buf = Util.objectToByteBuffer(req);
                DatagramPacket p = new DatagramPacket(buf, buf.length, mcast_addr, Test.mcast_port);
                this.send_sock.send(p);
                if (++total_msgs % 1000L == 0L) {
                    System.out.println("++ sent " + total_msgs);
                }
                if (total_msgs % this.log_interval != 0L || this.gnuplot_output || !this.log.isInfoEnabled()) continue;
                this.log.info((Object)this.dumpStats(total_msgs));
            }
            System.out.println("Sent all bursts. Sender terminates.\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String dumpStats(long sent_msgs) {
        StringBuffer sb = new StringBuffer();
        sb.append("\nmsgs_sent=").append(sent_msgs).append('\n');
        sb.append("free_mem=").append(Runtime.getRuntime().freeMemory());
        sb.append(" (total_mem=").append(Runtime.getRuntime().totalMemory()).append(")\n");
        return sb.toString();
    }
}

