/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class StreamTest {
    static Map mappings = new HashMap();
    static int count = 1;

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        BelaOutputStream out = new BelaOutputStream(outstream);
        for (int i = 0; i < 10; ++i) {
            Person p = new Person();
            p.setName("Bela Ban");
            p.setAge(20 + i);
            Address addr = new Address();
            addr.setStreet("1704 Almond Blossom Lane");
            addr.setZip(95124 + i);
            p.setAddr(addr);
            out.writeObject(p);
        }
        byte[] buf = outstream.toByteArray();
        System.out.println("Buffer size: " + buf.length + " bytes");
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        BelaInputStream in = new BelaInputStream(instream);
        while (instream.available() > 0) {
            Object obj = in.readObject();
            System.out.println("obj = " + obj);
        }
    }

    public static class Address
    implements Serializable {
        int zip;
        String street;

        public int getZip() {
            return this.zip;
        }

        public void setZip(int zip) {
            this.zip = zip;
        }

        public String getStreet() {
            return this.street;
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public String toString() {
            return this.street + " / " + this.zip;
        }
    }

    public static class Person
    implements Serializable {
        int age;
        String name;
        Address addr;

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Address getAddr() {
            return this.addr;
        }

        public void setAddr(Address addr) {
            this.addr = addr;
        }

        public String toString() {
            return this.name + " (" + this.age + "), addr=" + this.addr;
        }
    }

    public static class BelaOutputStream
    extends ObjectOutputStream {
        public BelaOutputStream() throws IOException, SecurityException {
        }

        public BelaOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            this.writeInt(count);
            mappings.put(new Integer(count), desc);
            System.out.println("-- writing class descriptor for class " + desc.getName() + ", id=" + count);
            ++count;
        }
    }

    public static class BelaInputStream
    extends ObjectInputStream {
        public BelaInputStream() throws IOException, SecurityException {
        }

        public BelaInputStream(InputStream in) throws IOException {
            super(in);
        }

        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            int id = this.readInt();
            ObjectStreamClass retval = (ObjectStreamClass)mappings.get(new Integer(id));
            System.out.println("-- reading class descriptor for " + retval.getName() + ", id=" + id);
            return retval;
        }
    }
}

