/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FRAG;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.UdpHeader;
import org.jgroups.protocols.VERIFY_SUSPECT;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.IpAddress;

public class MessageSerializationTest {
    static /* synthetic */ Class class$org$jgroups$Message;

    public static void main(String[] args) throws Exception {
        boolean add_headers = false;
        InetAddress addr = InetAddress.getLocalHost();
        int num = 10000;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                MessageSerializationTest.help();
                return;
            }
            if ("-add_headers".equals(args[i])) {
                add_headers = true;
                continue;
            }
            if (!"-num".equals(args[i])) continue;
            num = Integer.parseInt(args[++i]);
        }
        ClassConfigurator.getInstance();
        long start = System.currentTimeMillis();
        for (int i = 0; i < num; ++i) {
            Message m = new Message((Address)new IpAddress(addr, 5555), (Address)new IpAddress(addr, 6666), new byte[256]);
            if (add_headers) {
                MessageSerializationTest.addHeaders(m);
            }
            ByteArrayOutputStream msg_data = new ByteArrayOutputStream();
            ObjectOutputStream msg_out = new ObjectOutputStream(msg_data);
            m.writeExternal(msg_out);
            msg_out.flush();
            msg_out.close();
            byte[] data = msg_data.toByteArray();
            ByteArrayInputStream msg_in_data = new ByteArrayInputStream(data);
            ObjectInputStream msg_in = new ObjectInputStream(msg_in_data);
            Message m2 = (Message)(class$org$jgroups$Message == null ? MessageSerializationTest.class$("org.jgroups.Message") : class$org$jgroups$Message).newInstance();
            m2.readExternal(msg_in);
        }
        long stop = System.currentTimeMillis();
        System.out.println("Serializing and deserializing a message " + num + " times took " + (stop - start) + "ms.");
    }

    static void addHeaders(Message msg) {
        msg.putHeader("UDP", new UdpHeader("MyGroup"));
        msg.putHeader("PING", new PingHeader(1, null));
        msg.putHeader("FD_SOCK", new FD_SOCK.FdHeader());
        msg.putHeader("VERIFY_SUSPECT", new VERIFY_SUSPECT.VerifyHeader());
        msg.putHeader("STABLE", new STABLE.StableHeader());
        msg.putHeader("NAKACK", new NakAckHeader());
        msg.putHeader("UNICAST", new UNICAST.UnicastHeader());
        msg.putHeader("FRAG", new FRAG.FragHeader());
        msg.putHeader("GMS", new GMS.GmsHeader());
    }

    static void help() {
        System.out.println("MessageSerializationTest [-help] [-add_headers] [-num <iterations>]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

