/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;

public class Deadlock2Test
extends TestCase {
    private static boolean DEADLOCK_DETECTION = true;
    private static boolean NO_DEADLOCK_DETECTION = false;
    private String name = "Deadlock2Test";
    private ListenerImpl listener;
    static /* synthetic */ Class class$org$jgroups$tests$Deadlock2Test;

    public Deadlock2Test(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.listener = new ListenerImpl();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.listener = null;
    }

    public void testOneChannel() throws Exception {
        JChannel channel = new JChannel();
        ServerObject serverObject = new ServerObject();
        RpcDispatcher rpcDispatcher = new RpcDispatcher((Channel)channel, (MessageListener)this.listener, (MembershipListener)this.listener, serverObject, DEADLOCK_DETECTION);
        serverObject.setRpcDispatcher(rpcDispatcher);
        channel.connect(this.name);
        Address localAddress = channel.getLocalAddress();
        MethodCall call = new MethodCall("outerMethod", new Object[0], new Class[0]);
        RspList rspList = rpcDispatcher.callRemoteMethods(null, call, 2, 0L);
        Deadlock2Test.assertEquals((int)1, (int)rspList.size());
        Deadlock2Test.assertEquals((Object)"outerMethod[innerMethod]", (Object)rspList.get(localAddress));
        Deadlock2Test.assertTrue((boolean)rspList.isReceived(localAddress));
        Deadlock2Test.assertFalse((boolean)rspList.isSuspected(localAddress));
        channel.disconnect();
        channel.close();
    }

    public void testTwoChannels() throws Exception {
        ServerObject serverObject = null;
        JChannel channel1 = new JChannel();
        serverObject = new ServerObject();
        RpcDispatcher rpcDispatcher1 = new RpcDispatcher((Channel)channel1, (MessageListener)this.listener, (MembershipListener)this.listener, serverObject, DEADLOCK_DETECTION);
        serverObject.setRpcDispatcher(rpcDispatcher1);
        channel1.connect(this.name);
        Address localAddress1 = channel1.getLocalAddress();
        JChannel channel2 = new JChannel();
        serverObject = new ServerObject();
        RpcDispatcher rpcDispatcher2 = new RpcDispatcher((Channel)channel2, (MessageListener)this.listener, (MembershipListener)this.listener, serverObject, DEADLOCK_DETECTION);
        serverObject.setRpcDispatcher(rpcDispatcher2);
        channel2.connect(this.name);
        Address localAddress2 = channel2.getLocalAddress();
        MethodCall call = new MethodCall("outerMethod", new Object[0], new Class[0]);
        Vector<Address> dests = new Vector<Address>();
        dests.add(localAddress2);
        RspList rspList = rpcDispatcher1.callRemoteMethods(dests, call, 2, 0L);
        Deadlock2Test.assertEquals((int)1, (int)rspList.size());
        Deadlock2Test.assertEquals((Object)"outerMethod[innerMethod;innerMethod]", (Object)rspList.get(localAddress1));
        Deadlock2Test.assertTrue((boolean)rspList.isReceived(localAddress1));
        Deadlock2Test.assertFalse((boolean)rspList.isSuspected(localAddress1));
        channel1.disconnect();
        channel1.close();
        channel2.disconnect();
        channel2.close();
    }

    public static Test suite() {
        TestSuite s = new TestSuite(class$org$jgroups$tests$Deadlock2Test == null ? (class$org$jgroups$tests$Deadlock2Test = Deadlock2Test.class$("org.jgroups.tests.Deadlock2Test")) : class$org$jgroups$tests$Deadlock2Test);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)Deadlock2Test.suite());
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ListenerImpl
    implements MessageListener,
    MembershipListener {
        public byte[] getState() {
            return null;
        }

        public void setState(byte[] state) {
        }

        public void receive(Message msg) {
        }

        public void block() {
        }

        public void suspect(Address suspect) {
        }

        public void viewAccepted(View view) {
        }
    }

    public class ServerObject {
        private RpcDispatcher rpcDispatcher;

        public void setRpcDispatcher(RpcDispatcher rpcDispatcher) {
            this.rpcDispatcher = rpcDispatcher;
        }

        public String outerMethod() {
            MethodCall call = new MethodCall("innerMethod", new Object[0], new Class[0]);
            RspList rspList = this.rpcDispatcher.callRemoteMethods(null, call, 2, 0L);
            Vector results = rspList.getResults();
            StringBuffer sb = new StringBuffer("outerMethod[");
            Enumeration e = results.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                sb.append(s);
                if (!e.hasMoreElements()) continue;
                sb.append(";");
            }
            sb.append("]");
            return sb.toString();
        }

        public String innerMethod() {
            return "innerMethod";
        }
    }
}

