/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.protocols.PerfHeader;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolObserver;

class PerfObserver
implements ProtocolObserver {
    String prot_name;
    boolean bottom = false;

    PerfObserver(String prot_name) {
        this.prot_name = prot_name;
    }

    public void setProtocol(Protocol prot) {
        if (prot != null && prot.getDownProtocol() == null) {
            this.bottom = true;
        }
    }

    public boolean up(Event evt, int num_evts) {
        PerfHeader hdr;
        if (evt.getType() == 1 && (hdr = this.getPerfHeader((Message)evt.getArg())) != null) {
            hdr.setReceived(this.prot_name, 1);
            if (this.bottom) {
                hdr.setNetworkReceived();
            }
        }
        return true;
    }

    public boolean passUp(Event evt) {
        PerfHeader hdr;
        if (evt.getType() == 1 && (hdr = this.getPerfHeader((Message)evt.getArg())) != null) {
            hdr.setDone(this.prot_name, 1);
        }
        return true;
    }

    public boolean down(Event evt, int num_evts) {
        PerfHeader hdr;
        if (evt.getType() == 1 && (hdr = this.getPerfHeader((Message)evt.getArg())) != null) {
            hdr.setReceived(this.prot_name, 2);
        }
        return true;
    }

    public boolean passDown(Event evt) {
        PerfHeader hdr;
        if (evt.getType() == 1 && (hdr = this.getPerfHeader((Message)evt.getArg())) != null) {
            hdr.setDone(this.prot_name, 2);
            if (this.bottom) {
                hdr.setNetworkSent();
            }
        }
        return true;
    }

    PerfHeader getPerfHeader(Message m) {
        Header hdr = null;
        if (m == null || (hdr = m.getHeader("PERF")) == null) {
            return null;
        }
        return (PerfHeader)hdr;
    }
}

