/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class FD_PID
extends Protocol {
    Address ping_dest = null;
    int ping_pid = 0;
    Address local_addr = null;
    int local_pid = 0;
    long timeout = 3000L;
    long get_pids_timeout = 3000L;
    long get_pids_retry_timeout = 500L;
    int num_tries = 3;
    Vector members = new Vector();
    Hashtable pids = new Hashtable();
    boolean own_pid_sent = false;
    Vector pingable_mbrs = new Vector();
    Promise get_pids_promise = new Promise();
    boolean got_cache_from_coord = false;
    TimeScheduler timer = null;
    Monitor monitor = null;

    public String getName() {
        return "FD_PID";
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("get_pids_timeout")) != null) {
            this.get_pids_timeout = Long.parseLong(str);
            props.remove("get_pids_timeout");
        }
        if ((str = props.getProperty("num_tries")) != null) {
            this.num_tries = Integer.parseInt(str);
            props.remove("num_tries");
        }
        if (props.size() > 0) {
            System.err.println("FD_PID.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        if (this.stack == null || this.stack.timer == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"TimeScheduler in protocol stack is null (or protocol stack is null)");
            }
            return;
        }
        this.timer = this.stack.timer;
        if (this.monitor != null && !this.monitor.started) {
            this.monitor = null;
        }
        if (this.monitor == null) {
            this.monitor = new Monitor();
            this.timer.add(this.monitor, true);
        }
    }

    public void stop() {
        if (this.monitor != null) {
            this.monitor.stop();
            this.monitor = null;
        }
    }

    public void up(Event evt) {
        FdHeader hdr = null;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header tmphdr = msg.getHeader(this.getName());
                if (tmphdr == null || !(tmphdr instanceof FdHeader)) break;
                hdr = (FdHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 10: {
                        if (hdr.mbr == null) break;
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("[SUSPECT] hdr: " + hdr));
                        }
                        this.passUp(new Event(9, hdr.mbr));
                        this.passDown(new Event(9, hdr.mbr));
                        break;
                    }
                    case 11: {
                        if (this.local_addr != null && this.local_addr.equals(msg.getSrc())) {
                            return;
                        }
                        if (hdr.mbr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"[WHO_HAS_PID] hdr.mbr is null");
                            }
                            return;
                        }
                        if (this.local_addr != null && this.local_addr.equals(hdr.mbr) && this.local_pid > 0) {
                            this.sendIHavePidMessage(msg.getSrc(), hdr.mbr, this.local_pid);
                            return;
                        }
                        if (!this.pids.containsKey(hdr.mbr)) break;
                        this.sendIHavePidMessage(msg.getSrc(), hdr.mbr, (Integer)this.pids.get(hdr.mbr));
                        break;
                    }
                    case 12: {
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("i-have pid: " + hdr.mbr + " --> " + hdr.pid));
                        }
                        if (hdr.mbr == null || hdr.pid <= 0) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"[I_HAVE_PID] hdr.mbr is null or hdr.pid == 0");
                            }
                            return;
                        }
                        if (!this.sameHost(this.local_addr, hdr.mbr)) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)(hdr.mbr + " is not on the same host as I (" + this.local_addr + ", discarding I_HAVE_PID event"));
                            }
                            return;
                        }
                        this.pids.put(hdr.mbr, new Integer(hdr.pid));
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("[" + this.local_addr + "]: the cache is " + this.pids));
                        }
                        if (this.ping_pid > 0 || this.ping_dest == null || !this.pids.containsKey(this.ping_dest)) break;
                        this.ping_pid = (Integer)this.pids.get(this.ping_dest);
                        try {
                            this.start();
                        }
                        catch (Exception ex) {
                            if (!this.log.isWarnEnabled()) break;
                            this.log.warn((Object)("exception when calling start(): " + ex));
                        }
                        break;
                    }
                    case 13: {
                        if (hdr.mbr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"[GET_PIDS]: hdr.mbr == null");
                            }
                            return;
                        }
                        hdr = new FdHeader(14);
                        hdr.pids = (Hashtable)this.pids.clone();
                        msg = new Message(hdr.mbr, null, null);
                        msg.putHeader(this.getName(), hdr);
                        this.passDown(new Event(1, msg));
                        break;
                    }
                    case 14: {
                        if (hdr.pids == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)"[GET_PIDS_RSP]: cache is null");
                            }
                            return;
                        }
                        this.get_pids_promise.setResult(hdr.pids);
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 52: {
                Integer pid = (Integer)evt.getArg();
                if (pid == null) {
                    if (!this.log.isErrorEnabled()) return;
                    this.log.error((Object)"SET_PID did not contain a pid !");
                    return;
                }
                this.local_pid = pid;
                if (!this.log.isInfoEnabled()) return;
                this.log.info((Object)("local_pid=" + this.local_pid));
                return;
            }
            case 6: {
                FD_PID fD_PID = this;
                synchronized (fD_PID) {
                    View v = (View)evt.getArg();
                    this.members.removeAllElements();
                    this.members.addAll(v.getMembers());
                    this.pingable_mbrs.removeAllElements();
                    this.pingable_mbrs.addAll(this.members);
                    this.passDown(evt);
                    if (!this.got_cache_from_coord) {
                        this.getPidsFromCoordinator();
                        this.got_cache_from_coord = true;
                    }
                    if (!this.own_pid_sent) {
                        if (this.local_pid > 0) {
                            this.sendIHavePidMessage(null, this.local_addr, this.local_pid);
                            this.own_pid_sent = true;
                        } else if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)"[VIEW_CHANGE]: local_pid == 0");
                        }
                    }
                    if (this.members != null) {
                        Enumeration e = this.pids.keys();
                        while (e.hasMoreElements()) {
                            Address mbr = (Address)e.nextElement();
                            if (this.members.contains(mbr)) continue;
                            this.pids.remove(mbr);
                        }
                    }
                    Address tmp_ping_dest = this.determinePingDest();
                    this.ping_pid = 0;
                    if (tmp_ping_dest == null) {
                        this.stop();
                        this.ping_dest = null;
                    } else {
                        this.ping_dest = tmp_ping_dest;
                        try {
                            this.start();
                        }
                        catch (Exception ex) {
                            if (!this.log.isWarnEnabled()) return;
                            this.log.warn((Object)("exception when calling start(): " + ex));
                        }
                    }
                    return;
                }
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    void getPidsFromCoordinator() {
        this.get_pids_promise.reset();
        for (int attempts = this.num_tries; attempts > 0; --attempts) {
            Address coord = this.determineCoordinator();
            if (coord != null) {
                if (coord.equals(this.local_addr)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"first member; cache is empty");
                    }
                    return;
                }
                FdHeader hdr = new FdHeader(13);
                hdr.mbr = this.local_addr;
                Message msg = new Message(coord, null, null);
                msg.putHeader(this.getName(), hdr);
                this.passDown(new Event(1, msg));
                Hashtable result = (Hashtable)this.get_pids_promise.getResult(this.get_pids_timeout);
                if (result != null) {
                    this.pids.putAll(result);
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("got cache from " + coord + ": cache is " + this.pids));
                    }
                    return;
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"received null cache; retrying");
                }
            }
            Util.sleep(this.get_pids_retry_timeout);
        }
    }

    void broadcastSuspectMessage(Address suspected_mbr) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("suspecting " + suspected_mbr + " (own address is " + this.local_addr + ')'));
        }
        FdHeader hdr = new FdHeader(10);
        hdr.mbr = suspected_mbr;
        Message suspect_msg = new Message();
        suspect_msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, suspect_msg));
    }

    void broadcastWhoHasPidMessage(Address mbr) {
        if (this.local_addr != null && mbr != null && this.log.isInfoEnabled()) {
            this.log.info((Object)("[" + this.local_addr + "]: who-has " + mbr));
        }
        Message msg = new Message();
        FdHeader hdr = new FdHeader(11);
        hdr.mbr = mbr;
        msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, msg));
    }

    void sendIHavePidMessage(Address dst, Address mbr, int pid) {
        Message msg = new Message(dst, null, null);
        FdHeader hdr = new FdHeader(12);
        hdr.mbr = mbr;
        hdr.pid = pid;
        msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, msg));
    }

    Address determinePingDest() {
        if (this.pingable_mbrs == null || this.pingable_mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        for (int i = 0; i < this.pingable_mbrs.size(); ++i) {
            Address tmp = (Address)this.pingable_mbrs.elementAt(i);
            if (!this.local_addr.equals(tmp)) continue;
            if (i + 1 >= this.pingable_mbrs.size()) {
                return (Address)this.pingable_mbrs.elementAt(0);
            }
            return (Address)this.pingable_mbrs.elementAt(i + 1);
        }
        return null;
    }

    Address determineCoordinator() {
        return this.members.size() > 0 ? (Address)this.members.elementAt(0) : null;
    }

    boolean sameHost(Address one, Address two) {
        if (one == null || two == null) {
            return false;
        }
        if (!(one instanceof IpAddress) || !(two instanceof IpAddress)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"addresses have to be of type IpAddress to be compared");
            }
            return false;
        }
        InetAddress a = ((IpAddress)one).getIpAddress();
        InetAddress b = ((IpAddress)two).getIpAddress();
        if (a == null || b == null) {
            return false;
        }
        String host_a = a.getHostAddress();
        String host_b = b.getHostAddress();
        return host_a.equals(host_b);
    }

    private class Monitor
    implements TimeScheduler.Task {
        boolean started = true;

        private Monitor() {
        }

        void stop() {
            this.started = false;
        }

        public boolean cancelled() {
            return !this.started;
        }

        public long nextInterval() {
            return FD_PID.this.timeout;
        }

        public void run() {
            if (FD_PID.this.ping_dest == null) {
                if (FD_PID.this.log.isWarnEnabled()) {
                    FD_PID.this.log.warn((Object)"ping_dest is null, skipping ping");
                }
                return;
            }
            if (FD_PID.this.log.isInfoEnabled()) {
                FD_PID.this.log.info((Object)("ping_dest=" + FD_PID.this.ping_dest + ", ping_pid=" + FD_PID.this.ping_pid + ", cache=" + FD_PID.this.pids));
            }
            if (FD_PID.this.ping_pid <= 0) {
                if (FD_PID.this.ping_dest != null && FD_PID.this.pids.containsKey(FD_PID.this.ping_dest)) {
                    FD_PID.this.ping_pid = (Integer)FD_PID.this.pids.get(FD_PID.this.ping_dest);
                    if (FD_PID.this.log.isInfoEnabled()) {
                        FD_PID.this.log.info((Object)("found PID for " + FD_PID.this.ping_dest + " in cache (pid=" + FD_PID.this.ping_pid + ')'));
                    }
                } else {
                    if (FD_PID.this.log.isErrorEnabled()) {
                        FD_PID.this.log.error((Object)("PID for " + FD_PID.this.ping_dest + " not known" + ", cache is " + FD_PID.this.pids));
                    }
                    FD_PID.this.broadcastWhoHasPidMessage(FD_PID.this.ping_dest);
                    return;
                }
            }
            if (!Util.fileExists("/proc/" + FD_PID.this.ping_pid)) {
                if (FD_PID.this.log.isInfoEnabled()) {
                    FD_PID.this.log.info((Object)("process " + FD_PID.this.ping_pid + " does not exist"));
                }
                FD_PID.this.broadcastSuspectMessage(FD_PID.this.ping_dest);
                FD_PID.this.pingable_mbrs.removeElement(FD_PID.this.ping_dest);
                FD_PID.this.ping_dest = FD_PID.this.determinePingDest();
                if (FD_PID.this.ping_dest == null) {
                    this.stop();
                }
                FD_PID.this.ping_pid = 0;
            } else if (FD_PID.this.log.isInfoEnabled()) {
                FD_PID.this.log.info((Object)(FD_PID.this.ping_dest + " is alive"));
            }
        }
    }

    public static class FdHeader
    extends Header {
        static final int SUSPECT = 10;
        static final int WHO_HAS_PID = 11;
        static final int I_HAVE_PID = 12;
        static final int GET_PIDS = 13;
        static final int GET_PIDS_RSP = 14;
        int type = 10;
        Address mbr = null;
        int pid = 0;
        Hashtable pids = null;

        public FdHeader() {
        }

        FdHeader(int type) {
            this.type = type;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(FdHeader.type2String(this.type));
            if (this.mbr != null) {
                sb.append(", mbr=" + this.mbr);
            }
            if (this.pid > 0) {
                sb.append(", pid=" + this.pid);
            }
            if (this.pids != null) {
                sb.append(", pids=" + this.pids);
            }
            return sb.toString();
        }

        public static String type2String(int type) {
            switch (type) {
                case 10: {
                    return "SUSPECT";
                }
                case 11: {
                    return "WHO_HAS_PID";
                }
                case 12: {
                    return "I_HAVE_PID";
                }
                case 13: {
                    return "GET_PIDS";
                }
                case 14: {
                    return "GET_PIDS_RSP";
                }
            }
            return "unknown type (" + type + ')';
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeObject(this.mbr);
            out.writeInt(this.pid);
            out.writeObject(this.pids);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.mbr = (Address)in.readObject();
            this.pid = in.readInt();
            this.pids = (Hashtable)in.readObject();
        }
    }
}

