/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.persistence;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.persistence.DBPersistenceManager;
import org.jgroups.persistence.FilePersistenceManager;
import org.jgroups.persistence.PersistenceManager;

public class PersistenceFactory {
    protected Log log = LogFactory.getLog(this.getClass());
    private static PersistenceManager _manager = null;
    private static PersistenceFactory _factory = null;
    static final String propPath = "persist.properties";
    static final String persistProp = "persist";
    static final String filePersistMgr = "filePersistMgr";
    static /* synthetic */ Class class$java$lang$String;

    private PersistenceFactory() {
    }

    public static PersistenceFactory getInstance() {
        System.err.println(" getting factory instance ");
        if (_factory == null) {
            _factory = new PersistenceFactory();
        }
        return _factory;
    }

    public synchronized void registerManager(PersistenceManager manager) {
        _manager = manager;
    }

    public synchronized PersistenceManager createManager() throws Exception {
        if (_manager == null) {
            _manager = this.checkDB() ? this.createManagerDB(propPath) : this.createManagerFile(propPath);
        }
        return _manager;
    }

    public synchronized PersistenceManager createManager(String filePath) throws Exception {
        if (_manager == null) {
            _manager = this.checkDB(filePath) ? this.createManagerDB(filePath) : this.createManagerFile(filePath);
        }
        return _manager;
    }

    private PersistenceManager createManagerDB(String filePath) throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Calling db persist from factory: " + filePath));
        }
        if (_manager == null) {
            _manager = new DBPersistenceManager(filePath);
        }
        return _manager;
    }

    private PersistenceManager createManagerFile(String filePath) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Creating file manager: " + filePath));
        }
        try {
            if (_manager == null) {
                Properties props = this.readProps(filePath);
                String classname = props.getProperty(filePersistMgr);
                if (classname != null) {
                    Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(classname);
                    Constructor<?> ctor = cl.getConstructor(class$java$lang$String == null ? (class$java$lang$String = PersistenceFactory.class$("java.lang.String")) : class$java$lang$String);
                    _manager = (PersistenceManager)ctor.newInstance(filePath);
                } else {
                    _manager = new FilePersistenceManager(filePath);
                }
            }
            return _manager;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private boolean checkDB() throws Exception {
        Properties props = this.readProps(propPath);
        String persist = props.getProperty(persistProp);
        return "DB".equals(persist);
    }

    private boolean checkDB(String filePath) throws Exception {
        Properties props = this.readProps(filePath);
        String persist = props.getProperty(persistProp);
        return "DB".equals(persist);
    }

    Properties readProps(String fileName) throws IOException {
        FileInputStream _stream = new FileInputStream(fileName);
        Properties props = new Properties();
        props.load(_stream);
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

