/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.ViewId;

public class View
implements Externalizable,
Cloneable {
    protected ViewId vid = null;
    protected Vector members = null;

    public View() {
    }

    public View(ViewId vid, Vector members) {
        this.vid = vid;
        this.members = members;
    }

    public View(Address creator, long id, Vector members) {
        this(new ViewId(creator, id), members);
    }

    public ViewId getVid() {
        return this.vid;
    }

    public Address getCreator() {
        return this.vid != null ? this.vid.getCoordAddress() : null;
    }

    public Vector getMembers() {
        return this.members;
    }

    public boolean containsMember(Address mbr) {
        if (mbr == null || this.members == null) {
            return false;
        }
        return this.members.contains(mbr);
    }

    public int size() {
        return this.members == null ? 0 : this.members.size();
    }

    public Object clone() {
        ViewId vid2 = this.vid != null ? (ViewId)this.vid.clone() : null;
        Vector members2 = this.members != null ? (Vector)this.members.clone() : null;
        return new View(vid2, members2);
    }

    public String printDetails() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.vid).append("\n\t");
        if (this.members != null) {
            for (int i = 0; i < this.members.size(); ++i) {
                ret.append(this.members.elementAt(i)).append("\n\t");
            }
            ret.append('\n');
        }
        return ret.toString();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.vid + " " + this.members);
        return ret.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.vid);
        out.writeObject(this.members);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.vid = (ViewId)in.readObject();
        this.members = (Vector)in.readObject();
    }
}

