/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.portlet.MyFacesGenericPortlet;
import org.apache.myfaces.portlet.PortletUtil;
import org.apache.myfaces.util.DebugUtils;

public class LifecycleImpl
extends Lifecycle {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl));
    private List _phaseListenerList = new ArrayList();
    private PhaseListener[] _phaseListenerArray = null;
    static /* synthetic */ Class class$org$apache$myfaces$lifecycle$LifecycleImpl;

    public void execute(FacesContext facesContext) throws FacesException {
        if (this.restoreView(facesContext)) {
            return;
        }
        if (this.applyRequestValues(facesContext)) {
            return;
        }
        if (this.processValidations(facesContext)) {
            return;
        }
        if (this.updateModelValues(facesContext)) {
            return;
        }
        if (this.invokeApplication(facesContext)) {
            return;
        }
    }

    private boolean restoreView(FacesContext facesContext) throws FacesException {
        boolean skipFurtherProcessing = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering restoreView in " + (class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl).getName()));
        }
        this.informPhaseListenersBefore(facesContext, PhaseId.RESTORE_VIEW);
        if (this.isResponseComplete(facesContext, "restoreView", true)) {
            return true;
        }
        if (this.shouldRenderResponse(facesContext, "restoreView", true)) {
            skipFurtherProcessing = true;
        }
        String viewId = LifecycleImpl.deriveViewId(facesContext);
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        UIViewRoot viewRoot = viewHandler.restoreView(facesContext, viewId);
        if (viewRoot == null) {
            viewRoot = viewHandler.createView(facesContext, viewId);
            viewRoot.setViewId(viewId);
            facesContext.renderResponse();
        }
        facesContext.setViewRoot(viewRoot);
        if (facesContext.getExternalContext().getRequestParameterMap().isEmpty()) {
            facesContext.renderResponse();
        }
        LifecycleImpl.recursivelyHandleComponentReferencesAndSetValid(facesContext, (UIComponent)viewRoot);
        this.informPhaseListenersAfter(facesContext, PhaseId.RESTORE_VIEW);
        if (this.isResponseComplete(facesContext, "restoreView", false) || this.shouldRenderResponse(facesContext, "restoreView", false)) {
            skipFurtherProcessing = true;
        }
        if (!skipFurtherProcessing && log.isTraceEnabled()) {
            log.trace((Object)("exiting restoreView in " + (class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl).getName()));
        }
        return skipFurtherProcessing;
    }

    private boolean applyRequestValues(FacesContext facesContext) throws FacesException {
        boolean skipFurtherProcessing = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering applyRequestValues in " + (class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl).getName()));
        }
        this.informPhaseListenersBefore(facesContext, PhaseId.APPLY_REQUEST_VALUES);
        if (this.isResponseComplete(facesContext, "applyRequestValues", true)) {
            return true;
        }
        if (this.shouldRenderResponse(facesContext, "applyRequestValues", true)) {
            skipFurtherProcessing = true;
        }
        facesContext.getViewRoot().processDecodes(facesContext);
        this.informPhaseListenersAfter(facesContext, PhaseId.APPLY_REQUEST_VALUES);
        if (this.isResponseComplete(facesContext, "applyRequestValues", false) || this.shouldRenderResponse(facesContext, "applyRequestValues", false)) {
            skipFurtherProcessing = true;
        }
        if (!skipFurtherProcessing && log.isTraceEnabled()) {
            log.trace((Object)("exiting applyRequestValues in " + (class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl).getName()));
        }
        return skipFurtherProcessing;
    }

    private boolean processValidations(FacesContext facesContext) throws FacesException {
        boolean skipFurtherProcessing = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering processValidations in " + (class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl).getName()));
        }
        this.informPhaseListenersBefore(facesContext, PhaseId.PROCESS_VALIDATIONS);
        if (this.isResponseComplete(facesContext, "processValidations", true)) {
            return true;
        }
        if (this.shouldRenderResponse(facesContext, "processValidations", true)) {
            skipFurtherProcessing = true;
        }
        facesContext.getViewRoot().processValidators(facesContext);
        this.informPhaseListenersAfter(facesContext, PhaseId.PROCESS_VALIDATIONS);
        if (this.isResponseComplete(facesContext, "processValidations", false) || this.shouldRenderResponse(facesContext, "processValidations", false)) {
            skipFurtherProcessing = true;
        }
        if (!skipFurtherProcessing && log.isTraceEnabled()) {
            log.trace((Object)("exiting processValidations in " + (class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl).getName()));
        }
        return skipFurtherProcessing;
    }

    private boolean updateModelValues(FacesContext facesContext) throws FacesException {
        boolean skipFurtherProcessing = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering updateModelValues in " + (class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl).getName()));
        }
        this.informPhaseListenersBefore(facesContext, PhaseId.UPDATE_MODEL_VALUES);
        if (this.isResponseComplete(facesContext, "updateModelValues", true)) {
            return true;
        }
        if (this.shouldRenderResponse(facesContext, "updateModelValues", true)) {
            skipFurtherProcessing = true;
        }
        facesContext.getViewRoot().processUpdates(facesContext);
        this.informPhaseListenersAfter(facesContext, PhaseId.UPDATE_MODEL_VALUES);
        if (this.isResponseComplete(facesContext, "updateModelValues", false) || this.shouldRenderResponse(facesContext, "updateModelValues", false)) {
            skipFurtherProcessing = true;
        }
        if (!skipFurtherProcessing && log.isTraceEnabled()) {
            log.trace((Object)("exiting updateModelValues in " + (class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl).getName()));
        }
        return skipFurtherProcessing;
    }

    private boolean invokeApplication(FacesContext facesContext) throws FacesException {
        boolean skipFurtherProcessing = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering invokeApplication in " + (class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl).getName()));
        }
        this.informPhaseListenersBefore(facesContext, PhaseId.INVOKE_APPLICATION);
        if (this.isResponseComplete(facesContext, "invokeApplication", true)) {
            return true;
        }
        if (this.shouldRenderResponse(facesContext, "invokeApplication", true)) {
            skipFurtherProcessing = true;
        }
        facesContext.getViewRoot().processApplication(facesContext);
        this.informPhaseListenersAfter(facesContext, PhaseId.INVOKE_APPLICATION);
        if (this.isResponseComplete(facesContext, "invokeApplication", false) || this.shouldRenderResponse(facesContext, "invokeApplication", false)) {
            skipFurtherProcessing = true;
        }
        if (!skipFurtherProcessing && log.isTraceEnabled()) {
            log.trace((Object)("exiting invokeApplication in " + (class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl).getName()));
        }
        return skipFurtherProcessing;
    }

    public void render(FacesContext facesContext) throws FacesException {
        if (this.isResponseComplete(facesContext, "render", true)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering renderResponse in " + (class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl).getName()));
        }
        this.informPhaseListenersBefore(facesContext, PhaseId.RENDER_RESPONSE);
        if (this.isResponseComplete(facesContext, "render", true)) {
            return;
        }
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        try {
            viewHandler.renderView(facesContext, facesContext.getViewRoot());
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        this.informPhaseListenersAfter(facesContext, PhaseId.RENDER_RESPONSE);
        if (log.isTraceEnabled()) {
            DebugUtils.traceView("View after rendering");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("exiting renderResponse in " + (class$org$apache$myfaces$lifecycle$LifecycleImpl == null ? (class$org$apache$myfaces$lifecycle$LifecycleImpl = LifecycleImpl.class$("org.apache.myfaces.lifecycle.LifecycleImpl")) : class$org$apache$myfaces$lifecycle$LifecycleImpl).getName()));
        }
    }

    private boolean isResponseComplete(FacesContext facesContext, String phase, boolean before) {
        boolean flag = false;
        if (facesContext.getResponseComplete()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("exiting from lifecycle.execute in " + phase + " because getResponseComplete is true from one of the " + (before ? "before" : "after") + " listeners"));
            }
            flag = true;
        }
        return flag;
    }

    private boolean shouldRenderResponse(FacesContext facesContext, String phase, boolean before) {
        boolean flag = false;
        if (facesContext.getRenderResponse()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("exiting from lifecycle.execute in " + phase + " because getRenderResponse is true from one of the " + (before ? "before" : "after") + " listeners"));
            }
            flag = true;
        }
        return flag;
    }

    private static String deriveViewId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        if (PortletUtil.isPortletRequest(facesContext)) {
            PortletRequest request = (PortletRequest)externalContext.getRequest();
            return request.getParameter(MyFacesGenericPortlet.VIEW_ID);
        }
        String viewId = externalContext.getRequestPathInfo();
        if (viewId == null) {
            viewId = externalContext.getRequestServletPath();
            DebugUtils.assertError(viewId != null, log, "RequestServletPath is null, cannot determine viewId of current page.");
            String defaultSuffix = externalContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            String suffix = defaultSuffix != null ? defaultSuffix : ".jsp";
            DebugUtils.assertError(suffix.charAt(0) == '.', log, "Default suffix must start with a dot!");
            int dot = viewId.lastIndexOf(46);
            if (dot == -1) {
                log.error((Object)("Assumed extension mapping, but there is no extension in " + viewId));
            } else {
                viewId = viewId.substring(0, dot) + suffix;
            }
        }
        return viewId;
    }

    private static void recursivelyHandleComponentReferencesAndSetValid(FacesContext facesContext, UIComponent root) {
        Iterator it = root.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent component = (UIComponent)it.next();
            ValueBinding binding = component.getValueBinding("binding");
            if (binding != null && !binding.isReadOnly(facesContext)) {
                binding.setValue(facesContext, (Object)component);
            }
            if (component instanceof UIInput) {
                ((UIInput)component).setValid(true);
            }
            LifecycleImpl.recursivelyHandleComponentReferencesAndSetValid(facesContext, component);
        }
    }

    public void addPhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException("PhaseListener must not be null.");
        }
        if (this._phaseListenerList == null) {
            this._phaseListenerList = new ArrayList();
            if (this._phaseListenerArray != null) {
                this._phaseListenerList.addAll(Arrays.asList(this._phaseListenerArray));
                this._phaseListenerArray = null;
            }
        }
        this._phaseListenerList.add(phaseListener);
    }

    public void removePhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException("PhaseListener must not be null.");
        }
        if (this._phaseListenerList == null) {
            this._phaseListenerList = new ArrayList();
            if (this._phaseListenerArray != null) {
                this._phaseListenerList.addAll(Arrays.asList(this._phaseListenerArray));
                this._phaseListenerArray = null;
            }
        }
        this._phaseListenerList.remove(phaseListener);
    }

    public PhaseListener[] getPhaseListeners() {
        if (this._phaseListenerArray == null) {
            if (this._phaseListenerList == null) {
                this._phaseListenerArray = new PhaseListener[0];
            } else {
                this._phaseListenerArray = this._phaseListenerList.toArray(new PhaseListener[this._phaseListenerList.size()]);
                this._phaseListenerList = null;
            }
        }
        return this._phaseListenerArray;
    }

    private void informPhaseListenersBefore(FacesContext facesContext, PhaseId phaseId) {
        PhaseListener[] phaseListeners = this.getPhaseListeners();
        for (int i = 0; i < phaseListeners.length; ++i) {
            PhaseListener phaseListener = phaseListeners[i];
            int listenerPhaseId = phaseListener.getPhaseId().getOrdinal();
            if (listenerPhaseId != PhaseId.ANY_PHASE.getOrdinal() && listenerPhaseId != phaseId.getOrdinal()) continue;
            phaseListener.beforePhase(new PhaseEvent(facesContext, phaseId, (Lifecycle)this));
        }
    }

    private void informPhaseListenersAfter(FacesContext facesContext, PhaseId phaseId) {
        PhaseListener[] phaseListeners = this.getPhaseListeners();
        for (int i = 0; i < phaseListeners.length; ++i) {
            PhaseListener phaseListener = phaseListeners[i];
            int listenerPhaseId = phaseListener.getPhaseId().getOrdinal();
            if (listenerPhaseId != PhaseId.ANY_PHASE.getOrdinal() && listenerPhaseId != phaseId.getOrdinal()) continue;
            phaseListener.afterPhase(new PhaseEvent(facesContext, phaseId, (Lifecycle)this));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

