/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transaction;

import java.util.Vector;
import org.jacorb.transaction.Sleeper;
import org.jacorb.transaction.TransactionService;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.ControlOperations;
import org.omg.CosTransactions.ControlPOATie;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.CoordinatorOperations;
import org.omg.CosTransactions.CoordinatorPOATie;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TerminatorHelper;
import org.omg.CosTransactions.TerminatorOperations;
import org.omg.CosTransactions.TerminatorPOATie;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.Vote;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class CoordinatorImpl
implements Sleeper,
CoordinatorOperations,
ControlOperations,
TerminatorOperations {
    private Terminator term_ref;
    private TerminatorPOATie term_skel;
    private Coordinator coord_ref;
    private CoordinatorPOATie coord_skel;
    private Control contr_ref;
    private ControlPOATie contr_skel;
    private int transaction_id;
    private int hash_code;
    private int status;
    private String stat_semaphore;
    private Vector resources;
    private Vector votes;
    private Vector syncs;
    private POA poa;

    CoordinatorImpl(POA _poa, int _trans_id, int _hash_code, int time) {
        this.transaction_id = _trans_id;
        this.hash_code = _hash_code;
        this.poa = _poa;
        this.stat_semaphore = new String("sss");
        this.resources = new Vector();
        this.syncs = new Vector();
        this.votes = new Vector();
        try {
            this.coord_skel = new CoordinatorPOATie(this);
            this.coord_ref = CoordinatorHelper.narrow(this.poa.servant_to_reference(this.coord_skel));
            this.term_skel = new TerminatorPOATie(this);
            this.term_ref = TerminatorHelper.narrow(this.poa.servant_to_reference(this.term_skel));
            this.contr_skel = new ControlPOATie(this);
            this.contr_ref = ControlHelper.narrow(this.poa.servant_to_reference(this.contr_skel));
        }
        catch (ServantNotActive esn) {
            throw new INTERNAL();
        }
        catch (WrongPolicy ew) {
            throw new INTERNAL();
        }
        this.status = 0;
        if (time != 0) {
            TransactionService.get_timer().add_channel(this, time);
        }
    }

    private void destroy() {
        try {
            byte[] oid = this.poa.reference_to_id(this.term_ref);
            this.poa.deactivate_object(oid);
            this.term_ref._release();
            oid = this.poa.reference_to_id(this.coord_ref);
            this.poa.deactivate_object(oid);
            this.coord_ref._release();
            oid = this.poa.reference_to_id(this.contr_ref);
            this.poa.deactivate_object(oid);
            this.contr_ref._release();
        }
        catch (ObjectNotActive esn) {
            throw new INTERNAL();
        }
        catch (WrongPolicy ew) {
            throw new INTERNAL();
        }
        catch (WrongAdapter ew) {
            throw new INTERNAL();
        }
        TransactionService.release_coordinator(this.hash_code);
    }

    private boolean move_to_state(int new_status) {
        String string = this.stat_semaphore;
        synchronized (string) {
            switch (this.status) {
                case 0: {
                    switch (new_status) {
                        case 1: 
                        case 7: 
                        case 9: {
                            this.status = new_status;
                            return true;
                        }
                    }
                    return false;
                }
                case 1: {
                    switch (new_status) {
                        case 9: {
                            this.status = new_status;
                            return true;
                        }
                    }
                    return false;
                }
                case 2: {
                    switch (new_status) {
                        case 8: {
                            this.status = new_status;
                            return true;
                        }
                    }
                    return false;
                }
                case 3: {
                    switch (new_status) {
                        case 6: {
                            this.status = new_status;
                            return true;
                        }
                    }
                    return false;
                }
                case 4: {
                    switch (new_status) {
                        case 6: {
                            this.status = new_status;
                            return true;
                        }
                    }
                    return false;
                }
                case 5: {
                    throw new INTERNAL();
                }
                case 6: {
                    throw new INTERNAL();
                }
                case 7: {
                    switch (new_status) {
                        case 2: 
                        case 9: {
                            this.status = new_status;
                            return true;
                        }
                    }
                    return false;
                }
                case 8: {
                    switch (new_status) {
                        case 3: {
                            this.status = new_status;
                            return true;
                        }
                    }
                    return false;
                }
                case 9: {
                    switch (new_status) {
                        case 4: {
                            this.status = new_status;
                            return true;
                        }
                    }
                    return false;
                }
            }
            throw new INTERNAL();
        }
    }

    public void wakeup() {
        TransactionService.get_timer().kill_channel(this);
        if (this.move_to_state(9)) {
            this.rolling_to_back();
        }
    }

    int _get_transaction_id() {
        return this.transaction_id;
    }

    Control _get_control() {
        return this.contr_ref;
    }

    public Status get_status() {
        return Status.from_int(this.status);
    }

    public Status get_parent_status() {
        throw new NO_IMPLEMENT();
    }

    public Status get_top_level_status() {
        return Status.from_int(this.status);
    }

    public boolean is_same_transaction(Coordinator tc) {
        return this.hash_code == tc.hash_transaction();
    }

    public boolean is_related_transaction(Coordinator tc) {
        throw new NO_IMPLEMENT();
    }

    public boolean is_ancestor_transaction(Coordinator tc) {
        throw new NO_IMPLEMENT();
    }

    public boolean is_descendant_transaction(Coordinator tc) {
        throw new NO_IMPLEMENT();
    }

    public boolean is_top_level_transaction() {
        return true;
    }

    public int hash_transaction() {
        return this.hash_code;
    }

    public int hash_top_level_tran() {
        throw new NO_IMPLEMENT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryCoordinator register_resource(Resource r) throws Inactive {
        String string = this.stat_semaphore;
        synchronized (string) {
            if (this.status == 1) {
                throw new TRANSACTION_ROLLEDBACK();
            }
            if (this.status != 0) {
                throw new Inactive();
            }
            this.resources.addElement(r);
            this.votes.addElement(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_synchronization(Synchronization sync) throws Inactive, SynchronizationUnavailable {
        String string = this.stat_semaphore;
        synchronized (string) {
            if (this.status == 1) {
                throw new TRANSACTION_ROLLEDBACK();
            }
            if (this.status != 0) {
                throw new Inactive();
            }
            this.syncs.addElement(sync);
        }
    }

    public void register_subtran_aware(SubtransactionAwareResource r) throws Inactive, NotSubtransaction {
        throw new NO_IMPLEMENT();
    }

    public void rollback_only() throws Inactive {
        if (!this.move_to_state(1)) {
            throw new Inactive();
        }
    }

    public String get_transaction_name() {
        return "Transaction_" + this.transaction_id;
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable, Inactive {
        throw new NO_IMPLEMENT();
    }

    public PropagationContext get_txcontext() throws Unavailable {
        throw new NO_IMPLEMENT();
    }

    public Terminator get_terminator() throws Unavailable {
        if (this.status == 6) {
            throw new Unavailable();
        }
        return this.term_ref;
    }

    public Coordinator get_coordinator() throws Unavailable {
        if (this.status == 6) {
            throw new Unavailable();
        }
        return this.coord_ref;
    }

    private void forget() {
        this.resources.removeAllElements();
        this.votes.removeAllElements();
        this.syncs.removeAllElements();
    }

    public void commit(boolean report_heuristics) throws HeuristicMixed, HeuristicHazard {
        int i;
        if (!this.move_to_state(7)) {
            if (this.move_to_state(9)) {
                TransactionService.get_timer().kill_channel(this);
                this.rolling_to_back();
                throw new TRANSACTION_ROLLEDBACK();
            }
            throw new INTERNAL();
        }
        TransactionService.get_timer().kill_channel(this);
        for (i = 0; i < this.syncs.size(); ++i) {
            Synchronization sync = (Synchronization)this.syncs.elementAt(i);
            sync.before_completion();
        }
        if (this.resources.size() == 1) {
            Resource r = (Resource)this.resources.elementAt(0);
            try {
                r.commit_one_phase();
            }
            catch (TRANSACTION_ROLLEDBACK tr) {
                this.votes.setElementAt(Vote.VoteRollback, 0);
                this.rollback();
                throw new TRANSACTION_ROLLEDBACK();
            }
            catch (HeuristicHazard hh) {
                throw new NO_IMPLEMENT();
            }
            this.votes.setElementAt(Vote.VoteCommit, 0);
            if (!this.move_to_state(2)) {
                throw new INTERNAL();
            }
            if (!this.move_to_state(8)) {
                throw new INTERNAL();
            }
        } else {
            Vote v;
            Resource r;
            for (i = 0; i < this.resources.size(); ++i) {
                r = (Resource)this.resources.elementAt(i);
                try {
                    v = r.prepare();
                    this.votes.setElementAt(v, i);
                    if (v.value() != 1) continue;
                    this.rollback();
                    throw new TRANSACTION_ROLLEDBACK();
                }
                catch (HeuristicHazard hh) {
                    throw new NO_IMPLEMENT();
                }
                catch (HeuristicMixed hm) {
                    throw new NO_IMPLEMENT();
                }
            }
            if (!this.move_to_state(2)) {
                throw new INTERNAL();
            }
            if (!this.move_to_state(8)) {
                throw new INTERNAL();
            }
            for (i = 0; i < this.resources.size(); ++i) {
                r = (Resource)this.resources.elementAt(i);
                v = (Vote)this.votes.elementAt(i);
                try {
                    if (v == null) {
                        throw new INTERNAL();
                    }
                    if (v.value() != 0) continue;
                    r.commit();
                    continue;
                }
                catch (NotPrepared np) {
                    throw new NO_IMPLEMENT();
                }
                catch (HeuristicRollback hr) {
                    throw new NO_IMPLEMENT();
                }
                catch (HeuristicHazard hh) {
                    throw new NO_IMPLEMENT();
                }
                catch (HeuristicMixed hm) {
                    throw new NO_IMPLEMENT();
                }
            }
        }
        if (!this.move_to_state(3)) {
            throw new INTERNAL();
        }
        this.forget();
        if (!this.move_to_state(6)) {
            throw new INTERNAL();
        }
        this.destroy();
    }

    private void rolling_to_back() {
        for (int i = 0; i < this.resources.size(); ++i) {
            Resource r = (Resource)this.resources.elementAt(i);
            Vote v = (Vote)this.votes.elementAt(i);
            try {
                if (v == null) {
                    r.rollback();
                    continue;
                }
                if (v.value() != 0) continue;
                r.rollback();
                continue;
            }
            catch (HeuristicCommit hc) {
                throw new NO_IMPLEMENT();
            }
            catch (HeuristicMixed hm) {
                throw new NO_IMPLEMENT();
            }
            catch (HeuristicHazard hh) {
                throw new NO_IMPLEMENT();
            }
        }
        if (!this.move_to_state(4)) {
            throw new INTERNAL();
        }
        this.forget();
        if (!this.move_to_state(6)) {
            throw new INTERNAL();
        }
        this.destroy();
    }

    public void rollback() {
        if (!this.move_to_state(9)) {
            throw new TRANSACTION_REQUIRED();
        }
        TransactionService.get_timer().kill_channel(this);
        this.rolling_to_back();
    }
}

