/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.test;

import java.util.Random;
import org.omg.CORBA.ORB;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupPackage.SpecifiedProps;
import org.omg.CosTrading.OfferIteratorHolder;
import org.omg.CosTrading.OfferSeqHolder;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.PolicyNameSeqHolder;

public class ImportThread
extends Thread {
    private static final int TOTAL_QUERIES = 100;
    private static final int MAX_SLEEP = 10;
    private static long m_received_queries = 0L;
    private static Random m_rand = new Random();
    private Lookup[] m_lookup;
    private String m_type;
    private ORB m_orb;
    public int m_correct_results = 0;
    public int m_incorrect_results = 0;

    public ImportThread(String name, Lookup[] lookup, String type, ORB orb) {
        super(name);
        this.m_lookup = lookup;
        this.m_type = type;
        this.m_orb = orb;
        this.start();
    }

    public void run() {
        Policy[] _policies = new Policy[3];
        _policies[0] = new Policy();
        _policies[0].name = "exact_type_match";
        _policies[0].value = this.m_orb.create_any();
        _policies[0].value.insert_boolean(false);
        _policies[1] = new Policy();
        _policies[1].name = "use_dynamic_properties";
        _policies[1].value = this.m_orb.create_any();
        _policies[1].value.insert_boolean(false);
        _policies[2] = new Policy();
        _policies[2].name = "use_proxy_offers";
        _policies[2].value = this.m_orb.create_any();
        _policies[2].value.insert_boolean(false);
        for (int _i = 0; _i < 100; ++_i) {
            try {
                String _constraint = "TRUE";
                String _preference = "";
                SpecifiedProps _desired_props = new SpecifiedProps();
                OfferSeqHolder _offers = new OfferSeqHolder();
                OfferIteratorHolder _iter = new OfferIteratorHolder();
                PolicyNameSeqHolder _limits = new PolicyNameSeqHolder();
                int n = Math.abs(m_rand.nextInt() % 4);
                this.m_lookup[n].query(this.m_type, _constraint, _preference, _policies, _desired_props, 20, _offers, _iter, _limits);
                boolean[] _offer_ok = new boolean[8];
                if (_offers.value != null && _offers.value.length == 8) {
                    int _j;
                    for (_j = 0; _j < 8; ++_j) {
                        _offer_ok[_j] = false;
                    }
                    for (_j = 0; _j < 8; ++_j) {
                        String _name = _offers.value[_j].properties[0].value.extract_string();
                        _offer_ok[Integer.parseInt((String)_name)] = true;
                    }
                    boolean _result = true;
                    for (int _j2 = 0; _j2 < 8; ++_j2) {
                        _result &= _offer_ok[_j2];
                    }
                    System.out.println("(" + m_received_queries++ + " / " + _i + ") Thread " + this.getName() + " received a correct result");
                    ++this.m_correct_results;
                } else {
                    System.out.println("(" + m_received_queries++ + " / " + _i + ") Thread " + this.getName() + " received an incorrect result");
                    System.out.println("Reason: only " + _offers.value.length + " offers instead of 8 received");
                    ++this.m_incorrect_results;
                }
                ImportThread.sleep(Math.abs(m_rand.nextInt() % 10));
                continue;
            }
            catch (Exception _e) {
                System.out.println("(" + m_received_queries++ + " / " + _i + ") Thread " + this.getName() + " caught an exception");
                _e.printStackTrace();
                ++this.m_incorrect_results;
            }
        }
        System.out.println("(" + this.getName() + ") Finished querying. Received " + this.m_correct_results + "correct results and " + this.m_incorrect_results + " incorrect results");
    }
}

