/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.jacorb.trading.test.OutputForwarder;
import org.omg.CORBA.ORB;
import org.omg.CosTrading.FollowOption;
import org.omg.CosTrading.InvalidLookupRef;
import org.omg.CosTrading.Link;
import org.omg.CosTrading.LinkHelper;
import org.omg.CosTrading.LinkPackage.DefaultFollowTooPermissive;
import org.omg.CosTrading.LinkPackage.DuplicateLinkName;
import org.omg.CosTrading.LinkPackage.IllegalLinkName;
import org.omg.CosTrading.LinkPackage.LimitingFollowTooPermissive;
import org.omg.CosTrading.LinkPackage.LinkInfo;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;

public class ExceptionTest {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: ExceptionTest <ior-file>");
            System.exit(0);
        }
        int _correct_results = 0;
        int _incorrect_results = 0;
        try {
            Link _link;
            Runtime _rt = Runtime.getRuntime();
            new OutputForwarder(_rt.exec("ts " + args[0] + " -d db"), "Trader");
            System.out.println("Press any key when Trader is ready");
            System.in.read();
            ORB _orb = ORB.init(args, null);
            BufferedReader _ior_in = new BufferedReader(new FileReader(new File(args[0])));
            String _ior_str = _ior_in.readLine();
            _ior_in.close();
            Lookup _lookup = LookupHelper.narrow(_orb.string_to_object(_ior_str));
            if (_lookup == null) {
                System.out.println("No lookup!");
                System.exit(1);
            }
            if ((_link = LinkHelper.narrow(_lookup.link_if())) == null) {
                System.out.println("No link!");
                System.exit(1);
            }
            System.out.println("********** Testing exceptions **********");
            try {
                System.out.println("\nExpecting IllegalLinkName");
                _link.add_link("", _lookup, FollowOption.if_no_local, FollowOption.if_no_local);
            }
            catch (Exception _e) {
                System.out.println("Caught " + _e.toString());
                if (_e instanceof IllegalLinkName) {
                    System.out.println("Test passed");
                    ++_correct_results;
                }
                System.out.println("Test failed");
                ++_incorrect_results;
            }
            try {
                _link.add_link("link", _lookup, FollowOption.if_no_local, FollowOption.if_no_local);
                System.out.println("\nExpecting DuplicateLinkName");
                _link.add_link("link", _lookup, FollowOption.if_no_local, FollowOption.if_no_local);
            }
            catch (Exception _e) {
                System.out.println("Caught " + _e.toString());
                if (_e instanceof DuplicateLinkName) {
                    System.out.println("Test passed");
                    ++_correct_results;
                }
                System.out.println("Test failed");
                ++_incorrect_results;
            }
            try {
                System.out.println("\nExpecting InvalidLookupRef");
                _link.add_link("link2", null, FollowOption.if_no_local, FollowOption.if_no_local);
            }
            catch (Exception _e) {
                System.out.println("Caught " + _e.toString());
                if (_e instanceof InvalidLookupRef) {
                    System.out.println("Test passed");
                    ++_correct_results;
                }
                System.out.println("Test failed");
                ++_incorrect_results;
            }
            try {
                System.out.println("\nExpecting DefaultFollowTooPermissive");
                _link.add_link("link3", _lookup, FollowOption.if_no_local, FollowOption.local_only);
            }
            catch (Exception _e) {
                System.out.println("Caught " + _e.toString());
                if (_e instanceof DefaultFollowTooPermissive) {
                    System.out.println("Test passed");
                    ++_correct_results;
                }
                System.out.println("Test failed");
                ++_incorrect_results;
            }
            try {
                System.out.println("\nExpecting LimitingFollowTooPermissive");
                _link.add_link("link4", _lookup, FollowOption.if_no_local, FollowOption.always);
            }
            catch (Exception _e) {
                System.out.println("Caught " + _e.toString());
                if (_e instanceof LimitingFollowTooPermissive) {
                    System.out.println("Test passed");
                    ++_correct_results;
                }
                System.out.println("Test failed");
                ++_incorrect_results;
            }
            try {
                _link.add_link("link5", _lookup, FollowOption.if_no_local, FollowOption.if_no_local);
                _link.modify_link("link5", FollowOption.local_only, FollowOption.local_only);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("\n********** Testing link modification **********");
            LinkInfo _info = _link.describe_link("link5");
            if (_info.def_pass_on_follow_rule.value() == FollowOption.local_only.value() && _info.limiting_follow_rule.value() == FollowOption.local_only.value()) {
                System.out.println("Test passed");
                ++_correct_results;
            } else {
                System.out.println("Test failed");
                ++_incorrect_results;
            }
            System.out.println("\n********** Testing link removing **********");
            try {
                _link.add_link("link6", _lookup, FollowOption.if_no_local, FollowOption.if_no_local);
                _link.remove_link("link");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String[] _links_names = _link.list_links();
            boolean _failed = false;
            for (int i = 0; i < _links_names.length; ++i) {
                if (!_links_names[i].equals("link")) continue;
                _failed = true;
            }
            if (!_failed) {
                System.out.println("Test passed");
                ++_correct_results;
            } else {
                System.out.println("Test failed");
                ++_incorrect_results;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\n********** Testing finished **********");
        System.out.println("Total tests: " + (_correct_results + _incorrect_results));
        System.out.println("Correct results: " + _correct_results);
        System.out.println("Incorrect results: " + _incorrect_results);
        System.exit(0);
    }
}

