/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Hashtable;
import org.jacorb.trading.constraint.PropertySchema;
import org.jacorb.trading.constraint.ValueType;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class SchemaAdapter
implements PropertySchema {
    private Hashtable m_props;
    private TypeStruct m_type;

    private SchemaAdapter() {
    }

    public SchemaAdapter(TypeStruct ts) {
        this.m_type = ts;
        this.m_props = new Hashtable();
        try {
            for (int i = 0; i < ts.props.length; ++i) {
                PropStruct ps = ts.props[i];
                boolean seq = false;
                TCKind kind = ps.value_type.kind();
                if (kind == TCKind.tk_sequence) {
                    seq = true;
                    TypeCode tc = ps.value_type.content_type();
                    kind = tc.kind();
                }
                int id = this.convertKind(kind);
                ValueType type = new ValueType(id, seq);
                this.m_props.put(ts.props[i].name, type);
            }
        }
        catch (BadKind e) {
            throw new RuntimeException();
        }
    }

    public boolean exists(String property) {
        return this.m_props.containsKey(property);
    }

    public ValueType getPropertyType(String property) {
        return (ValueType)this.m_props.get(property);
    }

    protected int convertKind(TCKind kind) {
        int result;
        switch (kind.value()) {
            case 2: {
                result = 1;
                break;
            }
            case 3: {
                result = 3;
                break;
            }
            case 4: {
                result = 2;
                break;
            }
            case 5: {
                result = 4;
                break;
            }
            case 6: {
                result = 5;
                break;
            }
            case 7: {
                result = 6;
                break;
            }
            case 8: {
                result = 0;
                break;
            }
            case 9: {
                result = 7;
                break;
            }
            case 18: {
                result = 8;
                break;
            }
            default: {
                result = 9;
            }
        }
        return result;
    }
}

