/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jacorb.trading.db.TypeDatabase;
import org.omg.CORBA.Contained;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.Repository;
import org.omg.CORBA.SystemException;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPOA;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.AlreadyMasked;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.DuplicateServiceTypeName;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.HasSubTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.IncarnationNumber;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.InterfaceTypeMismatch;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.ListOption;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.NotMasked;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.ServiceTypeExists;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.ValueTypeRedefinition;

public class RepositoryImpl
extends ServiceTypeRepositoryPOA {
    private TypeDatabase m_database;
    private Repository m_interfaceRepos;

    public RepositoryImpl(TypeDatabase db, Repository interfaceRepos) {
        this.m_database = db;
        this.m_interfaceRepos = interfaceRepos;
    }

    public IncarnationNumber incarnation() {
        this.m_database.begin(0);
        IncarnationNumber result = this.m_database.getIncarnation();
        this.m_database.end();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncarnationNumber add_type(String name, String if_name, PropStruct[] props, String[] super_types) throws IllegalServiceType, ServiceTypeExists, InterfaceTypeMismatch, IllegalPropertyName, DuplicatePropertyName, ValueTypeRedefinition, UnknownServiceType, DuplicateServiceTypeName {
        IncarnationNumber result = null;
        try {
            int i;
            this.m_database.begin(1);
            this.checkTypeName(name);
            if (this.m_database.describeType(name) != null) {
                throw new ServiceTypeExists(name);
            }
            Hashtable<String, TypeStruct> typeInfo = new Hashtable<String, TypeStruct>();
            for (i = 0; i < super_types.length; ++i) {
                TypeStruct ts = this.findType(super_types[i]);
                if (typeInfo.containsKey(super_types[i])) {
                    throw new DuplicateServiceTypeName(super_types[i]);
                }
                typeInfo.put(super_types[i], ts);
            }
            for (i = 0; i < super_types.length; ++i) {
                String[] names = this.m_database.getAllSuperTypes(super_types[i]);
                for (int n = 0; n < names.length; ++n) {
                    if (typeInfo.containsKey(names[n])) continue;
                    TypeStruct ts = this.findType(names[n]);
                    if (ts == null) {
                        throw new UnknownServiceType(names[n]);
                    }
                    typeInfo.put(names[n], ts);
                }
            }
            this.validateInterface(name, if_name, super_types, typeInfo);
            this.validateProperties(name, props, super_types, typeInfo);
            result = this.m_database.createType(name, if_name, props, super_types);
        }
        finally {
            this.m_database.end();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_type(String name) throws IllegalServiceType, UnknownServiceType, HasSubTypes {
        try {
            this.m_database.begin(1);
            this.checkTypeName(name);
            String subTypeName = this.m_database.findSubType(name);
            if (subTypeName != null) {
                throw new HasSubTypes(name, subTypeName);
            }
            if (!this.m_database.removeType(name)) {
                throw new UnknownServiceType(name);
            }
        }
        finally {
            this.m_database.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list_types(SpecifiedServiceTypes which_types) {
        String[] result = null;
        try {
            this.m_database.begin(0);
            if (which_types.discriminator() == ListOption.all) {
                result = this.m_database.getTypes();
            } else {
                IncarnationNumber inc = which_types.incarnation();
                result = this.m_database.getTypesSince(inc);
            }
        }
        finally {
            this.m_database.end();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeStruct describe_type(String name) throws IllegalServiceType, UnknownServiceType {
        TypeStruct result;
        try {
            this.m_database.begin(0);
            this.checkTypeName(name);
            result = this.findType(name);
        }
        finally {
            this.m_database.end();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeStruct fully_describe_type(String name) throws IllegalServiceType, UnknownServiceType {
        TypeStruct result = null;
        try {
            this.m_database.begin(0);
            this.checkTypeName(name);
            result = this.findType(name);
            String[] superTypeNames = this.m_database.getAllSuperTypes(name);
            result.super_types = superTypeNames;
            Vector<TypeStruct> desc = new Vector<TypeStruct>();
            for (int i = 0; i < superTypeNames.length; ++i) {
                TypeStruct ts = this.findType(superTypeNames[i]);
                desc.addElement(ts);
            }
            Vector<PropStruct> props = new Vector<PropStruct>();
            for (int i = 0; i < result.props.length; ++i) {
                props.addElement(result.props[i]);
            }
            Enumeration e = desc.elements();
            while (e.hasMoreElements()) {
                TypeStruct ts = (TypeStruct)e.nextElement();
                for (int i = 0; i < ts.props.length; ++i) {
                    boolean found = false;
                    Enumeration p = props.elements();
                    while (p.hasMoreElements() && !found) {
                        PropStruct ps = (PropStruct)p.nextElement();
                        if (!ts.props[i].name.equals(ps.name)) continue;
                        found = true;
                    }
                    if (found) continue;
                    props.addElement(ts.props[i]);
                }
            }
            result.props = new PropStruct[props.size()];
            props.copyInto(result.props);
        }
        finally {
            this.m_database.end();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mask_type(String name) throws IllegalServiceType, UnknownServiceType, AlreadyMasked {
        try {
            this.m_database.begin(1);
            this.checkTypeName(name);
            TypeStruct ts = this.findType(name);
            if (ts.masked) {
                throw new AlreadyMasked(name);
            }
            if (!this.m_database.maskType(name)) {
                throw new UnknownServiceType(name);
            }
        }
        finally {
            this.m_database.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmask_type(String name) throws IllegalServiceType, UnknownServiceType, NotMasked {
        try {
            this.m_database.begin(1);
            this.checkTypeName(name);
            TypeStruct ts = this.findType(name);
            if (!ts.masked) {
                throw new NotMasked(name);
            }
            if (!this.m_database.unmaskType(name)) {
                throw new UnknownServiceType(name);
            }
        }
        finally {
            this.m_database.end();
        }
    }

    protected void checkTypeName(String name) throws IllegalServiceType {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalServiceType("");
        }
        StringTokenizer tokenizer = new StringTokenizer(name, ":", true);
        boolean seenIdent = false;
        String lastToken = null;
        int colonCount = 0;
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.equals(":")) {
                if (++colonCount > 2) {
                    throw new IllegalServiceType(name);
                }
            } else {
                colonCount = 0;
                seenIdent = true;
                if (!Character.isLetter(tok.charAt(0))) {
                    throw new IllegalServiceType(name);
                }
                for (int i = 1; i < tok.length(); ++i) {
                    char ch = tok.charAt(i);
                    if (Character.isLetterOrDigit(ch) || ch == '_') continue;
                    throw new IllegalServiceType(name);
                }
            }
            lastToken = tok;
        }
        if (!seenIdent) {
            throw new IllegalServiceType(name);
        }
        if (lastToken.equals(":")) {
            throw new IllegalServiceType(name);
        }
    }

    protected TypeStruct findType(String name) throws UnknownServiceType {
        TypeStruct result = this.m_database.describeType(name);
        if (result == null) {
            throw new UnknownServiceType(name);
        }
        return result;
    }

    protected void validateInterface(String name, String interfaceName, String[] superTypes, Hashtable typeInfo) throws InterfaceTypeMismatch {
        if (this.m_interfaceRepos != null) {
            InterfaceDef def = null;
            try {
                Contained c = this.m_interfaceRepos.lookup(interfaceName);
                if (c != null) {
                    def = InterfaceDefHelper.narrow(c);
                }
            }
            catch (SystemException e) {
                // empty catch block
            }
            if (def != null) {
                for (int i = 0; i < superTypes.length; ++i) {
                    try {
                        String id;
                        TypeStruct ts = (TypeStruct)typeInfo.get(superTypes[i]);
                        Contained c = this.m_interfaceRepos.lookup(ts.if_name);
                        if (c != null && !def.is_a(id = c.id())) {
                            throw new InterfaceTypeMismatch(superTypes[i], ts.if_name, name, interfaceName);
                        }
                        continue;
                    }
                    catch (SystemException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void validateProperties(String name, PropStruct[] props, String[] superTypes, Hashtable typeInfo) throws IllegalPropertyName, DuplicatePropertyName, ValueTypeRedefinition {
        Vector<String> goodProps = new Vector<String>();
        for (int i = 0; i < props.length; ++i) {
            if (goodProps.contains(props[i].name)) {
                throw new DuplicatePropertyName(props[i].name);
            }
            for (int s = 0; s < superTypes.length; ++s) {
                TypeStruct ts = (TypeStruct)typeInfo.get(superTypes[s]);
                Vector superProps = new Vector();
                this.findProperties(ts, props[i].name, superProps, typeInfo);
                Enumeration e = superProps.elements();
                while (e.hasMoreElements()) {
                    PropStruct ps = (PropStruct)e.nextElement();
                    if (props[i].value_type.equal(ps.value_type) && this.validateMode(props[i].mode, ps.mode)) continue;
                    throw new ValueTypeRedefinition(name, props[i], superTypes[s], ps);
                }
            }
            goodProps.addElement(props[i].name);
        }
    }

    protected boolean validateMode(PropertyMode subMode, PropertyMode superMode) {
        boolean result = false;
        if (superMode == subMode) {
            result = true;
        } else if (superMode == PropertyMode.PROP_NORMAL) {
            result = true;
        } else if (superMode == PropertyMode.PROP_READONLY && (subMode == PropertyMode.PROP_READONLY || subMode == PropertyMode.PROP_MANDATORY_READONLY)) {
            result = true;
        } else if (superMode == PropertyMode.PROP_MANDATORY && (subMode == PropertyMode.PROP_MANDATORY || subMode == PropertyMode.PROP_MANDATORY_READONLY)) {
            result = true;
        } else if (superMode == PropertyMode.PROP_MANDATORY_READONLY && subMode == PropertyMode.PROP_MANDATORY_READONLY) {
            result = true;
        }
        return result;
    }

    protected void findProperties(TypeStruct ts, String propName, Vector v, Hashtable typeInfo) {
        PropStruct prop = this.findProperty(ts, propName);
        if (prop != null) {
            v.addElement(prop);
        } else {
            for (int i = 0; i < ts.super_types.length; ++i) {
                TypeStruct superTS = (TypeStruct)typeInfo.get(ts.super_types[i]);
                this.findProperties(superTS, propName, v, typeInfo);
            }
        }
    }

    protected PropStruct findProperty(TypeStruct ts, String name) {
        PropStruct result = null;
        for (int i = 0; i < ts.props.length && result == null; ++i) {
            if (!name.equals(ts.props[i].name)) continue;
            result = ts.props[i];
        }
        return result;
    }
}

