/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Hashtable;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.impl.OfferUtil;
import org.jacorb.trading.impl.Recipe;
import org.jacorb.trading.impl.SupportAttrib;
import org.jacorb.trading.impl.TraderComp;
import org.omg.CORBA.Object;
import org.omg.CosTrading.Admin;
import org.omg.CosTrading.DuplicatePolicyName;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalOfferId;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.InvalidLookupRef;
import org.omg.CosTrading.Link;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.MissingMandatoryProperty;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.PropertyTypeMismatch;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.ProxyPOA;
import org.omg.CosTrading.ProxyPackage.IllegalRecipe;
import org.omg.CosTrading.ProxyPackage.NotProxyOfferId;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;
import org.omg.CosTrading.ReadonlyDynamicProperty;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.UnknownOfferId;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class ProxyImpl
extends ProxyPOA {
    private TraderComp m_traderComp;
    private SupportAttrib m_support;
    private OfferDatabase m_db;
    private ServiceTypeRepository m_repos;

    private ProxyImpl() {
    }

    public ProxyImpl(TraderComp traderComp, SupportAttrib supportAttrib, OfferDatabase db) {
        this.m_traderComp = traderComp;
        this.m_support = supportAttrib;
        this.m_db = db;
        Object obj = supportAttrib.getTypeRepos();
        this.m_repos = ServiceTypeRepositoryHelper.narrow(obj);
    }

    public Lookup lookup_if() {
        return this.m_traderComp.getLookupInterface();
    }

    public Register register_if() {
        return this.m_traderComp.getRegisterInterface();
    }

    public Link link_if() {
        return this.m_traderComp.getLinkInterface();
    }

    public Proxy proxy_if() {
        return this.m_traderComp.getProxyInterface();
    }

    public Admin admin_if() {
        return this.m_traderComp.getAdminInterface();
    }

    public boolean supports_modifiable_properties() {
        return this.m_support.getModifiableProperties();
    }

    public boolean supports_dynamic_properties() {
        return this.m_support.getDynamicProperties();
    }

    public boolean supports_proxy_offers() {
        return this.m_support.getProxyOffers();
    }

    public Object type_repos() {
        return this.m_support.getTypeRepos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export_proxy(Lookup target, String type, Property[] properties, boolean if_match_all, String recipe, Policy[] policies_to_pass_on) throws IllegalServiceType, UnknownServiceType, InvalidLookupRef, IllegalPropertyName, PropertyTypeMismatch, ReadonlyDynamicProperty, MissingMandatoryProperty, IllegalRecipe, DuplicatePropertyName, DuplicatePolicyName {
        String result = null;
        if (target == null) {
            throw new InvalidLookupRef(target);
        }
        TypeStruct ts = this.m_repos.fully_describe_type(type);
        if (ts.masked) {
            throw new UnknownServiceType(type);
        }
        OfferUtil.validateProperties(this.m_db, properties, type, ts);
        if (!Recipe.validate(recipe, properties)) {
            throw new IllegalRecipe(recipe);
        }
        Hashtable<String, Policy> policyTable = new Hashtable<String, Policy>();
        for (int i = 0; i < policies_to_pass_on.length; ++i) {
            if (policyTable.containsKey(policies_to_pass_on[i].name)) {
                throw new DuplicatePolicyName(policies_to_pass_on[i].name);
            }
            policyTable.put(policies_to_pass_on[i].name, policies_to_pass_on[i]);
        }
        this.m_db.begin(1);
        try {
            result = this.m_db.createProxy(target, type, properties, if_match_all, recipe, policies_to_pass_on);
        }
        finally {
            this.m_db.end();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withdraw_proxy(String id) throws IllegalOfferId, UnknownOfferId, NotProxyOfferId {
        if (!this.m_db.validateOfferId(id)) {
            throw new IllegalOfferId(id);
        }
        this.m_db.begin(1);
        try {
            if (!this.m_db.exists(id)) {
                throw new UnknownOfferId(id);
            }
            if (!this.m_db.isProxy(id)) {
                throw new NotProxyOfferId(id);
            }
            this.m_db.removeProxy(id);
        }
        finally {
            this.m_db.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyInfo describe_proxy(String id) throws IllegalOfferId, UnknownOfferId, NotProxyOfferId {
        ProxyInfo result;
        if (!this.m_db.validateOfferId(id)) {
            throw new IllegalOfferId(id);
        }
        this.m_db.begin(0);
        try {
            if (!this.m_db.exists(id)) {
                throw new UnknownOfferId(id);
            }
            if (!this.m_db.isProxy(id)) {
                throw new NotProxyOfferId(id);
            }
            result = this.m_db.describeProxy(id);
        }
        finally {
            this.m_db.end();
        }
        return result;
    }
}

