/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.util.PropUtil;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.MissingMandatoryProperty;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.PropertyTypeMismatch;
import org.omg.CosTrading.ReadonlyDynamicProperty;
import org.omg.CosTradingDynamic.DynamicProp;
import org.omg.CosTradingDynamic.DynamicPropHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class OfferUtil {
    private OfferUtil() {
    }

    public static void validateProperties(OfferDatabase db, Property[] exportProps, String typeName, TypeStruct type) throws IllegalPropertyName, PropertyTypeMismatch, ReadonlyDynamicProperty, MissingMandatoryProperty, DuplicatePropertyName {
        PropStruct ps;
        Hashtable<String, PropStruct> typeProps = new Hashtable<String, PropStruct>();
        for (int i = 0; i < type.props.length; ++i) {
            typeProps.put(type.props[i].name, type.props[i]);
        }
        Hashtable<String, Property> checkedProps = new Hashtable<String, Property>();
        for (int i = 0; i < exportProps.length; ++i) {
            ps = (PropStruct)typeProps.get(exportProps[i].name);
            if (ps != null) {
                if (checkedProps.containsKey(exportProps[i].name)) {
                    throw new DuplicatePropertyName(exportProps[i].name);
                }
                OfferUtil.checkProperty(typeName, exportProps[i], ps);
                checkedProps.put(exportProps[i].name, exportProps[i]);
            }
            if (db.isTypeSupported(exportProps[i].value)) continue;
            throw new PropertyTypeMismatch(typeName, exportProps[i]);
        }
        Enumeration e = typeProps.elements();
        while (e.hasMoreElements()) {
            ps = (PropStruct)e.nextElement();
            if (checkedProps.get(ps.name) != null || !OfferUtil.isMandatory(ps.mode)) continue;
            throw new MissingMandatoryProperty(typeName, ps.name);
        }
    }

    public static boolean isMandatory(PropertyMode mode) {
        boolean result = mode == PropertyMode.PROP_MANDATORY || mode == PropertyMode.PROP_MANDATORY_READONLY;
        return result;
    }

    public static boolean isReadonly(PropertyMode mode) {
        boolean result = mode == PropertyMode.PROP_READONLY || mode == PropertyMode.PROP_MANDATORY_READONLY;
        return result;
    }

    public static void checkProperty(String typeName, Property prop, PropStruct ps) throws PropertyTypeMismatch, ReadonlyDynamicProperty {
        try {
            TypeCode propType = ps.value_type;
            while (propType.kind() == TCKind.tk_alias) {
                propType = propType.content_type();
            }
            if (PropUtil.isDynamicProperty(prop.value.type())) {
                if (OfferUtil.isReadonly(ps.mode)) {
                    throw new ReadonlyDynamicProperty(typeName, prop.name);
                }
                DynamicProp dp = DynamicPropHelper.extract(prop.value);
                TypeCode tc = dp.returned_type;
                while (tc.kind() == TCKind.tk_alias) {
                    tc = tc.content_type();
                }
                if (!tc.equal(propType)) {
                    throw new PropertyTypeMismatch(typeName, prop);
                }
            } else {
                TypeCode tc = prop.value.type();
                while (tc.kind() == TCKind.tk_alias) {
                    tc = tc.content_type();
                }
                if (!tc.equal(propType)) {
                    throw new PropertyTypeMismatch(typeName, prop);
                }
            }
        }
        catch (BadKind e) {
            throw new RuntimeException();
        }
    }
}

