/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.impl.ImportAttrib;
import org.jacorb.trading.impl.LinkAttrib;
import org.jacorb.trading.impl.OfferIdIteratorImpl;
import org.jacorb.trading.impl.SupportAttrib;
import org.jacorb.trading.impl.TraderComp;
import org.omg.CORBA.Object;
import org.omg.CosTrading.Admin;
import org.omg.CosTrading.AdminPOA;
import org.omg.CosTrading.FollowOption;
import org.omg.CosTrading.Link;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.NotImplemented;
import org.omg.CosTrading.OfferIdIteratorHolder;
import org.omg.CosTrading.OfferIdSeqHolder;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.Register;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;

public class AdminImpl
extends AdminPOA {
    private TraderComp m_traderComp;
    private SupportAttrib m_support;
    private ImportAttrib m_import;
    private LinkAttrib m_link;
    private OfferDatabase m_db;
    private ServiceTypeRepository m_repos;
    private byte[] m_request_id_stem;

    private AdminImpl() {
    }

    public AdminImpl(TraderComp traderComp, SupportAttrib supportAttrib, ImportAttrib importAttrib, LinkAttrib linkAttrib, OfferDatabase db, byte[] stem) {
        this.m_traderComp = traderComp;
        this.m_support = supportAttrib;
        this.m_import = importAttrib;
        this.m_link = linkAttrib;
        this.m_db = db;
        Object obj = supportAttrib.getTypeRepos();
        this.m_repos = ServiceTypeRepositoryHelper.narrow(obj);
        this.m_request_id_stem = stem;
    }

    public Lookup lookup_if() {
        return this.m_traderComp.getLookupInterface();
    }

    public Register register_if() {
        return this.m_traderComp.getRegisterInterface();
    }

    public Link link_if() {
        return this.m_traderComp.getLinkInterface();
    }

    public Proxy proxy_if() {
        return this.m_traderComp.getProxyInterface();
    }

    public Admin admin_if() {
        return this.m_traderComp.getAdminInterface();
    }

    public boolean supports_modifiable_properties() {
        return this.m_support.getModifiableProperties();
    }

    public boolean supports_dynamic_properties() {
        return this.m_support.getDynamicProperties();
    }

    public boolean supports_proxy_offers() {
        return this.m_support.getProxyOffers();
    }

    public Object type_repos() {
        return this.m_support.getTypeRepos();
    }

    public int def_search_card() {
        return this.m_import.getDefSearchCard();
    }

    public int max_search_card() {
        return this.m_import.getMaxSearchCard();
    }

    public int def_match_card() {
        return this.m_import.getDefMatchCard();
    }

    public int max_match_card() {
        return this.m_import.getMaxMatchCard();
    }

    public int def_return_card() {
        return this.m_import.getDefReturnCard();
    }

    public int max_return_card() {
        return this.m_import.getMaxReturnCard();
    }

    public int max_list() {
        return this.m_import.getMaxList();
    }

    public int def_hop_count() {
        return this.m_import.getDefHopCount();
    }

    public int max_hop_count() {
        return this.m_import.getMaxHopCount();
    }

    public FollowOption def_follow_policy() {
        return this.m_import.getDefFollowPolicy();
    }

    public FollowOption max_follow_policy() {
        return this.m_import.getMaxFollowPolicy();
    }

    public FollowOption max_link_follow_policy() {
        return this.m_link.getMaxLinkFollowPolicy();
    }

    public byte[] request_id_stem() {
        return this.m_request_id_stem;
    }

    public int set_def_search_card(int value) {
        return this.m_import.setDefSearchCard(value);
    }

    public int set_max_search_card(int value) {
        return this.m_import.setMaxSearchCard(value);
    }

    public int set_def_match_card(int value) {
        return this.m_import.setDefMatchCard(value);
    }

    public int set_max_match_card(int value) {
        return this.m_import.setMaxMatchCard(value);
    }

    public int set_def_return_card(int value) {
        return this.m_import.setDefReturnCard(value);
    }

    public int set_max_return_card(int value) {
        return this.m_import.setMaxReturnCard(value);
    }

    public int set_max_list(int value) {
        return this.m_import.setMaxList(value);
    }

    public boolean set_supports_modifiable_properties(boolean value) {
        return this.m_support.setModifiableProperties(value);
    }

    public boolean set_supports_dynamic_properties(boolean value) {
        return this.m_support.setDynamicProperties(value);
    }

    public boolean set_supports_proxy_offers(boolean value) {
        return this.m_support.setProxyOffers(value);
    }

    public int set_def_hop_count(int value) {
        return this.m_import.setDefHopCount(value);
    }

    public int set_max_hop_count(int value) {
        return this.m_import.setMaxHopCount(value);
    }

    public FollowOption set_def_follow_policy(FollowOption policy) {
        return this.m_import.setDefFollowPolicy(policy);
    }

    public FollowOption set_max_follow_policy(FollowOption policy) {
        return this.m_import.setMaxFollowPolicy(policy);
    }

    public FollowOption set_max_link_follow_policy(FollowOption policy) {
        return this.m_link.setMaxLinkFollowPolicy(policy);
    }

    public Object set_type_repos(Object repository) {
        return this.m_support.setTypeRepos(repository);
    }

    public byte[] set_request_id_stem(byte[] stem) {
        byte[] _old = this.m_request_id_stem;
        this.m_request_id_stem = stem;
        return _old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void list_offers(int how_many, OfferIdSeqHolder ids, OfferIdIteratorHolder id_itr) throws NotImplemented {
        SpecifiedServiceTypes whichTypes = new SpecifiedServiceTypes();
        whichTypes.__default();
        String[] allNames = this.m_repos.list_types(whichTypes);
        try {
            this.m_db.begin(0);
            Vector<String> vec = new Vector<String>();
            for (int i = 0; i < allNames.length; ++i) {
                String[] seq = this.m_db.getOfferIds(allNames[i]);
                if (seq == null) continue;
                for (int n = 0; n < seq.length; ++n) {
                    vec.addElement(seq[n]);
                }
            }
            int offerCount = vec.size();
            int seqCount = Math.min(offerCount, how_many);
            ids.value = new String[seqCount];
            Enumeration e = vec.elements();
            for (int count = 0; e.hasMoreElements() && count < seqCount; ++count) {
                String id;
                ids.value[count] = id = (String)e.nextElement();
            }
            if (seqCount < offerCount) {
                int restCount = offerCount - seqCount;
                String[] rest = new String[restCount];
                for (int pos = 0; e.hasMoreElements() && pos < restCount; ++pos) {
                    String id;
                    rest[pos] = id = (String)e.nextElement();
                }
                OfferIdIteratorImpl iter = new OfferIdIteratorImpl(rest);
                iter._this_object(this._orb());
                id_itr.value = iter._this();
            }
        }
        finally {
            this.m_db.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void list_proxies(int how_many, OfferIdSeqHolder ids, OfferIdIteratorHolder id_itr) throws NotImplemented {
        SpecifiedServiceTypes whichTypes = new SpecifiedServiceTypes();
        whichTypes.__default();
        String[] allNames = this.m_repos.list_types(whichTypes);
        try {
            this.m_db.begin(0);
            Vector<String> vec = new Vector<String>();
            for (int i = 0; i < allNames.length; ++i) {
                String[] seq = this.m_db.getProxyOfferIds(allNames[i]);
                if (seq == null) continue;
                for (int n = 0; n < seq.length; ++n) {
                    vec.addElement(seq[n]);
                }
            }
            int offerCount = vec.size();
            int seqCount = Math.min(offerCount, how_many);
            ids.value = new String[seqCount];
            Enumeration e = vec.elements();
            for (int count = 0; e.hasMoreElements() && count < seqCount; ++count) {
                String id;
                ids.value[count] = id = (String)e.nextElement();
            }
            if (seqCount < offerCount) {
                int restCount = offerCount - seqCount;
                String[] rest = new String[restCount];
                for (int pos = 0; e.hasMoreElements() && pos < restCount; ++pos) {
                    String id;
                    rest[pos] = id = (String)e.nextElement();
                }
                OfferIdIteratorImpl iter = new OfferIdIteratorImpl(rest);
                iter._this_object(this._orb());
                id_itr.value = iter._this();
            }
        }
        finally {
            this.m_db.end();
        }
    }
}

