/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.types;

import java.io.Serializable;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;

public class TypeProperty
implements Serializable {
    private String m_name;
    private int m_kind;
    private boolean m_sequence;
    private int m_mode;
    static final long serialVersionUID = 3756829227846447959L;

    public TypeProperty() {
    }

    public TypeProperty(PropStruct ps) {
        this.m_name = ps.name;
        this.m_mode = ps.mode.value();
        TCKind kind = ps.value_type.kind();
        if (kind == TCKind.tk_sequence) {
            this.m_sequence = true;
            try {
                TypeCode elemTC = ps.value_type.content_type();
                kind = elemTC.kind();
                this.m_kind = kind.value();
            }
            catch (BadKind e) {
                throw new RuntimeException();
            }
        } else {
            this.m_sequence = false;
            this.m_kind = kind.value();
        }
    }

    public String getName() {
        return this.m_name;
    }

    public PropStruct describe() {
        PropStruct result = new PropStruct();
        ORB orb = ORB.init();
        result.name = this.m_name;
        if (this.m_sequence) {
            TypeCode contentType = orb.get_primitive_tc(TCKind.from_int(this.m_kind));
            result.value_type = orb.create_sequence_tc(0, contentType);
        } else {
            result.value_type = orb.get_primitive_tc(TCKind.from_int(this.m_kind));
        }
        result.mode = PropertyMode.from_int(this.m_mode);
        return result;
    }

    public boolean equals(Object o) {
        TypeProperty prop = (TypeProperty)o;
        return this.m_name.equals(prop.getName());
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }
}

