/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.trading.db.TypeDatabase;
import org.jacorb.trading.db.simple.types.Incarnation;
import org.jacorb.trading.db.simple.types.Type;
import org.jacorb.trading.util.RWLock;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.IncarnationNumber;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class TypeDatabaseImpl
implements TypeDatabase {
    private Incarnation m_incarnation;
    private Hashtable m_types;
    private RWLock m_lock;
    private File m_dbFile;
    private boolean m_dirty = false;
    private static final String DB_FILE = "types.dat";

    private TypeDatabaseImpl() {
    }

    public TypeDatabaseImpl(String dirName) {
        this.m_dbFile = new File(dirName, DB_FILE);
        if (this.m_dbFile.exists()) {
            this.readObjects();
        } else {
            this.m_incarnation = new Incarnation();
            this.m_types = new Hashtable();
            this.writeObjects();
        }
        this.m_lock = new RWLock();
    }

    public void begin(int mode) {
        if (mode == 0) {
            this.m_lock.acquireRead();
        } else if (mode == 1) {
            this.m_lock.acquireWrite();
        } else {
            throw new RuntimeException("Invalid lock mode");
        }
    }

    public void end() {
        if (this.m_dirty) {
            this.writeObjects();
            this.m_dirty = false;
        }
        this.m_lock.release();
    }

    public TypeStruct describeType(String name) {
        TypeStruct result = null;
        Type impl = (Type)this.m_types.get(name);
        if (impl != null) {
            result = impl.describe();
        }
        return result;
    }

    public boolean maskType(String name) {
        boolean result = false;
        Type impl = (Type)this.m_types.get(name);
        if (impl != null) {
            impl.mask();
            this.m_dirty = true;
            result = true;
        }
        return result;
    }

    public boolean unmaskType(String name) {
        boolean result = false;
        Type impl = (Type)this.m_types.get(name);
        if (impl != null) {
            impl.unmask();
            this.m_dirty = true;
            result = true;
        }
        return result;
    }

    public String[] getTypes() {
        String[] result = new String[this.m_types.size()];
        Enumeration e = this.m_types.keys();
        int count = 0;
        while (e.hasMoreElements()) {
            result[count++] = (String)e.nextElement();
        }
        return result;
    }

    public String[] getTypesSince(IncarnationNumber inc) {
        Vector<String> types = new Vector<String>();
        Incarnation i = new Incarnation(inc);
        Enumeration e = this.m_types.elements();
        while (e.hasMoreElements()) {
            Type type = (Type)e.nextElement();
            if (type.getIncarnation().compareTo(i) < 0) continue;
            types.addElement(type.getName());
        }
        String[] result = new String[types.size()];
        types.copyInto(result);
        return result;
    }

    public IncarnationNumber getIncarnation() {
        return this.m_incarnation.getIncarnationNumber();
    }

    public IncarnationNumber createType(String name, String interfaceName, PropStruct[] props, String[] superTypes) {
        IncarnationNumber result = null;
        result = this.m_incarnation.getIncarnationNumber();
        Type type = new Type(name, interfaceName, props, superTypes, result);
        this.m_types.put(name, type);
        this.m_incarnation.increment();
        this.m_dirty = true;
        return result;
    }

    public boolean removeType(String name) {
        boolean result = false;
        if (this.m_types.containsKey(name)) {
            this.m_types.remove(name);
            this.m_dirty = true;
            result = true;
        }
        return result;
    }

    public String findSubType(String name) {
        String result = null;
        Enumeration e = this.m_types.elements();
        block0: while (e.hasMoreElements() && result == null) {
            Type type = (Type)e.nextElement();
            String[] superTypes = type.getSuperTypes();
            for (int t = 0; t < superTypes.length; ++t) {
                if (!name.equals(superTypes[t])) continue;
                result = type.getName();
                continue block0;
            }
        }
        return result;
    }

    public String[] getAllSuperTypes(String name) {
        String[] result = null;
        Type type = (Type)this.m_types.get(name);
        if (type != null) {
            Vector vec = this.findAllSuperTypes(type);
            result = new String[vec.size()];
            vec.copyInto(result);
        }
        return result;
    }

    protected void readObjects() {
        try {
            FileInputStream fileIn = new FileInputStream(this.m_dbFile);
            ObjectInputStream objIn = new ObjectInputStream(fileIn);
            this.m_incarnation = (Incarnation)objIn.readObject();
            this.m_types = (Hashtable)objIn.readObject();
            fileIn.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void writeObjects() {
        try {
            FileOutputStream fileOut = new FileOutputStream(this.m_dbFile);
            ObjectOutputStream objOut = new ObjectOutputStream(fileOut);
            objOut.writeObject(this.m_incarnation);
            objOut.writeObject(this.m_types);
            fileOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected Vector findAllSuperTypes(Type type) {
        Vector<String> result = new Vector<String>();
        String[] supers = type.getSuperTypes();
        for (int i = 0; i < supers.length; ++i) {
            result.addElement(supers[i]);
            Type impl = (Type)this.m_types.get(supers[i]);
            Vector v = this.findAllSuperTypes(impl);
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (result.contains(s)) continue;
                result.addElement(s);
            }
        }
        return result;
    }
}

