/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.IncarnationNumber;

public class Incarnation
implements Serializable {
    private long m_high;
    private long m_low;
    private transient boolean m_dirty;
    private static final long MAX_VALUE = 0xFFFFFFFFL;
    static final long serialVersionUID = -6506601918195268342L;

    private Incarnation(long high, long low) {
        this.m_high = high;
        this.m_low = low;
        this.m_dirty = true;
    }

    public Incarnation() {
        this.m_high = 0L;
        this.m_low = 1L;
        this.m_dirty = true;
    }

    public Incarnation(IncarnationNumber inc) {
        this.m_high = inc.high;
        this.m_low = inc.low;
        this.m_dirty = true;
    }

    public IncarnationNumber getIncarnationNumber() {
        return new IncarnationNumber((int)this.m_high, (int)this.m_low);
    }

    public int compareTo(Incarnation inc) {
        int result = this.m_high < inc.m_high || this.m_high == inc.m_high && this.m_low < inc.m_low ? -1 : (this.m_high == inc.m_high && this.m_low == inc.m_low ? 0 : 1);
        return result;
    }

    public void increment() {
        if (this.m_low < 0xFFFFFFFFL) {
            ++this.m_low;
        } else {
            this.m_low = 0L;
            ++this.m_high;
        }
        this.m_dirty = true;
    }

    public boolean getDirty() {
        return this.m_dirty;
    }

    public String toString() {
        return "{" + this.m_high + "," + this.m_low + "}";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.m_dirty = false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_dirty = false;
    }
}

