/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.offers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.db.simple.offers.AnyValue;
import org.jacorb.trading.db.simple.offers.OfferList;
import org.jacorb.trading.util.PropUtil;
import org.jacorb.trading.util.RWLock;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;
import org.omg.CosTrading.RegisterPackage.OfferInfo;
import org.omg.CosTradingDynamic.DynamicProp;
import org.omg.CosTradingDynamic.DynamicPropHelper;

public class OfferDatabaseImpl
implements OfferDatabase {
    private File m_dirPath;
    private Hashtable m_offerLists;
    private Hashtable m_offerIndex;
    private File m_indexFile;
    private int m_counter;
    private boolean m_indexDirty = false;
    private RWLock m_lock;
    private static String LIST_NAME = "OFR_";
    private static String LIST_EXT = ".dat";
    private static String INDEX_FILE = "offeridx.dat";

    private OfferDatabaseImpl() {
    }

    public OfferDatabaseImpl(String dirPath) {
        this.m_dirPath = new File(dirPath);
        this.m_indexFile = new File(dirPath, INDEX_FILE);
        if (this.m_indexFile.exists()) {
            this.readIndex();
        } else {
            this.m_offerIndex = new Hashtable();
            this.m_counter = 0;
            this.writeIndex();
        }
        this.m_offerLists = new Hashtable();
        this.m_lock = new RWLock();
    }

    public boolean validateOfferId(String offerId) {
        return OfferList.validateOfferId(offerId);
    }

    public boolean isTypeSupported(Any any) {
        boolean result;
        if (PropUtil.isDynamicProperty(any.type())) {
            DynamicProp dp = DynamicPropHelper.extract(any);
            result = AnyValue.isTypeSupported(dp.extra_info.type());
        } else {
            result = AnyValue.isTypeSupported(any.type());
        }
        return result;
    }

    public void begin(int mode) {
        if (mode == 0) {
            this.m_lock.acquireRead();
        } else if (mode == 1) {
            this.m_lock.acquireWrite();
        } else {
            throw new RuntimeException("Invalid lock mode");
        }
    }

    public void end() {
        Enumeration e = this.m_offerLists.elements();
        while (e.hasMoreElements()) {
            OfferList list = (OfferList)e.nextElement();
            if (!list.getDirty()) continue;
            this.writeList(list);
        }
        if (this.m_indexDirty) {
            this.writeIndex();
            this.m_indexDirty = false;
        }
        this.m_lock.release();
    }

    public boolean exists(String offerId) {
        boolean result = false;
        OfferList list = this.getList(this.whichService(offerId));
        if (list != null) {
            result = list.exists(offerId);
        }
        return result;
    }

    public boolean isProxy(String offerId) {
        boolean result = false;
        OfferList list = this.getList(this.whichService(offerId));
        if (list != null) {
            result = list.isProxy(offerId);
        }
        return result;
    }

    public String create(String serviceType, Object obj, Property[] props) {
        OfferList list = this.getList(serviceType);
        if (list == null) {
            list = this.createList(serviceType);
        }
        return list.create(obj, props);
    }

    public String createProxy(Lookup target, String serviceType, Property[] props, boolean ifMatchAll, String recipe, Policy[] policies) {
        OfferList list = this.getList(serviceType);
        if (list == null) {
            list = this.createList(serviceType);
        }
        return list.createProxy(target, props, ifMatchAll, recipe, policies);
    }

    public void remove(String offerId) {
        OfferList list = this.getList(this.whichService(offerId));
        if (list != null) {
            list.remove(offerId);
        }
    }

    public void removeProxy(String offerId) {
        OfferList list = this.getList(this.whichService(offerId));
        if (list != null) {
            list.removeProxy(offerId);
        }
    }

    public OfferInfo describe(String offerId) {
        OfferInfo result = null;
        OfferList list = this.getList(this.whichService(offerId));
        if (list != null) {
            result = list.describe(offerId);
        }
        return result;
    }

    public ProxyInfo describeProxy(String offerId) {
        ProxyInfo result = null;
        OfferList list = this.getList(this.whichService(offerId));
        if (list != null) {
            result = list.describeProxy(offerId);
        }
        return result;
    }

    public void modify(String offerId, Property[] props) {
        OfferList list = this.getList(this.whichService(offerId));
        if (list != null) {
            list.modify(offerId, props);
        }
    }

    public Hashtable getOffers(String serviceType) {
        Hashtable result = null;
        OfferList list = this.getList(serviceType);
        if (list != null) {
            result = list.getOffers();
        }
        return result;
    }

    public String[] getOfferIds(String serviceType) {
        String[] result = null;
        OfferList list = this.getList(serviceType);
        if (list != null) {
            result = list.getOfferIds();
        }
        return result;
    }

    public Hashtable getProxyOffers(String serviceType) {
        Hashtable result = null;
        OfferList list = this.getList(serviceType);
        if (list != null) {
            result = list.getProxyOffers();
        }
        return result;
    }

    public String[] getProxyOfferIds(String serviceType) {
        String[] result = null;
        OfferList list = this.getList(serviceType);
        if (list != null) {
            result = list.getProxyOfferIds();
        }
        return result;
    }

    public String whichService(String offerId) {
        return OfferList.whichService(offerId);
    }

    protected synchronized OfferList getList(String serviceType) {
        OfferList result = null;
        result = (OfferList)this.m_offerLists.get(serviceType);
        if (result == null && (result = this.readList(serviceType)) != null) {
            this.m_offerLists.put(serviceType, result);
        }
        return result;
    }

    protected OfferList createList(String serviceType) {
        OfferList result = new OfferList(serviceType);
        this.m_offerLists.put(serviceType, result);
        ++this.m_counter;
        this.m_offerIndex.put(serviceType, new Integer(this.m_counter));
        this.m_indexDirty = true;
        return result;
    }

    protected OfferList readList(String serviceType) {
        OfferList result = null;
        File listFile = this.getListFile(serviceType);
        if (listFile != null && listFile.exists()) {
            try {
                FileInputStream fileIn = new FileInputStream(listFile);
                ObjectInputStream objIn = new ObjectInputStream(fileIn);
                result = (OfferList)objIn.readObject();
                fileIn.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return result;
    }

    protected void writeList(OfferList list) {
        try {
            File listFile = this.getListFile(list.getServiceType());
            if (listFile == null) {
                throw new RuntimeException("listFile should not be null!");
            }
            FileOutputStream fileOut = new FileOutputStream(listFile);
            ObjectOutputStream objOut = new ObjectOutputStream(fileOut);
            objOut.writeObject(list);
            fileOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected File getListFile(String serviceType) {
        File result = null;
        Integer counter = (Integer)this.m_offerIndex.get(serviceType);
        if (counter != null) {
            result = new File(this.m_dirPath, LIST_NAME + counter + LIST_EXT);
        }
        return result;
    }

    protected void readIndex() {
        try {
            FileInputStream fileIn = new FileInputStream(this.m_indexFile);
            ObjectInputStream objIn = new ObjectInputStream(fileIn);
            Integer i = (Integer)objIn.readObject();
            this.m_counter = i;
            this.m_offerIndex = (Hashtable)objIn.readObject();
            fileIn.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void writeIndex() {
        try {
            FileOutputStream fileOut = new FileOutputStream(this.m_indexFile);
            ObjectOutputStream objOut = new ObjectOutputStream(fileOut);
            objOut.writeObject(new Integer(this.m_counter));
            objOut.writeObject(this.m_offerIndex);
            fileOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

