/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

public class ValueType {
    private int m_id;
    private boolean m_sequence;
    private static String[] s_typeNames = new String[]{"BOOLEAN", "SHORT", "USHORT", "LONG", "ULONG", "FLOAT", "DOUBLE", "CHAR", "STRING", "OTHER"};
    private static String[] s_longTypeNames = new String[]{"boolean", "short", "unsigned short", "long", "unsigned long", "float", "double", "char", "string", "other"};
    public static final int BOOLEAN = 0;
    public static final int SHORT = 1;
    public static final int USHORT = 2;
    public static final int LONG = 3;
    public static final int ULONG = 4;
    public static final int FLOAT = 5;
    public static final int DOUBLE = 6;
    public static final int CHAR = 7;
    public static final int STRING = 8;
    public static final int OTHER = 9;
    public static final int NUMTYPES = 10;
    private static int[][] s_promoteTable = new int[][]{{0, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 3, 3, 3, 4, 5, 6, -1, -1, -1}, {-1, 3, 3, 3, 4, 5, 6, -1, -1, -1}, {-1, 3, 3, 3, 4, 5, 6, -1, -1, -1}, {-1, 4, 4, 4, 4, 5, 6, -1, -1, -1}, {-1, 5, 5, 5, 5, 5, 6, -1, -1, -1}, {-1, 6, 6, 6, 6, 6, 6, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, 7, 8, -1}, {-1, -1, -1, -1, -1, -1, -1, 8, 8, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};

    public ValueType() {
        this(9, false);
    }

    public ValueType(int id) {
        this(id, false);
    }

    public ValueType(int id, boolean sequence) {
        this.m_id = id;
        this.m_sequence = sequence;
    }

    public ValueType(ValueType type) {
        this.m_id = type.m_id;
        this.m_sequence = type.m_sequence;
    }

    public boolean equals(ValueType type) {
        return this.m_id == type.m_id && this.m_sequence == type.m_sequence;
    }

    public int getId() {
        return this.m_id;
    }

    public boolean isSequence() {
        return this.m_sequence;
    }

    public boolean isNumber() {
        return this.checkNumeric(this.m_id);
    }

    public String getTypeName() {
        return s_typeNames[this.m_id];
    }

    public static String getTypeName(int id) {
        return s_typeNames[id];
    }

    public String getLongTypeName() {
        return s_longTypeNames[this.m_id];
    }

    public static String getLongTypeName(int id) {
        return s_longTypeNames[id];
    }

    public String toString() {
        String result = this.m_sequence ? "sequence<" + this.getLongTypeName() + ">" : this.getLongTypeName();
        return result;
    }

    public static boolean isCompatible(int id1, int id2) {
        return s_promoteTable[id1][id2] != -1;
    }

    public static int promote(int id1, int id2) {
        int result = s_promoteTable[id1][id2];
        return result;
    }

    protected boolean checkNumeric(int id) {
        boolean result = id != 8 && id != 9 && id != 0;
        return result;
    }
}

